/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.google.gson.Gson;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.appData.UserOnBoard;
import com.hippoagent.database.CommonData;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.eventbus.ProfileData;
import com.hippoagent.fragments.ChangePasswordFragment;
import com.hippoagent.fragments.EditProfileFragment;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.filelogger.Logger;
import io.paperdb.Paper;
import java.util.HashMap;
import retrofit2.Callback;

public class ProfileActivityName
extends FuguBaseActivity
implements View.OnClickListener {
    private Toolbar toolbar;
    private int userOnBoardingValue = 0;
    private boolean onboardClassFinish = true;
    private boolean isOpenAnotherFrag = false;
    private boolean isChangePass = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_profile);
        this.toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.toolbar.setVisibility(8);
        if (this.getIntent().hasExtra("user_onboard_value")) {
            this.userOnBoardingValue = this.getIntent().getIntExtra("user_onboard_value", 0);
            this.onboardClassFinish = this.getIntent().getBooleanExtra("onboard_class_finish", true);
        } else if (savedInstanceState != null) {
            this.userOnBoardingValue = savedInstanceState.getInt("user_onboard_value", 0);
            this.onboardClassFinish = savedInstanceState.getBoolean("onboard_class_finish", true);
        }
        this.openScreens(this.userOnBoardingValue);
    }

    private void openScreens(int userOnBoardingValue) {
        switch (UserOnBoard.get(userOnBoardingValue)) {
            case ONLY_NAME: {
                this.openEditScreenFragment();
                break;
            }
            case ONLY_PASSWORD: {
                this.openPasswordFragment();
                break;
            }
            case BOTH_NAME_PASSWORD: {
                this.openEditScreenFragment();
                break;
            }
            default: {
                Bundle bundle = new Bundle();
                if (this.getIntent().hasExtra("isEditable")) {
                    bundle.putBoolean("isEditable", true);
                }
                if (!this.getIntent().hasExtra("fragment_type") || this.getIntent().getIntExtra("fragment_type", 0) != 1) break;
                ChangePasswordFragment fragment = new ChangePasswordFragment();
                this.getSupportFragmentManager().beginTransaction().add(R.id.llContainer, (Fragment)fragment, ChangePasswordFragment.class.getName()).commit();
            }
        }
    }

    private void openEditScreenFragment() {
        EditProfileFragment editProfileFragment = new EditProfileFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("user_onboard_value", this.userOnBoardingValue);
        editProfileFragment.setArguments(bundle);
        this.setClickBool(true, false);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.llContainer, (Fragment)editProfileFragment, EditProfileFragment.class.getName()).commit();
    }

    private ChangePasswordFragment getChangePasswordFragment() {
        return (ChangePasswordFragment)this.getSupportFragmentManager().findFragmentByTag(ChangePasswordFragment.class.getName());
    }

    public void openPasswordFragment() {
        this.setClickBool(true, true);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.llContainer, (Fragment)ChangePasswordFragment.newInstance(this.userOnBoardingValue), ChangePasswordFragment.class.getName()).commit();
    }

    public void setClickBool(boolean isClicked, boolean isChange) {
        this.isOpenAnotherFrag = isClicked;
        this.isChangePass = isChange;
    }

    public void afterAgentOnBoard() {
        HippoApplication.getInstance().getUserData().setAgentOnboardingComplete(0);
        HippoApplication.getInstance().saveUserData(HippoApplication.getInstance().getUserData());
        if (this.onboardClassFinish) {
            super.onBackPressed();
        } else {
            this.finish();
            this.startActivity(new Intent((Context)this, HomeActivity.class));
        }
    }

    public void onBackPressed() {
        if (this.userOnBoardingValue == 0) {
            if (this.isOpenAnotherFrag) {
                Intent intent = new Intent((Context)this, HomeActivity.class);
                this.startActivity(intent);
                this.finish();
            } else {
                super.onBackPressed();
            }
        }
    }

    public void onClick(View v) {
    }

    public void getAgentData() {
        this.getAgentData(false);
    }

    public void getAgentData(boolean flag) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", String.valueOf(HippoApplication.getInstance().getUserData().getAccessToken()));
        params.put("en_user_id", String.valueOf(HippoApplication.getInstance().getUserData().getEnUserId()));
        CommonParams commonParams = new CommonParams.Builder().addAll(params).build();
        Logger.INSTANCE.apiRequest("/api/agent/getInfo", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getAgentInfo(commonParams.getMap()).enqueue((Callback)new ResponseResolver<AgentProfileDetails>((Activity)this, Boolean.valueOf(!flag), Boolean.valueOf(true)){

            @Override
            public void success(AgentProfileDetails agentProfileDetails) {
                Logger.INSTANCE.apiResponse("/api/agent/getInfo", "");
                try {
                    Paper.book((String)CommonData.name).delete("agent_data");
                    Paper.book((String)CommonData.name).write("agent_data", (Object)agentProfileDetails);
                    HippoApplication.getInstance().getAgentProfileDetails().getData().setUserImage(agentProfileDetails.getData().getUserImage());
                    HippoApplication.getInstance().getUserData().setUserImage(agentProfileDetails.getData().getUserImage());
                    BusProvider.getInstance().post((Object)new ProfileData(1, agentProfileDetails));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Logger.INSTANCE.apiFailed("/api/agent/getInfo", e.getLocalizedMessage());
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("/api/agent/getInfo", error.getMessage());
            }
        });
    }
}

