/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfigAttributes;
import com.hippoagent.callback.LoginApiCallBack;
import com.hippoagent.callback.UnreadListener;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.model.unreadResponse.UnreadCountResponse;
import com.hippoagent.model.user_details.DeviceDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.ApiInterface;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.UniqueIMEIID;
import io.paperdb.Book;
import io.paperdb.Paper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import retrofit2.Callback;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J.\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J.\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ0\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J.\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u0017"}, d2={"Lcom/hippoagent/activities/LoginApi;", "Lcom/hippoagent/datastructure/FuguAppConstant;", "()V", "agentLoginInfo", "", "context", "Landroid/app/Activity;", "configAttributes", "Lcom/hippoagent/HippoConfigAttributes;", "loginApicallBack", "Lcom/hippoagent/callback/LoginApiCallBack;", "showLoader", "", "parseData", "getAgentToken", "getAgentTotalUnreadCount", "getAppVersion", "", "login", "loginApiHit", "commonParams", "Lcom/hippoagent/retrofit/CommonParams;", "loginAuthToken", "hippoagentsdk_release"})
public final class LoginApi
implements FuguAppConstant {
    public static final LoginApi INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void loginAuthToken(@NotNull Activity context, @NotNull HippoConfigAttributes configAttributes, @NotNull LoginApiCallBack loginApicallBack, boolean showLoader, boolean parseData) {
        void deviceDetailsJson;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)configAttributes, (String)"configAttributes");
        Intrinsics.checkParameterIsNotNull((Object)loginApicallBack, (String)"loginApicallBack");
        Gson gson = new GsonBuilder().create();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        try {
            JsonElement jsonElement = gson.toJsonTree((Object)new DeviceDetails(this.getAppVersion(context)).getDeviceDetails());
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"gson.toJsonTree(DeviceDe\u2026(context)).deviceDetails)");
            deviceDetailsJson.element = jsonElement.getAsJsonObject();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        CommonParams.Builder builder2 = new CommonParams.Builder();
        builder2.add("auth_token", configAttributes.getAuthToken());
        builder2.add("device_type", "1");
        builder2.add("device_token", configAttributes.getDeviceToken());
        builder2.add("app_version_code", 260);
        builder2.add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)context));
        builder2.add("device_details", (JsonObject)deviceDetailsJson.element);
        builder2.add("source", String.valueOf(2));
        builder2.add("ignore_agent_status", 1);
        if (configAttributes.getIsWhitelabel()) {
            builder2.add("app_type", configAttributes.getAppType());
        }
        CommonParams commonParams = builder2.build();
        ApiInterface apiInterface = RestClient.getApiInterface();
        CommonParams commonParams2 = commonParams;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonParams2, (String)"commonParams");
        apiInterface.verifyAuthToken((Map<String, String>)commonParams2.getMap()).enqueue((Callback)new ResponseResolver<LoginResponse>(configAttributes, context, (Ref.ObjectRef)deviceDetailsJson, loginApicallBack, showLoader, parseData, context, Boolean.valueOf(showLoader), Boolean.valueOf(true)){
            final /* synthetic */ HippoConfigAttributes $configAttributes;
            final /* synthetic */ Activity $context;
            final /* synthetic */ Ref.ObjectRef $deviceDetailsJson;
            final /* synthetic */ LoginApiCallBack $loginApicallBack;
            final /* synthetic */ boolean $showLoader;
            final /* synthetic */ boolean $parseData;

            public void success(@NotNull LoginResponse loginResponse) {
                CommonParams commonParams1;
                Intrinsics.checkParameterIsNotNull((Object)loginResponse, (String)"loginResponse");
                CommonParams.Builder builder1 = new CommonParams.Builder();
                UserData userData = loginResponse.getUserData();
                Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"loginResponse.userData");
                builder1.add("access_token", userData.getAccessToken());
                builder1.add("device_type", "1");
                builder1.add("device_token", this.$configAttributes.getDeviceToken());
                builder1.add("app_version_code", 260);
                builder1.add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this.$context));
                builder1.add("device_details", (JsonObject)this.$deviceDetailsJson.element);
                builder1.add("source", String.valueOf(2));
                builder1.add("ignore_agent_status", 1);
                if (this.$configAttributes.getIsWhitelabel()) {
                    builder1.add("app_type", this.$configAttributes.getAppType());
                }
                builder1.add("fetch_business_lang", 1);
                if (this.$configAttributes.getCustomAttributes() != null && this.$configAttributes.getCustomAttributes().size() > 0 && !this.$configAttributes.getCustomAttributes().isEmpty()) {
                    builder1.add("custom_attributes", new JSONObject((Map)this.$configAttributes.getCustomAttributes()));
                }
                CommonParams commonParams = commonParams1 = builder1.build(true, this.$configAttributes.getLang());
                Intrinsics.checkExpressionValueIsNotNull((Object)commonParams, (String)"commonParams1");
                LoginApi.access$loginApiHit(LoginApi.INSTANCE, commonParams, this.$context, this.$loginApicallBack, this.$showLoader, this.$parseData);
            }

            public void failure(@Nullable APIError error) {
                this.$loginApicallBack.onApiFailed(error);
            }
            {
                this.$configAttributes = $captured_local_variable$0;
                this.$context = $captured_local_variable$1;
                this.$deviceDetailsJson = $captured_local_variable$2;
                this.$loginApicallBack = $captured_local_variable$3;
                this.$showLoader = $captured_local_variable$4;
                this.$parseData = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void getAgentToken(@NotNull Activity context, @NotNull HippoConfigAttributes configAttributes, @NotNull LoginApiCallBack loginApicallBack, boolean showLoader, boolean parseData) {
        void deviceDetailsJson;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)configAttributes, (String)"configAttributes");
        Intrinsics.checkParameterIsNotNull((Object)loginApicallBack, (String)"loginApicallBack");
        Gson gson = new GsonBuilder().create();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        try {
            JsonElement jsonElement = gson.toJsonTree((Object)new DeviceDetails(this.getAppVersion(context)).getDeviceDetails());
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"gson.toJsonTree(DeviceDe\u2026(context)).deviceDetails)");
            deviceDetailsJson.element = jsonElement.getAsJsonObject();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        CommonParams.Builder builder2 = new CommonParams.Builder();
        builder2.add("agent_secret_key", configAttributes.getAuthToken());
        builder2.add("device_type", "1");
        builder2.add("device_token", configAttributes.getDeviceToken());
        builder2.add("app_version_code", 260);
        builder2.add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)context));
        builder2.add("device_details", (JsonObject)deviceDetailsJson.element);
        builder2.add("source", String.valueOf(2));
        builder2.add("ignore_agent_status", 1);
        if (configAttributes.getIsWhitelabel()) {
            builder2.add("app_type", configAttributes.getAppType());
        }
        CommonParams commonParams = builder2.build();
        ApiInterface apiInterface = RestClient.getApiInterface();
        CommonParams commonParams2 = commonParams;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonParams2, (String)"commonParams");
        apiInterface.getAgentToken((Map<String, String>)commonParams2.getMap()).enqueue((Callback)new ResponseResolver<LoginResponse>(configAttributes, context, (Ref.ObjectRef)deviceDetailsJson, loginApicallBack, showLoader, parseData, context, Boolean.valueOf(showLoader), Boolean.valueOf(true)){
            final /* synthetic */ HippoConfigAttributes $configAttributes;
            final /* synthetic */ Activity $context;
            final /* synthetic */ Ref.ObjectRef $deviceDetailsJson;
            final /* synthetic */ LoginApiCallBack $loginApicallBack;
            final /* synthetic */ boolean $showLoader;
            final /* synthetic */ boolean $parseData;

            public void success(@NotNull LoginResponse loginResponse) {
                CommonParams commonParams1;
                Intrinsics.checkParameterIsNotNull((Object)loginResponse, (String)"loginResponse");
                CommonParams.Builder builder1 = new CommonParams.Builder();
                UserData userData = loginResponse.getUserData();
                Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"loginResponse.userData");
                builder1.add("access_token", userData.getAccessToken());
                builder1.add("device_type", "1");
                builder1.add("device_token", this.$configAttributes.getDeviceToken());
                builder1.add("app_version_code", 260);
                builder1.add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this.$context));
                builder1.add("device_details", (JsonObject)this.$deviceDetailsJson.element);
                builder1.add("source", String.valueOf(2));
                builder1.add("ignore_agent_status", 1);
                if (this.$configAttributes.getIsWhitelabel()) {
                    builder1.add("app_type", this.$configAttributes.getAppType());
                }
                builder1.add("fetch_business_lang", 1);
                if (this.$configAttributes.getCustomAttributes() != null && this.$configAttributes.getCustomAttributes().size() > 0 && !this.$configAttributes.getCustomAttributes().isEmpty()) {
                    builder1.add("custom_attributes", new JSONObject((Map)this.$configAttributes.getCustomAttributes()));
                }
                CommonParams commonParams = commonParams1 = builder1.build(true, this.$configAttributes.getLang());
                Intrinsics.checkExpressionValueIsNotNull((Object)commonParams, (String)"commonParams1");
                LoginApi.access$loginApiHit(LoginApi.INSTANCE, commonParams, this.$context, this.$loginApicallBack, this.$showLoader, this.$parseData);
            }

            public void failure(@Nullable APIError error) {
                this.$loginApicallBack.onApiFailed(error);
            }
            {
                this.$configAttributes = $captured_local_variable$0;
                this.$context = $captured_local_variable$1;
                this.$deviceDetailsJson = $captured_local_variable$2;
                this.$loginApicallBack = $captured_local_variable$3;
                this.$showLoader = $captured_local_variable$4;
                this.$parseData = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        });
    }

    public final void login(@NotNull Activity context, @NotNull HippoConfigAttributes configAttributes, @NotNull LoginApiCallBack loginApicallBack, boolean showLoader, boolean parseData) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)configAttributes, (String)"configAttributes");
        Intrinsics.checkParameterIsNotNull((Object)loginApicallBack, (String)"loginApicallBack");
        if (configAttributes.hasAccessToken()) {
            CommonParams commonParams;
            Gson gson = new GsonBuilder().create();
            JsonObject deviceDetailsJson = null;
            try {
                JsonElement jsonElement = gson.toJsonTree((Object)new DeviceDetails(this.getAppVersion(context)).getDeviceDetails());
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"gson.toJsonTree(DeviceDe\u2026(context)).deviceDetails)");
                deviceDetailsJson = jsonElement.getAsJsonObject();
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            CommonParams.Builder builder2 = new CommonParams.Builder();
            builder2.add("access_token", configAttributes.getAuthToken());
            builder2.add("device_type", "1");
            builder2.add("device_token", configAttributes.getDeviceToken());
            builder2.add("app_version_code", 260);
            builder2.add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)context));
            builder2.add("device_details", deviceDetailsJson);
            builder2.add("source", String.valueOf(2));
            builder2.add("ignore_agent_status", 1);
            if (configAttributes.getIsWhitelabel()) {
                builder2.add("app_type", configAttributes.getAppType());
            }
            builder2.add("fetch_business_lang", 1);
            CommonParams commonParams2 = commonParams = builder2.build(true, configAttributes.getLang());
            Intrinsics.checkExpressionValueIsNotNull((Object)commonParams2, (String)"commonParams");
            this.loginApiHit(commonParams2, context, loginApicallBack, showLoader, parseData);
        } else if (configAttributes.getIsForked()) {
            this.getAgentToken(context, configAttributes, loginApicallBack, showLoader, parseData);
        } else {
            this.loginAuthToken(context, configAttributes, loginApicallBack, showLoader, parseData);
        }
    }

    private final void loginApiHit(CommonParams commonParams, Activity context, LoginApiCallBack loginApicallBack, boolean showLoader, boolean parseData) {
        RestClient.getApiInterface().login((Map<String, String>)commonParams.getMap()).enqueue((Callback)new ResponseResolver<LoginResponse>(parseData, loginApicallBack, context, showLoader, context, Boolean.valueOf(showLoader), Boolean.valueOf(true)){
            final /* synthetic */ boolean $parseData;
            final /* synthetic */ LoginApiCallBack $loginApicallBack;
            final /* synthetic */ Activity $context;
            final /* synthetic */ boolean $showLoader;

            public void success(@NotNull LoginResponse loginResponse) {
                Intrinsics.checkParameterIsNotNull((Object)loginResponse, (String)"loginResponse");
                if (!this.$parseData) {
                    this.$loginApicallBack.onApiSuccess(loginResponse);
                    return;
                }
                HippoApplication.getInstance().clearUserData();
                try {
                    Integer n = loginResponse.getStatusCode();
                    if (n != null && ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == n.intValue()) {
                        Paper.book((String)CommonData.name).delete("user_data");
                        Paper.book((String)CommonData.name).write("user_data", (Object)loginResponse.getUserData());
                        Book book = Paper.book((String)CommonData.name);
                        UserData userData = loginResponse.getUserData();
                        Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"loginResponse.userData");
                        book.write("tags", userData.getTags());
                        Paper.book((String)CommonData.name).delete("latest_version");
                        this.$loginApicallBack.onApiSuccess(loginResponse);
                    } else {
                        Integer n2 = loginResponse.getStatusCode();
                        if (n2 != null && ApiResponseFlags.LOGIN_ERROR.getOrdinal() == n2.intValue()) {
                            Log.e("Error", "Something went wrong");
                            this.$loginApicallBack.onErrorMessage(loginResponse);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void failure(@Nullable APIError error) {
                this.$loginApicallBack.onApiFailed(error);
            }
            {
                this.$parseData = $captured_local_variable$0;
                this.$loginApicallBack = $captured_local_variable$1;
                this.$context = $captured_local_variable$2;
                this.$showLoader = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        });
    }

    private final void agentLoginInfo(Activity context, HippoConfigAttributes configAttributes, LoginApiCallBack loginApicallBack, boolean showLoader, boolean parseData) {
    }

    public final int getAppVersion(@NotNull Activity context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            return 260;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public final void getAgentTotalUnreadCount() {
        CommonParams.Builder builder2 = new CommonParams.Builder();
        HippoApplication hippoApplication = HippoApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
        UserData userData = hippoApplication.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
        CommonParams builder3 = builder2.add("access_token", userData.getAccessToken()).build();
        ApiInterface apiInterface = RestClient.getApiInterface();
        CommonParams commonParams = builder3;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonParams, (String)"builder");
        apiInterface.getAgentTotalUnreadCount((Map<String, String>)commonParams.getMap()).enqueue((Callback)new ResponseResolver<UnreadCountResponse>(){

            public void success(@Nullable UnreadCountResponse t) {
                try {
                    for (UnreadListener listener : HippoApplication.getInstance().getUIListeners(UnreadListener.class)) {
                        if (listener == null) continue;
                        Object object = t;
                        listener.setApiCountResponse(object != null && (object = ((UnreadCountResponse)object).getData()) != null ? ((UnreadCountResponse.Data)object).getAgentWiseCount() : null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void failure(@Nullable APIError error) {
            }
        });
    }

    private LoginApi() {
    }

    static {
        LoginApi loginApi;
        INSTANCE = loginApi = new LoginApi();
    }

    public static final /* synthetic */ void access$loginApiHit(LoginApi $this, CommonParams commonParams, Activity context, LoginApiCallBack loginApicallBack, boolean showLoader, boolean parseData) {
        $this.loginApiHit(commonParams, context, loginApicallBack, showLoader, parseData);
    }
}

