/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.Toolbar;
import androidx.core.widget.NestedScrollView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.adapters.HippoOldPaymentAdapter;
import com.hippoagent.callback.OnItemOpertionListener;
import com.hippoagent.model.PaymentModelData;
import com.hippoagent.model.payment.OldPaymentData;
import com.hippoagent.utils.ToastUtil;
import com.hippoagent.utils.countrypicker.Country;
import com.hippoagent.utils.countrypicker.CurrencyPicker;
import com.hippoagent.utils.countrypicker.OnCountryPickerListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class HippoOldPaymentActivity
extends FuguBaseActivity
implements OnItemOpertionListener {
    private static final String TAG = HippoOldPaymentActivity.class.getSimpleName();
    private HippoOldPaymentAdapter paymentAdapter;
    private ArrayList<PaymentModelData> paymentModelData = new ArrayList();
    private Country countryCurrency;
    private EditText titleView;
    private TextView currencyView;
    private TextView addOptionView;
    private TextView totalCount;
    private EditText itemDescription;
    private EditText itemPrice;
    private RecyclerView recyclerView;
    private NestedScrollView scrollView;
    private Toolbar toolbar;
    private AppCompatButton buttonSubmit;
    private TextView titleTxt;
    private TextView currencyTxt;
    private TextView descriptionTxt;
    private TextView priceTxt;
    private ImageView crossView;
    private DecimalFormat decimalFormatMoney;

    private void setColorConfig() {
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_activity_old_payment);
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.toolbar);
        this.setToolbar(this.toolbar, "Payment Request");
        this.titleView = (EditText)this.findViewById(R.id.titie_view);
        this.currencyView = (TextView)this.findViewById(R.id.currency_type_view);
        this.itemDescription = (EditText)this.findViewById(R.id.item_description);
        this.itemPrice = (EditText)this.findViewById(R.id.item_price);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.addOptionView = (TextView)this.findViewById(R.id.add_option_view);
        this.buttonSubmit = (AppCompatButton)this.findViewById(R.id.buttonSubmit);
        this.titleTxt = (TextView)this.findViewById(R.id.title_txt);
        this.currencyTxt = (TextView)this.findViewById(R.id.currency_txt);
        this.descriptionTxt = (TextView)this.findViewById(R.id.description_txt);
        this.priceTxt = (TextView)this.findViewById(R.id.price_txt);
        this.totalCount = (TextView)this.findViewById(R.id.total_count);
        this.totalCount.setVisibility(8);
        this.setColorConfig();
        this.paymentAdapter = new HippoOldPaymentAdapter(this.paymentModelData, this);
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        layoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.paymentAdapter);
        this.currencyView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HippoOldPaymentActivity.this.openPicker(HippoOldPaymentActivity.this.currencyView);
            }
        });
        this.itemPrice.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                HippoOldPaymentActivity.this.onItemAdded();
            }
        });
        this.addOptionView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (HippoOldPaymentActivity.this.paymentModelData.size() > 0) {
                    if (TextUtils.isEmpty((CharSequence)((PaymentModelData)HippoOldPaymentActivity.this.paymentModelData.get(HippoOldPaymentActivity.this.paymentModelData.size() - 1)).getItemDescription().trim()) || TextUtils.isEmpty((CharSequence)((PaymentModelData)HippoOldPaymentActivity.this.paymentModelData.get(HippoOldPaymentActivity.this.paymentModelData.size() - 1)).getPrice().trim())) {
                        ToastUtil.getInstance((Context)HippoOldPaymentActivity.this).showToast("Please fill previous fields");
                        return;
                    }
                } else if (TextUtils.isEmpty((CharSequence)HippoOldPaymentActivity.this.itemDescription.getText().toString().trim()) || TextUtils.isEmpty((CharSequence)HippoOldPaymentActivity.this.itemPrice.getText().toString().trim())) {
                    ToastUtil.getInstance((Context)HippoOldPaymentActivity.this).showToast("Please fill previous fields");
                    return;
                }
                PaymentModelData modelData = new PaymentModelData();
                modelData.setItemDescription("");
                modelData.setPrice("");
                HippoOldPaymentActivity.this.paymentModelData.add(modelData);
                HippoOldPaymentActivity.this.paymentAdapter.notifyItemInserted(HippoOldPaymentActivity.this.paymentModelData.size() - 1);
            }
        });
        this.buttonSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HippoOldPaymentActivity.this.hideKeyboard((Activity)HippoOldPaymentActivity.this);
                OldPaymentData paymentData = new OldPaymentData();
                if (TextUtils.isEmpty((CharSequence)HippoOldPaymentActivity.this.titleView.getText().toString().trim())) {
                    HippoOldPaymentActivity.this.titleView.setError((CharSequence)"Field can't be empty");
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)HippoOldPaymentActivity.this.itemDescription.getText().toString().trim())) {
                    HippoOldPaymentActivity.this.itemDescription.setError((CharSequence)"Field can't be empty");
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)HippoOldPaymentActivity.this.itemPrice.getText().toString().trim())) {
                    HippoOldPaymentActivity.this.itemPrice.setError((CharSequence)"Field can't be empty");
                    return;
                }
                paymentData.setTitle(HippoOldPaymentActivity.this.titleView.getText().toString());
                if (HippoOldPaymentActivity.this.countryCurrency != null) {
                    paymentData.setCurrency(HippoOldPaymentActivity.this.countryCurrency.getCurrency());
                    paymentData.setCurrencySymbol(HippoOldPaymentActivity.this.countryCurrency.getSymbol());
                } else {
                    paymentData.setCurrency("USD");
                    paymentData.setCurrencySymbol("$");
                }
                ArrayList<PaymentModelData> arrayList = new ArrayList<PaymentModelData>();
                if (!TextUtils.isEmpty((CharSequence)HippoOldPaymentActivity.this.itemDescription.getText().toString().trim()) && !TextUtils.isEmpty((CharSequence)HippoOldPaymentActivity.this.itemPrice.getText().toString().trim())) {
                    try {
                        Double d = Double.parseDouble(HippoOldPaymentActivity.this.itemPrice.getText().toString().trim());
                    }
                    catch (NumberFormatException e) {
                        ToastUtil.getInstance((Context)HippoOldPaymentActivity.this).showToast("Please enter valid price for item");
                        return;
                    }
                    PaymentModelData modelData = new PaymentModelData();
                    modelData.setItemDescription(HippoOldPaymentActivity.this.itemDescription.getText().toString().trim());
                    modelData.setPrice(HippoOldPaymentActivity.this.itemPrice.getText().toString().trim());
                    arrayList.add(modelData);
                }
                for (int i = 0; i < HippoOldPaymentActivity.this.paymentModelData.size(); ++i) {
                    PaymentModelData modelData = (PaymentModelData)HippoOldPaymentActivity.this.paymentModelData.get(i);
                    if (TextUtils.isEmpty((CharSequence)modelData.getItemDescription()) && TextUtils.isEmpty((CharSequence)modelData.getPrice())) continue;
                    ((PaymentModelData)HippoOldPaymentActivity.this.paymentModelData.get(i)).setErrorDesc(null);
                    ((PaymentModelData)HippoOldPaymentActivity.this.paymentModelData.get(i)).setErrorPrice(null);
                    if (TextUtils.isEmpty((CharSequence)modelData.getItemDescription().trim())) {
                        ((PaymentModelData)HippoOldPaymentActivity.this.paymentModelData.get(i)).setErrorDesc("Field can't be empty");
                        HippoOldPaymentActivity.this.paymentAdapter.notifyItemChanged(i);
                        return;
                    }
                    if (TextUtils.isEmpty((CharSequence)modelData.getPrice().trim())) {
                        ((PaymentModelData)HippoOldPaymentActivity.this.paymentModelData.get(i)).setErrorPrice("Field can't be empty");
                        HippoOldPaymentActivity.this.paymentAdapter.notifyItemChanged(i);
                        return;
                    }
                    try {
                        Double d = Double.parseDouble(modelData.getPrice().trim());
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        ((PaymentModelData)HippoOldPaymentActivity.this.paymentModelData.get(i)).setErrorPrice("Invalid price");
                        HippoOldPaymentActivity.this.paymentAdapter.notifyItemChanged(i);
                        return;
                    }
                    arrayList.add(modelData);
                }
                paymentData.setPaymentModelData(arrayList);
                Intent intent = new Intent();
                intent.putExtra("data", (Serializable)paymentData);
                HippoOldPaymentActivity.this.setResult(-1, intent);
                HippoOldPaymentActivity.this.finish();
            }
        });
        this.itemDescription.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (HippoOldPaymentActivity.this.itemDescription.hasFocus()) {
                    v.getParent().requestDisallowInterceptTouchEvent(true);
                    switch (event.getAction() & 0xFF) {
                        case 8: {
                            v.getParent().requestDisallowInterceptTouchEvent(false);
                            return true;
                        }
                    }
                }
                return false;
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onItemAdded() {
        Double totalPrice = 0.0;
        if (!TextUtils.isEmpty((CharSequence)this.itemPrice.getText().toString().trim())) {
            try {
                totalPrice = Double.parseDouble(this.itemPrice.getText().toString().trim());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return;
            }
        }
        if (this.paymentModelData != null && this.paymentModelData.size() > 0) {
            for (PaymentModelData modelData : this.paymentModelData) {
                if (modelData == null || TextUtils.isEmpty((CharSequence)modelData.getPrice())) continue;
                try {
                    totalPrice = totalPrice + Double.parseDouble(modelData.getPrice().trim());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
        if (totalPrice > 0.0) {
            this.totalCount.setVisibility(0);
            this.totalCount.setText((CharSequence)this.getString(R.string.hippo_total_count, new Object[]{this.getDecimalFormat().format(totalPrice)}));
        } else {
            this.totalCount.setVisibility(8);
        }
    }

    @Override
    public void onItemRemoved(int position) {
        this.paymentModelData.remove(position);
        this.paymentAdapter.notifyItemRemoved(position);
    }

    private void openPicker(final TextView textView) {
        CurrencyPicker currencyPicker = new CurrencyPicker.Builder().with((Context)this).sortBy(1).listener(new OnCountryPickerListener(){

            @Override
            public void onSelectCountry(Country country) {
                HippoOldPaymentActivity.this.countryCurrency = country;
                textView.setText((CharSequence)(country.getCode() + "(" + country.getSymbol() + ")"));
            }
        }).build();
        currencyPicker.showDialog(this.getSupportFragmentManager());
    }

    public DecimalFormat getDecimalFormat() {
        if (this.decimalFormatMoney == null) {
            this.decimalFormatMoney = new DecimalFormat("#.##");
        }
        return this.decimalFormatMoney;
    }
}

