/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippoagent.R;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.utils.filePicker.Prefs;
import com.hippoagent.utils.filePicker.UploadingService;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class FuguBaseActivity
extends AppCompatActivity
implements FuguAppConstant {
    private Toolbar toolbar;
    public Type fileuploadType = new TypeToken<List<FileuploadModel>>(){}.getType();

    protected void checkAutoUpload() {
        if (!this.isMyServiceRunning(UploadingService.class)) {
            ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
            if (fileuploadModels == null) {
                return;
            }
            if (fileuploadModels.size() > 0) {
                Intent intent = new Intent(this.getBaseContext(), UploadingService.class);
                intent.setAction("start");
                if (Build.VERSION.SDK_INT >= 26) {
                    this.startForegroundService(intent);
                } else {
                    this.startService(intent);
                }
            }
        }
    }

    protected boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)this.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    protected void onResume() {
        super.onResume();
    }

    public ActionBar setToolbar(Toolbar toolbar, String title) {
        this.setSupportActionBar(toolbar);
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
            try {
                Drawable upArrow = this.getResources().getDrawable(R.drawable.hippo_ic_arrow_back);
                upArrow.setColorFilter(this.getResources().getColor(R.color.hippo_back_button), PorterDuff.Mode.SRC_ATOP);
                ab.setHomeAsUpIndicator(upArrow);
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
            ab.setTitle((CharSequence)"");
        }
        ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)title);
        return this.getSupportActionBar();
    }

    public void updateToolbar(Toolbar toolbar, String title) {
        ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)title);
    }

    public void setToolBar() {
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(this.toolbar);
        this.getSupportActionBar().setDisplayShowTitleEnabled(false);
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public int getAppVersion() {
        try {
            return this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void showErrorMessage(String errorMessage, String positiveButtonText) {
        this.showErrorMessage(errorMessage, positiveButtonText, false);
    }

    public void showErrorMessage(final String errorMessage, final String positiveButtonText, final boolean isFinish) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                new AlertDialog.Builder((Context)FuguBaseActivity.this).setMessage((CharSequence)errorMessage).setPositiveButton((CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (isFinish) {
                            FuguBaseActivity.this.finish();
                        }
                    }
                }).setCancelable(false).show();
            }
        });
    }

    protected void hideKeyboard(Activity activity) {
        try {
            View view = activity.getCurrentFocus();
            InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

