/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.google.gson.Gson;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.fragments.AgentFragment;
import com.hippoagent.fragments.ChannelFragment;
import com.hippoagent.fragments.DateFragment;
import com.hippoagent.fragments.LablesFragment;
import com.hippoagent.fragments.PeopleFragment;
import com.hippoagent.fragments.StatusFragment;
import com.hippoagent.fragments.TypeFragment;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.AgentListModel;
import com.hippoagent.model.DateModel;
import com.hippoagent.model.Filter;
import com.hippoagent.model.FilterModel;
import com.hippoagent.model.GetAgentsResponse;
import io.paperdb.Paper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class FilterActivity
extends FuguBaseActivity
implements View.OnClickListener {
    private static final String TAG = FilterActivity.class.getSimpleName();
    private TextView peopleBtn;
    private TextView statusBtn;
    private TextView channelBtn;
    private TextView labelsBtn;
    private TextView typeBtn;
    private TextView tvResetBtn;
    private TextView dateTab;
    private TextView agentTab;
    private View dateView;
    public Button applyBtn;
    private String filterData;
    private FilterModel filterModel;
    private ArrayList<DateModel> dateList = new ArrayList();
    private boolean isAllChat;
    private TextView titleView;
    private String fromDate;
    private String toDate;
    public ArrayList<AgentListModel> agentListModels = new ArrayList();

    public ArrayList<DateModel> getDateList() {
        return this.dateList;
    }

    public boolean isAllChat() {
        return this.isAllChat;
    }

    public FilterModel getFilterModel() {
        return this.filterModel;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public void setToDate(String toDate) {
        this.toDate = toDate;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_filter);
        this.filterData = this.getIntent().getStringExtra("filterData");
        this.isAllChat = this.getIntent().getBooleanExtra("isAllChat", false);
        this.filterModel = (FilterModel)new Gson().fromJson(this.filterData, FilterModel.class);
        this.initView();
        int viewType = 0;
        if (this.filterModel.getViewType() == 1 || this.filterModel.getViewType() == 2) {
            viewType = 1;
        } else if (this.filterModel.getViewType() == 3) {
            viewType = 3;
        }
        this.openFragment(viewType);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.titleView = (TextView)toolbar.findViewById(R.id.tv_toolbar_name);
        this.titleView.setText((CharSequence)Restring.getString((Context)this, R.string.filter));
        toolbar.setTitle((CharSequence)"");
        toolbar.setNavigationIcon(R.drawable.ic_close);
        this.setSupportActionBar(toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FilterActivity.this.finish();
            }
        });
    }

    private void initView() {
        this.peopleBtn = (TextView)this.findViewById(R.id.people_tab);
        this.statusBtn = (TextView)this.findViewById(R.id.status_tab);
        this.channelBtn = (TextView)this.findViewById(R.id.channel_tab);
        this.labelsBtn = (TextView)this.findViewById(R.id.labels_tab);
        this.typeBtn = (TextView)this.findViewById(R.id.type_tab);
        this.applyBtn = (Button)this.findViewById(R.id.apply_btn);
        this.tvResetBtn = (TextView)this.findViewById(R.id.tvResetBtn);
        this.dateTab = (TextView)this.findViewById(R.id.date_tab);
        this.agentTab = (TextView)this.findViewById(R.id.agent_tab);
        this.dateView = this.findViewById(R.id.date_view);
        this.peopleBtn.setText((CharSequence)Restring.getString((Context)this, R.string.people));
        this.statusBtn.setText((CharSequence)Restring.getString((Context)this, R.string.status));
        this.channelBtn.setText((CharSequence)Restring.getString((Context)this, R.string.channels));
        this.labelsBtn.setText((CharSequence)Restring.getString((Context)this, R.string.labels));
        this.typeBtn.setText((CharSequence)Restring.getString((Context)this, R.string.type));
        this.tvResetBtn.setText((CharSequence)Restring.getString((Context)this, R.string.reset));
        this.dateTab.setText((CharSequence)Restring.getString((Context)this, R.string.date));
        this.agentTab.setText((CharSequence)Restring.getString((Context)this, R.string.agents));
        this.applyBtn.setText((CharSequence)Restring.getString((Context)this, R.string.apply));
        if (!this.isAllChat) {
            this.agentTab.setVisibility(8);
        } else {
            this.setAgentList();
        }
        this.peopleBtn.setOnClickListener((View.OnClickListener)this);
        this.statusBtn.setOnClickListener((View.OnClickListener)this);
        this.channelBtn.setOnClickListener((View.OnClickListener)this);
        this.labelsBtn.setOnClickListener((View.OnClickListener)this);
        this.typeBtn.setOnClickListener((View.OnClickListener)this);
        this.applyBtn.setOnClickListener((View.OnClickListener)this);
        this.tvResetBtn.setOnClickListener((View.OnClickListener)this);
        this.dateTab.setOnClickListener((View.OnClickListener)this);
        this.agentTab.setOnClickListener((View.OnClickListener)this);
        this.applyBtn.setVisibility(8);
        this.setDateFilter();
    }

    private void openFragment(int tag) {
        this.setTabBackground();
        switch (tag) {
            case 1: {
                this.openPeopleFragment();
                this.applyBtn.setVisibility(8);
                this.peopleBtn.setBackgroundColor(Color.parseColor((String)"#ffffff"));
                break;
            }
            case 2: {
                this.openStatusFragment();
                this.applyBtn.setVisibility(0);
                this.statusBtn.setBackgroundColor(Color.parseColor((String)"#ffffff"));
                break;
            }
            case 3: {
                this.openChannelFragment();
                this.applyBtn.setVisibility(0);
                this.channelBtn.setBackgroundColor(Color.parseColor((String)"#ffffff"));
                break;
            }
            case 4: {
                this.openLabelfragment();
                this.applyBtn.setVisibility(0);
                this.labelsBtn.setBackgroundColor(Color.parseColor((String)"#ffffff"));
                break;
            }
            case 5: {
                this.openTypeFragment();
                this.applyBtn.setVisibility(0);
                this.typeBtn.setBackgroundColor(Color.parseColor((String)"#ffffff"));
                break;
            }
            case 6: {
                this.openDateFragment();
                this.applyBtn.setVisibility(0);
                this.dateTab.setBackgroundColor(Color.parseColor((String)"#ffffff"));
                break;
            }
            case 7: {
                this.openAgentFragment();
                this.applyBtn.setVisibility(0);
                this.agentTab.setBackgroundColor(Color.parseColor((String)"#ffffff"));
                break;
            }
            default: {
                this.peopleBtn.setBackgroundColor(Color.parseColor((String)"#ffffff"));
                this.getSupportFragmentManager().beginTransaction().add(R.id.filter_container, (Fragment)new PeopleFragment(), PeopleFragment.class.getName()).commitAllowingStateLoss();
            }
        }
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
            this.finish();
        } else {
            super.onBackPressed();
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.people_tab) {
            this.openFragment(1);
        } else if (id2 == R.id.status_tab) {
            this.openFragment(2);
        } else if (id2 == R.id.channel_tab) {
            this.openFragment(3);
        } else if (id2 == R.id.labels_tab) {
            this.openFragment(4);
        } else if (id2 == R.id.type_tab) {
            this.openFragment(5);
        } else if (id2 == R.id.apply_btn) {
            this.filterModel.setViewType(10);
            this.applyFilterData();
        } else if (id2 == R.id.tvResetBtn) {
            this.resetFilter();
        } else if (id2 == R.id.date_tab) {
            this.openFragment(6);
        } else if (id2 == R.id.agent_tab) {
            this.openFragment(7);
        }
    }

    private void setTabBackground() {
        this.peopleBtn.setBackgroundColor(this.getResources().getColor(R.color.transparent));
        this.statusBtn.setBackgroundColor(this.getResources().getColor(R.color.transparent));
        this.channelBtn.setBackgroundColor(this.getResources().getColor(R.color.transparent));
        this.labelsBtn.setBackgroundColor(this.getResources().getColor(R.color.transparent));
        this.typeBtn.setBackgroundColor(this.getResources().getColor(R.color.transparent));
        this.dateTab.setBackgroundColor(this.getResources().getColor(R.color.transparent));
        this.agentTab.setBackgroundColor(this.getResources().getColor(R.color.transparent));
    }

    private void openPeopleFragment() {
        if (this.getPeopleFragment() == null) {
            this.getSupportFragmentManager().beginTransaction().replace(R.id.filter_container, (Fragment)new PeopleFragment(), PeopleFragment.class.getName()).commitAllowingStateLoss();
        }
    }

    private void openStatusFragment() {
        if (this.getStatusFragment() == null) {
            this.getSupportFragmentManager().beginTransaction().replace(R.id.filter_container, (Fragment)new StatusFragment(), StatusFragment.class.getName()).commitAllowingStateLoss();
        }
    }

    private void openChannelFragment() {
        if (this.getChannelFragment() == null) {
            this.getSupportFragmentManager().beginTransaction().replace(R.id.filter_container, (Fragment)new ChannelFragment(), ChannelFragment.class.getName()).commitAllowingStateLoss();
        }
    }

    private void openLabelfragment() {
        if (this.getLablesFragment() == null) {
            this.getSupportFragmentManager().beginTransaction().replace(R.id.filter_container, (Fragment)new LablesFragment(), LablesFragment.class.getName()).commitAllowingStateLoss();
        }
    }

    private void openTypeFragment() {
        if (this.getTypeFragment() == null) {
            this.getSupportFragmentManager().beginTransaction().replace(R.id.filter_container, (Fragment)new TypeFragment(), TypeFragment.class.getName()).commitAllowingStateLoss();
        }
    }

    private void openDateFragment() {
        if (this.getDateFragment() == null) {
            this.getSupportFragmentManager().beginTransaction().replace(R.id.filter_container, (Fragment)new DateFragment(), DateFragment.class.getName()).commitAllowingStateLoss();
        }
    }

    private void openAgentFragment() {
        if (this.getAgentFragment() == null) {
            this.getSupportFragmentManager().beginTransaction().replace(R.id.filter_container, (Fragment)new AgentFragment(), AgentFragment.class.getName()).commitNowAllowingStateLoss();
        }
    }

    private AgentFragment getAgentFragment() {
        return (AgentFragment)this.getSupportFragmentManager().findFragmentByTag(AgentFragment.class.getName());
    }

    private PeopleFragment getPeopleFragment() {
        return (PeopleFragment)this.getSupportFragmentManager().findFragmentByTag(PeopleFragment.class.getName());
    }

    private StatusFragment getStatusFragment() {
        return (StatusFragment)this.getSupportFragmentManager().findFragmentByTag(StatusFragment.class.getName());
    }

    private ChannelFragment getChannelFragment() {
        return (ChannelFragment)this.getSupportFragmentManager().findFragmentByTag(ChannelFragment.class.getName());
    }

    private LablesFragment getLablesFragment() {
        return (LablesFragment)this.getSupportFragmentManager().findFragmentByTag(LablesFragment.class.getName());
    }

    private TypeFragment getTypeFragment() {
        return (TypeFragment)this.getSupportFragmentManager().findFragmentByTag(TypeFragment.class.getName());
    }

    private DateFragment getDateFragment() {
        return (DateFragment)this.getSupportFragmentManager().findFragmentByTag(DateFragment.class.getName());
    }

    public void setButtonVisibility(int buttonVisibility) {
        this.applyBtn.setVisibility(buttonVisibility);
    }

    public void applyFilterData() {
        if (this.filterModel.isHasDateFilter() && this.filterModel.getDatePos() == 5 && (TextUtils.isEmpty((CharSequence)this.filterModel.getFromDate()) || TextUtils.isEmpty((CharSequence)this.filterModel.getToDate()) || !this.filterModel.isValidDate())) {
            Toast.makeText((Context)this, (CharSequence)Restring.getString((Context)this, R.string.hippo_please_select_valid_date), (int)0).show();
            return;
        }
        String filterData = new Gson().toJson((Object)this.filterModel);
        Intent intent = new Intent();
        intent.putExtra("filterData", filterData);
        this.setResult(-1, intent);
        this.overridePendingTransition(R.anim.hold, R.anim.slide_out_bottom);
        this.finish();
    }

    public void resetFilter() {
        int i;
        this.filterModel.setViewType(0);
        this.filterModel.setSelectedPeople("");
        this.filterModel.setSelectedPeopleUserId("");
        this.filterModel.setSearchCustomName("");
        this.filterModel.setSearchCustomLabel(-1);
        for (i = 0; i < this.filterModel.getChannelList().size(); ++i) {
            this.filterModel.getChannelList().get(i).setChecked(false);
        }
        for (i = 0; i < this.filterModel.getLabelsList().size(); ++i) {
            this.filterModel.getLabelsList().get(i).setChecked(false);
        }
        for (i = 0; i < this.filterModel.getTypeArrayList().size(); ++i) {
            this.filterModel.getTypeArrayList().get(i).setChecked(false);
        }
        this.filterModel.getAgentList().clear();
        this.filterModel.getStatusArrayList().get(0).setChecked(true);
        this.filterModel.getStatusArrayList().get(1).setChecked(false);
        this.filterModel.setHasDateFilter(false);
        this.filterModel.setDatePos(0);
        this.filterModel.setFromDate("");
        this.filterModel.setToDate("");
        this.applyFilterData();
    }

    public void setDateFilter() {
        this.dateList.clear();
        this.dateList.add(new DateModel(1, this.getStringValue(1), false));
        this.dateList.add(new DateModel(2, this.getStringValue(2), false));
        this.dateList.add(new DateModel(3, this.getStringValue(3), false));
        this.dateList.add(new DateModel(4, this.getStringValue(4), false));
        this.dateList.add(new DateModel(5, this.getStringValue(5), false));
        if (this.filterModel.isHasDateFilter()) {
            this.dateList.get(this.filterModel.getDatePos() - 1).setSelected(true);
        }
    }

    private void setAgentList() {
        GetAgentsResponse getAgentsResponse = (GetAgentsResponse)Paper.book((String)CommonData.name).read("agents");
        if (getAgentsResponse != null && getAgentsResponse.getData() != null && getAgentsResponse.getData().getAgents() != null && getAgentsResponse.getData().getAgents().size() > 0) {
            for (GetAgentsResponse.Agents agents : getAgentsResponse.getData().getAgents()) {
                if (agents.getStatus() != 1) continue;
                this.agentListModels.add(new AgentListModel(agents.getUserId(), agents.getFullName(), false));
            }
        }
        if (this.filterModel.getAgentList() != null && this.filterModel.getAgentList().size() > 0) {
            for (Filter filter : this.filterModel.getAgentList()) {
                int index = this.agentListModels.indexOf(new AgentListModel(filter.getId(), "", false));
                if (index <= -1) continue;
                this.agentListModels.get(index).setBoolean(true);
            }
        }
    }

    private String getStringValue(int position) {
        String textValue = "";
        switch (position) {
            case 1: {
                textValue = Restring.getString((Context)this, R.string.today) + "\n" + this.getCalculatedDate("dd MMM", 0);
                break;
            }
            case 2: {
                textValue = Restring.getString((Context)this, R.string.yesterday) + "\n" + this.getCalculatedDate("dd MMM", -1);
                break;
            }
            case 3: {
                textValue = Restring.getString((Context)this, R.string.last_7_days) + "\n" + this.getCalculatedDate("dd MMM", -6) + " - " + this.getCalculatedDate("dd MMM", 0);
                break;
            }
            case 4: {
                textValue = Restring.getString((Context)this, R.string.last_30_days) + "\n" + this.getCalculatedDate("dd MMM", -29) + " - " + this.getCalculatedDate("dd MMM", 0);
                break;
            }
            case 5: {
                textValue = Restring.getString((Context)this, R.string.custom_date);
            }
        }
        return textValue;
    }

    private String getCalculatedDate(String dateFormat, int days) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat s = new SimpleDateFormat(dateFormat);
        cal.add(6, days);
        return s.format(new Date(cal.getTimeInMillis()));
    }
}

