/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.MenuItem;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.adapters.BroadcastDetailAdapter;
import com.hippoagent.adapters.OnItemClickListener;
import com.hippoagent.databinding.ActivityBroadcastDetailsBinding;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.datastructure.MessageMode;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.BroadCastObjectModel;
import com.hippoagent.model.BroadcastResponse;
import com.hippoagent.model.BroadcastUser;
import com.hippoagent.model.Conversation;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.filelogger.Logger;
import java.util.ArrayList;
import retrofit2.Callback;

public class BroadcastDetailsActivity
extends FuguBaseActivity
implements FuguAppConstant,
OnItemClickListener {
    private static final String TAG = BroadcastDetailsActivity.class.getSimpleName();
    private ActivityBroadcastDetailsBinding detailsBinding;
    private BroadcastDetailAdapter detailAdapter;
    private BroadCastObjectModel objectModel;
    private ArrayList<BroadcastUser> broadcastUsers = new ArrayList();
    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm a";
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.detailsBinding = (ActivityBroadcastDetailsBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.activity_broadcast_details);
        this.setSupportActionBar(this.detailsBinding.myToolbar);
        this.setToolbar(this.detailsBinding.myToolbar, this.getResources().getString(R.string.broadcast_detail));
        this.objectModel = (BroadCastObjectModel)this.getIntent().getSerializableExtra("objectModel");
        this.detailsBinding.textViewFromValue.setText((CharSequence)this.objectModel.getFullName());
        String localDate = DateUtils.getInstance().convertToLocal(this.objectModel.getCreatedAt(), this.STANDARD_DATE_FORMAT_TZ, this.OUTPUT_FORMAT);
        this.detailsBinding.textViewDateValue.setText((CharSequence)localDate);
        this.detailsBinding.textViewTitleValue.setText((CharSequence)this.objectModel.getBroadcastTitle());
        this.detailsBinding.receipientTxt.setText((CharSequence)Restring.getString((Context)this, R.string.recipients));
        Utils.setColor((Context)this, this.detailsBinding.textViewMsgValue, this.objectModel.getMessage());
        if (!TextUtils.isEmpty((CharSequence)this.objectModel.getFallbackText())) {
            this.detailsBinding.textViewFallbackValue.setText((CharSequence)this.objectModel.getFallbackText());
            this.detailsBinding.rlFallback.setVisibility(0);
        } else {
            this.detailsBinding.rlFallback.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.objectModel.getBroadcastType())) {
            this.detailsBinding.layoutType.setVisibility(0);
            if (this.objectModel.getBroadcastType().equalsIgnoreCase("email")) {
                this.detailsBinding.textViewTypeValue.setText((CharSequence)Restring.getString((Context)this, R.string.email));
            } else {
                this.detailsBinding.textViewTypeValue.setText((CharSequence)Restring.getString((Context)this, R.string.hippo_in_app));
            }
        } else {
            this.detailsBinding.layoutType.setVisibility(8);
        }
        this.detailAdapter = new BroadcastDetailAdapter(this.detailsBinding.recyclerView, this);
        final LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        layoutManager.setOrientation(1);
        this.detailsBinding.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.detailsBinding.recyclerView.setAdapter((RecyclerView.Adapter)this.detailAdapter);
        this.getBroadcastStatusList(0);
        this.detailsBinding.nestedScrollView.setOnScrollChangeListener((v, scrollX, scrollY, oldScrollX, oldScrollY) -> {
            if (v.getChildAt(v.getChildCount() - 1) != null && scrollY >= v.getChildAt(v.getChildCount() - 1).getMeasuredHeight() - v.getMeasuredHeight() && scrollY > oldScrollY) {
                this.visibleItemCount = layoutManager.getChildCount();
                this.totalItemCount = layoutManager.getItemCount();
                this.pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();
                if (!this.isPagingApiInProgress && this.hasMorePages && this.visibleItemCount + this.pastVisiblesItems >= this.totalItemCount) {
                    this.getBroadcastStatusList(this.broadcastUsers.size());
                }
            }
        });
        this.detailsBinding.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy > 0) {
                    BroadcastDetailsActivity.this.visibleItemCount = layoutManager.getChildCount();
                    BroadcastDetailsActivity.this.totalItemCount = layoutManager.getItemCount();
                    BroadcastDetailsActivity.this.pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();
                    if (!BroadcastDetailsActivity.this.isPagingApiInProgress && BroadcastDetailsActivity.this.hasMorePages && BroadcastDetailsActivity.this.visibleItemCount + BroadcastDetailsActivity.this.pastVisiblesItems >= BroadcastDetailsActivity.this.totalItemCount) {
                        BroadcastDetailsActivity.this.getBroadcastStatusList(BroadcastDetailsActivity.this.broadcastUsers.size());
                    }
                }
            }
        });
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return true;
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    @Override
    public void onClickItem(int position) {
        String channelId = this.broadcastUsers.get(position).getRepliedOn();
        if (!TextUtils.isEmpty((CharSequence)channelId)) {
            Conversation conversation = new Conversation();
            conversation.setChannelId(Integer.parseInt(channelId));
            conversation.setUserId(this.broadcastUsers.get(position).getUserId());
            conversation.setUnreadCount(this.broadcastUsers.get(position).getUnreadCount());
            conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());
            conversation.setDisableReply(0);
            Intent chatIntent = new Intent((Context)this, FuguChatActivity.class);
            chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
            this.startActivityForResult(chatIntent, 100);
        }
    }

    private void getBroadcastStatusList(final int offset) {
        if (offset != 0) {
            this.isPagingApiInProgress = true;
            this.detailAdapter.showPaginationProgressBar(true, true);
        }
        CommonParams commonParams = new CommonParams.Builder().add("access_token", HippoApplication.getInstance().getUserData().getAccessToken()).add("channel_id", this.objectModel.getChannelId()).add("page_offset", offset).build();
        Logger.INSTANCE.apiRequest("/api/broadcast/broadcastStatus", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().broadcastStatus(commonParams.getMap()).enqueue((Callback)new ResponseResolver<BroadcastResponse>((Activity)this, Boolean.valueOf(offset == 0), Boolean.valueOf(false)){

            @Override
            public void success(BroadcastResponse broadcastResponse) {
                Logger.INSTANCE.apiResponse("/api/broadcast/broadcastStatus", "");
                if (offset != 0) {
                    BroadcastDetailsActivity.this.isPagingApiInProgress = false;
                    BroadcastDetailsActivity.this.detailAdapter.showPaginationProgressBar(false, true);
                }
                if (BroadcastDetailsActivity.this.broadcastUsers == null) {
                    BroadcastDetailsActivity.this.broadcastUsers = new ArrayList();
                }
                if (offset == 0) {
                    BroadcastDetailsActivity.this.broadcastUsers.clear();
                }
                BroadcastDetailsActivity.this.broadcastUsers.addAll(broadcastResponse.getData().getBroadcastUsers());
                BroadcastDetailsActivity.this.detailAdapter.setData(BroadcastDetailsActivity.this.broadcastUsers);
                BroadcastDetailsActivity.this.hasMorePages = broadcastResponse.getData().getBroadcastUsers().size() == broadcastResponse.getData().getPageSize().intValue();
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("/api/broadcast/broadcastStatus", error.getMessage());
            }
        });
    }
}

