/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippoagent.HippoConfig;
import com.hippoagent.HippoConfigAttributes;
import com.hippoagent.R;
import com.hippoagent.activities.BaseActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.dialogs.DialogPop;
import com.hippoagent.helper.VersionUpdate;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.utils.filePicker.Prefs;
import com.hippoagent.utils.filePicker.UploadingService;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0006\u0010\u001d\u001a\u00020\u001aJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u000bH&J\b\u0010#\u001a\u0004\u0018\u00010\u0018J\b\u0010$\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u00020%2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(J\u0006\u0010)\u001a\u00020%J\"\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u001f2\b\u0010-\u001a\u0004\u0018\u00010.H\u0014J\u0012\u0010/\u001a\u00020\u001a2\b\u00100\u001a\u0004\u0018\u000101H\u0014J\u0012\u00102\u001a\u00020%2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\b\u00105\u001a\u00020\u001aH\u0014J\u000e\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u000bJ\u0006\u00108\u001a\u00020\u001aJ\u0018\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010:\u001a\u00020!J\u0016\u0010;\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020!J\u001e\u0010;\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020%J\u0010\u0010?\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020%H&J\"\u0010A\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u001f2\b\u0010-\u001a\u0004\u0018\u00010.H&J\u0016\u0010B\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010:\u001a\u00020!R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/hippoagent/activities/BaseActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/hippoagent/datastructure/FuguAppConstant;", "()V", "dialogPop", "Lcom/hippoagent/dialogs/DialogPop;", "getDialogPop$hippoagentsdk_release", "()Lcom/hippoagent/dialogs/DialogPop;", "setDialogPop$hippoagentsdk_release", "(Lcom/hippoagent/dialogs/DialogPop;)V", "drawerView", "Landroid/view/View;", "getDrawerView", "()Landroid/view/View;", "setDrawerView", "(Landroid/view/View;)V", "fileuploadType", "Ljava/lang/reflect/Type;", "kotlin.jvm.PlatformType", "getFileuploadType", "()Ljava/lang/reflect/Type;", "setFileuploadType", "(Ljava/lang/reflect/Type;)V", "toolbar", "Landroidx/appcompat/widget/Toolbar;", "attachBaseContext", "", "newBase", "Landroid/content/Context;", "checkAutoUpload", "getAppVersion", "", "getAppVersionName", "", "getDrawerLayout", "getToolbar", "isEnabled", "", "isMyServiceRunning", "serviceClass", "Ljava/lang/Class;", "isNetworkAvailable", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onResume", "setDrawerLayout", "view", "setToolbar", "Landroidx/appcompat/app/ActionBar;", "title", "showErrorMessage", "errorMessage", "positiveButtonText", "isFinish", "showUpdate", "flag", "updateOnActivityResult", "updateToolbar", "Companion", "hippoagentsdk_release"})
public abstract class BaseActivity
extends AppCompatActivity
implements FuguAppConstant {
    private Toolbar toolbar;
    private Type fileuploadType = new TypeToken<List<? extends FileuploadModel>>(){}.getType();
    @Nullable
    private DialogPop dialogPop;
    @NotNull
    public View drawerView;
    private static final int APP_UPDATE_REQUEST_CODE = 1991;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final Type getFileuploadType() {
        return this.fileuploadType;
    }

    public final void setFileuploadType(Type type) {
        this.fileuploadType = type;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected void onResume() {
        super.onResume();
    }

    protected void attachBaseContext(@NotNull Context newBase) {
        Intrinsics.checkParameterIsNotNull((Object)newBase, (String)"newBase");
        super.attachBaseContext((Context)ViewPumpContextWrapper.Companion.wrap(newBase));
    }

    public boolean onOptionsItemSelected(@Nullable MenuItem item) {
        MenuItem menuItem = item;
        if (menuItem != null) {
            if (menuItem.getItemId() == 16908332) {
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public final void checkAutoUpload() {
        if (!this.isMyServiceRunning(UploadingService.class)) {
            ArrayList arrayList = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
            if (arrayList == null) {
                return;
            }
            ArrayList fileuploadModels = arrayList;
            if (fileuploadModels.size() > 0) {
                Intent intent = new Intent(this.getBaseContext(), UploadingService.class);
                intent.setAction("start");
                if (Build.VERSION.SDK_INT >= 26) {
                    this.startForegroundService(intent);
                } else {
                    this.startService(intent);
                }
            }
        }
    }

    public final boolean isMyServiceRunning(@NotNull Class<?> serviceClass) {
        Intrinsics.checkParameterIsNotNull(serviceClass, (String)"serviceClass");
        Object object = this.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager manager = (ActivityManager)object;
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            String string2 = serviceClass.getName();
            ComponentName componentName = service.service;
            Intrinsics.checkExpressionValueIsNotNull((Object)componentName, (String)"service.service");
            if (!Intrinsics.areEqual((Object)string2, (Object)componentName.getClassName())) continue;
            return true;
        }
        return false;
    }

    public final void setToolbar() {
        View view = this.findViewById(R.id.toolbar);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.appcompat.widget.Toolbar");
        }
        this.toolbar = (Toolbar)view;
        this.setSupportActionBar(this.toolbar);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar == null) {
            Intrinsics.throwNpe();
        }
        actionBar.setDisplayShowTitleEnabled(false);
    }

    public final void updateToolbar(@NotNull Toolbar toolbar, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)toolbar, (String)"toolbar");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        View view = toolbar.findViewById(R.id.tv_toolbar_name);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
        }
        ((TextView)view).setText((CharSequence)title);
    }

    @Nullable
    public final ActionBar setToolbar(@NotNull Toolbar toolbar, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)toolbar, (String)"toolbar");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        this.setSupportActionBar(toolbar);
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setTitle((CharSequence)"");
        }
        View view = toolbar.findViewById(R.id.tv_toolbar_name);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
        }
        ((TextView)view).setText((CharSequence)title);
        return this.getSupportActionBar();
    }

    public final boolean isNetworkAvailable() {
        Object object = this.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm = (ConnectivityManager)object;
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    @Nullable
    public final Toolbar getToolbar() {
        return this.toolbar;
    }

    public final int getAppVersion() {
        try {
            return this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @NotNull
    public final String getAppVersionName() {
        try {
            return "v" + this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public final void showErrorMessage(@NotNull String errorMessage, @NotNull String positiveButtonText) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkParameterIsNotNull((Object)positiveButtonText, (String)"positiveButtonText");
        this.showErrorMessage(errorMessage, positiveButtonText, false);
    }

    public final void showErrorMessage(@NotNull String errorMessage, @NotNull String positiveButtonText, boolean isFinish) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkParameterIsNotNull((Object)positiveButtonText, (String)"positiveButtonText");
        this.runOnUiThread(new Runnable(this, errorMessage, positiveButtonText, isFinish){
            final /* synthetic */ BaseActivity this$0;
            final /* synthetic */ String $errorMessage;
            final /* synthetic */ String $positiveButtonText;
            final /* synthetic */ boolean $isFinish;

            public final void run() {
                new AlertDialog.Builder((Context)this.this$0).setMessage((CharSequence)this.$errorMessage).setPositiveButton((CharSequence)this.$positiveButtonText, new DialogInterface.OnClickListener(this){
                    final /* synthetic */ showErrorMessage.1 this$0;

                    public final void onClick(DialogInterface dialog, int which) {
                        if (this.this$0.$isFinish) {
                            this.this$0.this$0.finish();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).setCancelable(false).show();
            }
            {
                this.this$0 = baseActivity;
                this.$errorMessage = string2;
                this.$positiveButtonText = string3;
                this.$isFinish = bl;
            }
        });
    }

    private final boolean isEnabled() {
        boolean bl;
        VersionUpdate update = CommonData.getVersionInfo();
        if (update == null) {
            bl = false;
        } else {
            HippoConfigAttributes hippoConfigAttributes = HippoConfig.getInstance().getAttributes();
            Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfigAttributes, (String)"HippoConfig.getInstance().getAttributes()");
            if (hippoConfigAttributes.getVersionCode() >= update.getVersion()) {
                bl = false;
            } else {
                HippoConfigAttributes hippoConfigAttributes2 = HippoConfig.getInstance().getAttributes();
                Intrinsics.checkExpressionValueIsNotNull((Object)hippoConfigAttributes2, (String)"HippoConfig.getInstance().getAttributes()");
                bl = hippoConfigAttributes2.getVersionCode() < update.getVersion() && update.getLastVersion() != update.getVersion() ? true : (update.getLastVersion() == update.getVersion() && update.getInterval() > 0L ? System.currentTimeMillis() - update.getLastShown() > update.getInterval() * (long)60 * (long)1000 : false);
            }
        }
        return bl;
    }

    @Nullable
    public final DialogPop getDialogPop$hippoagentsdk_release() {
        return this.dialogPop;
    }

    public final void setDialogPop$hippoagentsdk_release(@Nullable DialogPop dialogPop) {
        this.dialogPop = dialogPop;
    }

    public abstract void updateOnActivityResult(int var1, int var2, @Nullable Intent var3);

    @NotNull
    public abstract View getDrawerLayout();

    public abstract void showUpdate(boolean var1);

    @NotNull
    public final View getDrawerView() {
        View view = this.drawerView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"drawerView");
        }
        return view;
    }

    public final void setDrawerView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"<set-?>");
        this.drawerView = view;
    }

    public final void setDrawerLayout(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.drawerView = view;
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1991 && resultCode != -1 && CommonData.getInstallType() == 1) {
            this.finishAffinity();
        }
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/hippoagent/activities/BaseActivity$Companion;", "", "()V", "APP_UPDATE_REQUEST_CODE", "", "hippoagentsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

