/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.callback.AgentUnreadCountListener;
import com.hippoagent.callback.UnreadListener;
import com.hippoagent.database.CommonData;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.model.UnreadCountData;
import com.hippoagent.model.unreadResponse.AgentUnreadCount;
import com.hippoagent.model.unreadResponse.UnreadCountResponse;
import com.hippoagent.model.unreadResponse.UserUnreadCount;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Log;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Callback;

public class UnreadCountHelper
implements UnreadListener {
    private static final String TAG = UnreadCountHelper.class.getSimpleName();
    private static UnreadCountHelper instance;
    private HashMap<Integer, Integer> totalUnreadCount = new HashMap();
    private int totalCount = 0;
    private static Type listType;

    private UnreadCountHelper() {
    }

    protected void setListener() {
        HippoConfig.getInstance().setInternalCountListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static UnreadCountHelper getInstance() {
        if (instance == null) {
            Class<UnreadCountHelper> clazz = UnreadCountHelper.class;
            // MONITORENTER : com.hippoagent.UnreadCountHelper.class
            if (instance == null) {
                instance = new UnreadCountHelper();
                instance.setHelperListener();
            }
            // MONITOREXIT : clazz
        }
        instance.checkHelperListener();
        return instance;
    }

    private void setHelperListener() {
        HippoApplication.getInstance().addUIListener(UnreadListener.class, this);
    }

    private void checkHelperListener() {
        HippoApplication.getInstance().addOrUpdateUIListener(UnreadListener.class, this);
    }

    @Override
    public void pushUpdateCount(String userUniqueKey, boolean isArrayStr) {
        if (TextUtils.isEmpty((CharSequence)userUniqueKey)) {
            return;
        }
        if (isArrayStr) {
            ArrayList userUniqueKeyArr = (ArrayList)new Gson().fromJson(userUniqueKey, listType);
            for (Object string2 : userUniqueKeyArr) {
                UnreadCountData unreadCountData = CommonData.getUnreadCount((String)string2);
                if (unreadCountData == null || TextUtils.isEmpty((CharSequence)unreadCountData.getUserUniqueKey())) continue;
                int count = unreadCountData.getCount();
                unreadCountData.setCount(++count);
                CommonData.addUnreadCount((String)string2, unreadCountData);
            }
        } else {
            UnreadCountData countData = CommonData.getUnreadCount(userUniqueKey);
            if (countData == null || TextUtils.isEmpty((CharSequence)countData.getUserUniqueKey())) {
                return;
            }
            int count = countData.getCount();
            countData.setCount(++count);
            CommonData.addUnreadCount(userUniqueKey, countData);
        }
        HashMap<String, UnreadCountData> dataHashMap = CommonData.getUnreadCount();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Map.Entry entry : dataHashMap.entrySet()) {
            UnreadCountData data = (UnreadCountData)entry.getValue();
            hashMap.put((String)entry.getKey(), data.getCount());
        }
        String jsonData = new Gson().toJson(hashMap);
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            HippoConfig.getInstance().getAgentCountListener().unreadCount(jsonData);
        }
    }

    @Override
    public void updateOpenChannelCount(ArrayList<String> userUniqueKeyArr, int value) {
        for (String userUniqueKey : userUniqueKeyArr) {
            UnreadCountData countData = CommonData.getUnreadCount(userUniqueKey);
            if (countData == null || TextUtils.isEmpty((CharSequence)countData.getUserUniqueKey())) continue;
            int n = countData.getCount();
            if ((n -= value) < 0) {
                n = 0;
            }
            countData.setCount(n);
            CommonData.addUnreadCount(userUniqueKey, countData);
        }
        HashMap<String, UnreadCountData> dataHashMap = CommonData.getUnreadCount();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Map.Entry entry : dataHashMap.entrySet()) {
            UnreadCountData data = (UnreadCountData)entry.getValue();
            hashMap.put((String)entry.getKey(), data.getCount());
        }
        String jsonData = new Gson().toJson(hashMap);
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            HippoConfig.getInstance().getAgentCountListener().unreadCount(jsonData);
        }
    }

    @Override
    public void getUnreadCount() {
        HashMap<String, UnreadCountData> countHashMap = CommonData.getUnreadCount();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Map.Entry<String, UnreadCountData> map : countHashMap.entrySet()) {
            UnreadCountData data = map.getValue();
            hashMap.put(map.getKey(), data.getCount());
        }
        String jsonData = new Gson().toJson(hashMap);
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            HippoConfig.getInstance().getAgentCountListener().unreadCount(jsonData);
        }
    }

    @Override
    public void getUpdatedUnreadCount(ArrayList<String> strings) {
        if (strings == null) {
            strings = CommonData.getAgentUniqueKey();
        }
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            this.getUpdatedUnreadCount(strings, HippoConfig.getInstance().getAgentCountListener());
        }
    }

    @Override
    public void getUpdatedUnreadCount(ArrayList<String> strings, AgentUnreadCountListener countListener) {
        UserData userData = HippoApplication.getInstance().getUserData();
        if (strings == null) {
            strings = CommonData.getAgentUniqueKey();
        }
        if (userData == null || strings == null) {
            return;
        }
        CommonParams commonParams = new CommonParams.Builder().add("access_token", userData.getAccessToken()).add("user_unique_key", new Gson().toJson(strings)).add("response_type", 1).build();
        RestClient.getApiInterface().getUnreadCount(commonParams.getMap()).enqueue((Callback)new ResponseResolver<UnreadCountResponse>(){

            @Override
            public void success(UnreadCountResponse unreadCountResponse) {
                try {
                    CommonData.clearUnreadCount();
                    HashMap<String, UnreadCountData> countHashMap = new HashMap<String, UnreadCountData>();
                    for (UserUnreadCount userUnreadCount : unreadCountResponse.getData().getUserUnreadCount()) {
                        UnreadCountData unreadCountData = new UnreadCountData();
                        unreadCountData.setUserUniqueKey(userUnreadCount.getUserUniqueKey());
                        unreadCountData.setHippoUserId(userUnreadCount.getUserId());
                        unreadCountData.setCount(userUnreadCount.getUnreadCount());
                        countHashMap.put(userUnreadCount.getUserUniqueKey(), unreadCountData);
                    }
                    CommonData.addAllUnreadCount(countHashMap);
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    for (Map.Entry<String, UnreadCountData> entry : countHashMap.entrySet()) {
                        UnreadCountData data = entry.getValue();
                        hashMap.put(entry.getKey(), data.getCount());
                    }
                    String string2 = new Gson().toJson(hashMap);
                    if (HippoConfig.getInstance().getAgentCountListener() != null) {
                        HippoConfig.getInstance().getAgentCountListener().unreadCount(string2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void failure(APIError error) {
            }
        });
    }

    @Override
    public void setApiCountResponse(ArrayList<AgentUnreadCount> agentWiseCount) {
        try {
            this.totalCount = 0;
            if (agentWiseCount != null && agentWiseCount.size() > 0) {
                for (AgentUnreadCount unreadCount : agentWiseCount) {
                    this.totalCount += unreadCount.getUnreadCount();
                    this.totalUnreadCount.put(unreadCount.getChannelId(), unreadCount.getUnreadCount());
                }
            }
            if (HippoConfig.getInstance().getCallbackListener() != null) {
                HippoConfig.getInstance().getCallbackListener().count(this.totalCount, this.totalUnreadCount.values().size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTotalPushUnread(Integer channelId) {
        try {
            ++this.totalCount;
            try {
                Integer count = this.totalUnreadCount.containsKey(channelId) ? this.totalUnreadCount.get(channelId) : Integer.valueOf(0);
                this.totalUnreadCount.put(channelId, count + 1);
            }
            catch (Exception count) {
                // empty catch block
            }
            if (HippoConfig.getInstance().getCallbackListener() != null) {
                HippoConfig.getInstance().getCallbackListener().count(this.totalCount, this.totalUnreadCount.values().size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeTotalPushUnread(Integer channelId) {
        int count = this.totalUnreadCount.get(channelId);
        this.totalUnreadCount.remove(channelId);
        this.totalCount -= count;
        if (this.totalCount == 0 || this.totalCount < 0) {
            this.totalUnreadCount.clear();
            this.totalCount = 0;
        }
        if (HippoConfig.getInstance().getCallbackListener() != null) {
            HippoConfig.getInstance().getCallbackListener().count(this.totalCount, this.totalUnreadCount.values().size());
        }
    }

    @Override
    public void sendTotalUnreadCount() {
        Log.i(TAG, "totalUnreadCount: " + new Gson().toJson(this.totalUnreadCount));
        this.totalCount = 0;
        for (Integer value : this.totalUnreadCount.values()) {
            this.totalCount += value.intValue();
        }
        if (HippoConfig.getInstance().getCallbackListener() != null) {
            HippoConfig.getInstance().getCallbackListener().count(this.totalCount, this.totalUnreadCount.values().size());
        }
    }

    static {
        listType = new TypeToken<ArrayList<String>>(){}.getType();
    }
}

