/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoAssignmentListener;
import com.hippoagent.HippoConfigAttributes;
import com.hippoagent.LoginCallback;
import com.hippoagent.OnGroupSessionListener;
import com.hippoagent.SessionAttributes;
import com.hippoagent.UnreadCount;
import com.hippoagent.UnreadCountHelper;
import com.hippoagent.activities.BroadcastListActivity;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.activities.LoginApi;
import com.hippoagent.activities.PlansActivity;
import com.hippoagent.apis.HippoLogout;
import com.hippoagent.apis.SessionHandler;
import com.hippoagent.callback.AgentUnreadCountListener;
import com.hippoagent.callback.CountDownTimerListener;
import com.hippoagent.callback.LoginApiCallBack;
import com.hippoagent.callback.OnStartSessionListener;
import com.hippoagent.callback.UnreadListener;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.MessageType;
import com.hippoagent.dialogs.ShowDialg;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.hippocall.HippoCallConfig;
import com.hippoagent.hippocall.WebRTCCallConstants;
import com.hippoagent.langs.LanguageManager;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.LoginResponse.BusinessLanguages;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.model.groupCall.GroupCallData;
import com.hippoagent.model.groupCall.GroupCallResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.utils.ConfigMode;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.UniqueIMEIID;
import com.hippoagent.utils.Utils;
import java.util.ArrayList;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class HippoConfig
implements CountDownTimerListener {
    private static final String TAG = HippoConfig.class.getSimpleName();
    private static HippoConfig hippoConfig;
    private static final String PAPER_BOOK = "hippo_agent_sdk";
    private Activity activity;
    private Context mContext;
    private boolean isHippoInit = false;
    private boolean isActivityEnabled = false;
    private String busyMuid = "";
    private HippoConfigAttributes configAttributes;
    private UnreadCount callbackListener;
    private AgentUnreadCountListener countListener;
    private HippoAssignmentListener assignmentListener;
    private UnreadListener unreadListener;
    private String currentLanguage;
    private OnGroupSessionListener sessionListener;
    int initalCalls = 0;
    String muid = "";
    CountDownTimer countDownTimer;
    CountDownTimerListener timerListener;
    private String jitsiURL = "";

    public static HippoConfig getInstance() {
        if (hippoConfig == null) {
            hippoConfig = new HippoConfig();
        }
        return hippoConfig;
    }

    public boolean isHippoInit() {
        return this.isHippoInit;
    }

    public void setHippoInit(boolean flag) {
        this.isHippoInit = flag;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Context getContext() {
        return this.mContext.getApplicationContext();
    }

    public String getBusyMuid() {
        return this.busyMuid;
    }

    public void setBusyMuid(String busyMuid) {
        this.busyMuid = busyMuid;
    }

    public static void initHippoConfig(Activity activity, HippoConfigAttributes configAttributes, LoginCallback callback) {
        HippoConfig.getInstance().configAttributes = configAttributes;
        CommonData.saveAttributes(configAttributes);
        HippoConfig.getInstance().activity = activity;
        HippoConfig.getInstance().isHippoInit = true;
        ConfigMode configModeToSet = ConfigMode.LIVE;
        if (!TextUtils.isEmpty((CharSequence)configAttributes.getEnvironment())) {
            switch (configAttributes.getEnvironment().toLowerCase()) {
                case "live": {
                    configModeToSet = ConfigMode.LIVE;
                    break;
                }
                case "test": {
                    configModeToSet = ConfigMode.BETA;
                    break;
                }
                case "dev3004": {
                    configModeToSet = ConfigMode.DEV;
                    break;
                }
                case "dev": {
                    configModeToSet = ConfigMode.ALPHA;
                    break;
                }
                case "beta-live": {
                    configModeToSet = ConfigMode.LIVE_BETA;
                    break;
                }
                case "dev3003": {
                    configModeToSet = ConfigMode.DEV3003;
                    break;
                }
                default: {
                    configModeToSet = ConfigMode.LIVE;
                }
            }
        }
        HippoApplication.getInstance().initializeServerURL(configModeToSet);
        HippoConfig.loginHippoAgent(activity, configAttributes, callback);
        UnreadCountHelper.getInstance().setListener();
    }

    public void openMainScreen(@NotNull Activity activity) {
        if (HippoApplication.getInstance().getUserData() != null) {
            activity.startActivity(new Intent((Context)activity, HomeActivity.class));
        } else {
            Log.e("HippoConfig", "Need to login first");
        }
    }

    public void openSavedReply(Activity activity) {
        if (HippoApplication.getInstance().getUserData() != null && HippoApplication.getInstance().getUserData().getBusinessProperty().isAskPaymentAllowed()) {
            Intent planIntent = new Intent((Context)activity, PlansActivity.class);
            activity.startActivity(planIntent);
        } else {
            Log.e("Error", "Feature not available");
        }
    }

    public void openBroadcast(@NotNull Activity activity) {
        if (HippoApplication.getInstance().getUserData() != null) {
            activity.startActivity(new Intent((Context)activity, BroadcastListActivity.class));
        } else {
            Log.e("HippoConfig", "Need to login first");
        }
    }

    public void logoutHippo(Activity activity) {
        HippoLogout.INSTANCE.logout(activity);
    }

    public HippoConfigAttributes getAttributes() {
        if (this.configAttributes == null) {
            this.configAttributes = CommonData.getConfigAttributes();
        }
        return this.configAttributes;
    }

    private static void loginHippoAgent(Activity activity, HippoConfigAttributes configAttributes, final LoginCallback callback) {
        LoginApi.INSTANCE.login(activity, configAttributes, new LoginApiCallBack(){

            @Override
            public void onErrorMessage(@NotNull LoginResponse t) {
                callback.onError();
            }

            @Override
            public void onApiSuccess(@NotNull LoginResponse t) {
                HippoConfig.openChannel(t);
                callback.success();
            }

            @Override
            public void onApiFailed(@Nullable APIError error) {
                callback.failed();
            }

            @Override
            public void singleBtnUpdateWindow(@NotNull LoginResponse t) {
                HippoConfig.openChannel(t);
                callback.success();
            }

            @Override
            public void showUpdateWindowTwoBtns(@NotNull LoginResponse t) {
                HippoConfig.openChannel(t);
                callback.success();
            }
        }, false, true);
    }

    private static void openChannel(LoginResponse t) {
        block10: {
            ConnectionManager.INSTANCE.initFayeConnection();
            if (t != null && !TextUtils.isEmpty((CharSequence)t.getUserData().getUserChannel())) {
                ConnectionManager.INSTANCE.subScribeChannel("/" + t.getUserData().getUserChannel());
                ConnectionManager.INSTANCE.subScribeChannel("/" + t.getUserData().getAccessToken() + "/agentsRefresh");
                ConnectionManager.INSTANCE.subScribeChannel("/" + t.getUserData().getAccessToken() + "/agentRefresh");
                ConnectionManager.INSTANCE.subScribeChannel("/" + t.getUserData().getAccessToken() + "/userMigration");
            }
            try {
                if (TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getAttributes().getLang())) {
                    if (!TextUtils.isEmpty((CharSequence)t.getUserData().getLangCode())) {
                        HippoConfig.getInstance().updateLanguage(t.getUserData().getLangCode());
                        break block10;
                    }
                    for (BusinessLanguages languages : t.getUserData().getBusinessLanguages()) {
                        if (!languages.isDefaultLnag()) continue;
                        HippoConfig.getInstance().updateLanguage(languages.getLangCode());
                        break block10;
                    }
                    break block10;
                }
                if (!TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getAttributes().getLang()) && t.getUserData().getBusinessLanguages() != null) {
                    String lang = "";
                    for (BusinessLanguages languages : t.getUserData().getBusinessLanguages()) {
                        if (HippoConfig.getInstance().getAttributes().getLang().equalsIgnoreCase(languages.getLangCode())) {
                            lang = languages.getLangCode();
                            break;
                        }
                        if (!languages.isDefaultLnag()) continue;
                        lang = languages.getLangCode();
                    }
                    HippoConfig.getInstance().updateLanguage(lang);
                } else {
                    HippoConfig.getInstance().updateLanguage("en");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void openDirectChannel(Activity activity, Integer channelId) {
        if (channelId != null && channelId > 0) {
            Intent intent = new Intent((Context)activity, FuguChatActivity.class);
            intent.putExtra("is_direct_channel", true);
            intent.putExtra("is_p2p_chat", false);
            Conversation conversation = new Conversation();
            conversation.setChannelId(channelId);
            conversation.setStatus(2);
            intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
            activity.startActivity(intent);
        } else {
            Log.e(TAG, "Invalid channel ID");
        }
    }

    public HippoAssignmentListener getAssignmentListener() {
        return this.assignmentListener;
    }

    public void setAssignmentListener(HippoAssignmentListener assignmentListener) {
        this.assignmentListener = assignmentListener;
    }

    public UnreadCount getCallbackListener() {
        return this.callbackListener;
    }

    public void setCallbackListener(UnreadCount callbackListener) {
        this.callbackListener = callbackListener;
    }

    public AgentUnreadCountListener getAgentCountListener() {
        return this.countListener;
    }

    public void setCountForCallbackListener(AgentUnreadCountListener countListener) {
        this.countListener = countListener;
    }

    public void getTotalUnreadCount() {
        try {
            this.getTotalUnreadCountData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getUnreadCountFor(ArrayList<String> strings) {
        UnreadCountHelper.getInstance().getUpdatedUnreadCount(strings);
    }

    private void getTotalUnreadCountData() throws Exception {
        UnreadCountHelper.getInstance();
        LoginApi.INSTANCE.getAgentTotalUnreadCount();
    }

    public void openConversationFor(Activity activity, String otherUserUniqueKey, String title) {
        this.openConversationFor(activity, otherUserUniqueKey, title, "");
    }

    public void openConversationFor(Activity activity, String otherUserUniqueKey, String title, String transactionId) {
        if (HippoConfig.getInstance().activity == null) {
            HippoConfig.getInstance().activity = activity;
        }
        if (!TextUtils.isEmpty((CharSequence)otherUserUniqueKey) && !TextUtils.isEmpty((CharSequence)transactionId)) {
            Conversation conversation = new Conversation();
            conversation.setChannelId(-1);
            conversation.setChannelName("dummyChannelName");
            conversation.setStatus(-2);
            conversation.setAgentId(-2);
            conversation.setUserUniqueKeys(otherUserUniqueKey);
            conversation.setLabel(title);
            conversation.setUnreadCount(0);
            Intent intent = new Intent(activity.getApplicationContext(), FuguChatActivity.class);
            intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
            intent.putExtra("create_chat", true);
            intent.putExtra("transactionId", transactionId);
            intent.putExtra("fragment_type", MessageType.USER_CHAT.getOrdinal());
            activity.startActivity(intent);
        }
    }

    public void startOneToOneConversation(String email) {
        if (Utils.isValidEmail(email)) {
            Conversation conversation = new Conversation();
            conversation.setChannelId(-1);
            conversation.setChannelName("dummyChannelName");
            conversation.setStatus(-2);
            conversation.setAgentId(-2);
            conversation.setChatType(2);
            conversation.setLabel("");
            conversation.setUnreadCount(0);
            Intent intent = new Intent(this.activity.getApplicationContext(), FuguChatActivity.class);
            intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
            intent.putExtra("create_chat", true);
            intent.putExtra("is_one_two_one", true);
            intent.putExtra("one_two_one_email", email);
            this.activity.startActivity(intent);
        } else {
            Log.e(TAG, "Enter valid email");
        }
    }

    protected void setInternalCountListener(UnreadListener unreadListener) {
        this.unreadListener = unreadListener;
    }

    public UnreadListener getInternalListener() {
        return this.unreadListener;
    }

    public String getCurrentLanguage() {
        this.currentLanguage = CommonData.getCurrentLanguage();
        return this.currentLanguage;
    }

    public void updateLanguage() {
        this.updateLanguage(this.getCurrentLanguage());
    }

    public void updateLanguage(String languageCode) {
        if (TextUtils.isEmpty((CharSequence)languageCode)) {
            android.util.Log.e((String)"TAG", (String)"Language code can't be null");
            return;
        }
        if (HippoApplication.getInstance().getUserData() == null || HippoApplication.getInstance().getUserData().getBusinessProperty() == null || TextUtils.isEmpty((CharSequence)HippoApplication.getInstance().getUserData().getAccessToken())) {
            return;
        }
        String lang = "";
        try {
            for (BusinessLanguages languages : HippoApplication.getInstance().getUserData().getBusinessLanguages()) {
                if (!languages.getLangCode().equalsIgnoreCase(languageCode)) continue;
                lang = languageCode;
                break;
            }
        }
        catch (Exception e) {
            android.util.Log.e((String)"TAG", (String)"This language code not found");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)lang)) {
            android.util.Log.e((String)"TAG", (String)"This language code not found");
            return;
        }
        String getCurrentLang = CommonData.getCurrentLanguage();
        Log.w("Lang", getCurrentLang + " -> currentLang, Requerd Lang -> " + languageCode);
        if (!getCurrentLang.equalsIgnoreCase(languageCode)) {
            this.currentLanguage = languageCode;
            CommonData.saveCurrentLang(this.currentLanguage);
            this.setLanguage(this.currentLanguage);
        }
    }

    public String getBusinessLanguage() {
        try {
            if (HippoApplication.getInstance().getUserData().getBusinessLanguages() != null) {
                return new Gson().toJson(HippoApplication.getInstance().getUserData().getBusinessLanguages());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private void setLanguage(String language) {
        LanguageManager.INSTANCE.updateLanguage(language);
    }

    public void createSession(Activity activity, SessionAttributes attributes) {
        SessionHandler.INSTANCE.createSession(activity, attributes);
    }

    public void updateGroupSession(OnGroupSessionListener sessionListener) {
        this.sessionListener = sessionListener;
    }

    public OnGroupSessionListener getGroupSessionListener() {
        return this.sessionListener;
    }

    public void startSession(final Activity activity, final String transactionId, final int callType) {
        ShowDialg.INSTANCE.showDialog((Context)activity);
        GroupCallData groupCallData = CommonData.getGroupData(transactionId);
        if (groupCallData != null && !TextUtils.isEmpty((CharSequence)groupCallData.getRoomUniqueId())) {
            this.initCall(activity, transactionId, callType, groupCallData.getChannelId(), groupCallData.getRoomUniqueId(), groupCallData.getRoomTitle());
            HippoCallConfig.getInstance().joinSession((Context)activity, groupCallData.getRoomUniqueId(), groupCallData.getRoomTitle(), callType, transactionId);
        } else {
            SessionHandler.INSTANCE.startSession(activity, transactionId, callType, new OnStartSessionListener(){

                @Override
                public void onStartListener(GroupCallResponse callResponse) {
                    HippoConfig.this.muid = UUID.randomUUID().toString();
                    HippoConfig.this.initCall(activity, transactionId, callType, callResponse.getData().getChannelId(), callResponse.getData().getCustomData().getRoomUniqueId(), callResponse.getData().getRoomTitle());
                    try {
                        GroupCallData groupCallData = new GroupCallData();
                        groupCallData.setTransactionId(transactionId);
                        groupCallData.setChannelId(callResponse.getData().getChannelId());
                        groupCallData.setCallType(callType);
                        groupCallData.setMuid(HippoConfig.this.muid);
                        groupCallData.setRoomTitle(callResponse.getData().getRoomTitle());
                        groupCallData.setRoomUniqueId(callResponse.getData().getCustomData().getRoomUniqueId());
                        CommonData.saveGroupCall(transactionId, groupCallData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    HippoCallConfig.getInstance().joinSession((Context)activity, callResponse.getData().getCustomData().getRoomUniqueId(), callResponse.getData().getRoomTitle(), callType, transactionId);
                    if (HippoConfig.getInstance().getGroupSessionListener() != null) {
                        HippoConfig.getInstance().getGroupSessionListener().onStartSession(transactionId);
                    }
                }

                @Override
                public void onErrorListener(String error) {
                    ShowDialg.INSTANCE.hideDialog();
                    if (HippoConfig.getInstance().getGroupSessionListener() != null) {
                        HippoConfig.getInstance().getGroupSessionListener().onErrorInSession(error);
                    }
                }
            });
        }
    }

    public void stopSession(String transactionId) {
        CommonData.deleteGroupData(transactionId);
    }

    public void endSession(Activity activity, String transactionId) {
        GroupCallData callResponse = CommonData.getGroupData(transactionId);
        JSONObject startCallJson = new JSONObject();
        try {
            startCallJson.put("is_silent", false);
            startCallJson.put("video_call_type", (Object)WebRTCCallConstants.JitsiCallType.END_GROUP_CALL.toString());
            startCallJson.put("user_id", (Object)HippoApplication.getInstance().getUserData().getUserId());
            startCallJson.put("channel_id", (Object)callResponse.getChannelId());
            startCallJson.put("message_type", 27);
            startCallJson.put("call_type", (Object)"VIDEO");
            if (callResponse.getCallType() == 2) {
                startCallJson.put("call_type", (Object)"AUDIO");
            }
            startCallJson.put("muid", (Object)this.muid);
            startCallJson.put("device_payload", (Object)this.getDeviceDetails().toString());
            String baseUrl = this.getJitsiURL();
            if (TextUtils.isEmpty((CharSequence)baseUrl)) {
                baseUrl = "https://conference.hippochat.io";
            }
            String link = baseUrl + "/" + callResponse.getRoomUniqueId();
            String invitelink = "https://conference.hippochat.io/" + callResponse.getRoomUniqueId();
            if (callResponse.getCallType() == 2) {
                link = link + "#config.startWithVideoMuted=true";
                invitelink = invitelink + "#config.startWithVideoMuted=true";
            }
            startCallJson.put("invite_link", (Object)invitelink);
            startCallJson.put("jitsi_url", (Object)link);
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            startCallJson.put("full_name", (Object)callResponse.getRoomTitle());
            ConnectionManager.INSTANCE.publish("/" + callResponse.getChannelId(), startCallJson);
            CommonData.deleteGroupData(transactionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setListener(CountDownTimerListener listener) {
    }

    private void stopSession() {
        try {
            ConnectionManager.INSTANCE.setCountDownTimerListener(null);
            if (this.countDownTimer != null) {
                this.countDownTimer.cancel();
                this.countDownTimer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getJitsiURL() {
        if (TextUtils.isEmpty((CharSequence)this.jitsiURL) && HippoApplication.getInstance().getUserData() != null && HippoApplication.getInstance().getUserData().getBusinessProperty() != null && !TextUtils.isEmpty((CharSequence)HippoApplication.getInstance().getUserData().getBusinessProperty().getJitsiUrl())) {
            this.jitsiURL = HippoApplication.getInstance().getUserData().getBusinessProperty().getJitsiUrl();
        }
        return this.jitsiURL;
    }

    private void initCall(Activity activity, final String transactionId, final int callType, final Long channelId, final String roomId, final String title) {
        this.initalCalls = 0;
        ConnectionManager.INSTANCE.setCountDownTimerListener(this);
        ConnectionManager.INSTANCE.unsubScribeChannel("/" + channelId);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ConnectionManager.INSTANCE.subScribeChannel("/" + channelId);
            }
        }, 500L);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                HippoConfig.this.countDownTimer = new CountDownTimer(60000L, 2000L){

                    public void onTick(long millisUntilFinished) {
                        if (HippoConfig.this.initalCalls == 1) {
                            HippoConfig.this.startCall(false, channelId, roomId, title, callType, transactionId);
                        } else {
                            HippoConfig.this.startCall(true, channelId, roomId, title, callType, transactionId);
                        }
                        ++HippoConfig.this.initalCalls;
                    }

                    public void onFinish() {
                        Log.e("Time", "Clock stop here");
                        HippoConfig.this.stopSession();
                    }
                };
                HippoConfig.this.countDownTimer.start();
            }
        });
    }

    private void startCall(boolean isSilent, Long channelId, String roomId, String title, int callType, String transactionId) {
        JSONObject startCallJson = new JSONObject();
        try {
            startCallJson.put("is_silent", isSilent);
            startCallJson.put("video_call_type", (Object)WebRTCCallConstants.JitsiCallType.START_GROUP_CALL.toString());
            startCallJson.put("user_id", (Object)HippoApplication.getInstance().getUserData().getUserId());
            startCallJson.put("channel_id", (Object)channelId);
            startCallJson.put("message_type", 27);
            startCallJson.put("call_type", (Object)"VIDEO");
            if (callType == 2) {
                startCallJson.put("call_type", (Object)"AUDIO");
            }
            startCallJson.put("muid", (Object)this.muid);
            startCallJson.put("device_payload", (Object)this.getDeviceDetails().toString());
            String baseUrl = this.getJitsiURL();
            if (TextUtils.isEmpty((CharSequence)baseUrl)) {
                baseUrl = "https://conference.hippochat.io";
            }
            String link = baseUrl + "/" + roomId;
            String invitelink = "https://conference.hippochat.io/" + roomId;
            if (callType == 2) {
                link = link + "#config.startWithVideoMuted=true";
                invitelink = invitelink + "#config.startWithVideoMuted=true";
            }
            startCallJson.put("jitsi_url", (Object)link);
            startCallJson.put("invite_link", (Object)invitelink);
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            startCallJson.put("full_name", (Object)title);
            startCallJson.put("transaction_id", (Object)transactionId);
            ConnectionManager.INSTANCE.publish("/" + channelId, startCallJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JSONObject getDeviceDetails() {
        JSONObject devicePayload = new JSONObject();
        try {
            devicePayload.put("device_id", (Object)UniqueIMEIID.getUniqueIMEIId((Context)this.activity));
            devicePayload.put("device_type", 1);
            devicePayload.put("app_version", (Object)"2.6.0");
            devicePayload.put("device_details", (Object)CommonData.deviceDetails((Context)this.activity));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return devicePayload;
    }

    @Override
    public void onErrorReceived(String channel, String msg) {
        try {
            Log.e("ON ERROR", "ON ERROR = " + msg);
            JSONObject jsonObject = new JSONObject(msg);
            if (jsonObject.optInt("statusCode") == 421) {
                this.stopSession();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

