package com.hippoagent.utils.filePicker;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import android.webkit.MimeTypeMap;

import com.hippoagent.BuildConfig;
import com.hippoagent.Config;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.model.FuguUploadImageResponse;
import com.hippoagent.model.Message;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.MultipartParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

import faye.FayeServiceListener;
import faye.FuguAgentFayeClient;
import faye.FuguAgentMetaMessage;
import okhttp3.MultipartBody;

/**
 * Created by gurmail on 16/01/19.
 *
 * @author gurmail
 */
public class UploadingService extends Service implements FayeServiceListener, FuguAppConstant, ProgressRequestBody.UploadCallbacks {

    private static final String TAG = UploadingService.class.getSimpleName();

    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";

    private Handler h;
    private Runnable r;
    FuguAgentFayeClient mClient = null;

    int counter = 0;
    private Type fileuploadType = new TypeToken<List<FileuploadModel>>() {
    }.getType();
    NotificationManager manager;
    NotificationCompat.Builder builder;

    FileuploadModel fileuploadModel;
    ArrayList<FileuploadModel> fileuploadModels = new ArrayList<>();
    boolean apiInProgress;


    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    private Notification updateNotification() {
        counter++;
        Context context = getApplicationContext();

//        PendingIntent action = PendingIntent.getActivity(context,
//                0, new Intent(context, MainActivity.class),
//                PendingIntent.FLAG_CANCEL_CURRENT); // Flag indicating that if the described PendingIntent already exists, the current one should be canceled before generating a new one.

        manager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);


        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {

            String CHANNEL_ID = "hippo_file_uploading";

            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, getString(R.string.app_name),
                    NotificationManager.IMPORTANCE_DEFAULT);
            channel.setDescription("File uploading");
            manager.createNotificationChannel(channel);

            builder = new NotificationCompat.Builder(this, CHANNEL_ID);
        } else {
            builder = new NotificationCompat.Builder(context);
        }

        builder.setProgress(100, counter, false);

        return builder.setContentTitle(getString(R.string.uploading))
                .setTicker("")
                .setOnlyAlertOnce(true)
                .setContentText(getString(R.string.uploading_in_progress))
                .setSmallIcon(R.mipmap.hippo_notif)
                .setOngoing(true).build();
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {

        if (intent.getAction().contains("start")) {
            startForeground(102, updateNotification());
//            handleException();
            uploadFileServerCall();
        } else {
            stopFayeClient();
            stopForeground(true);
            stopSelf();
        }

        return Service.START_STICKY;
    }

    public void stopFayeClient() {
        if(mClient == null)
            return;
        try {
            HandlerThread thread = new HandlerThread("TerminateThread");
            thread.start();
            new Handler(thread.getLooper()).post(new Runnable() {
                @Override
                public void run() {
                    mClient.setServiceListener(null);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateProgress(int uploaded, int total) {
        Log.e(TAG, "uploaded progress = "+uploaded);
        if(builder != null && manager != null) {
            builder.setProgress(total, uploaded, false);
            // Issues the notification
            manager.notify(102, builder.build());
        } else {
            startForeground(102, updateNotification());
        }
    }

    /**
     * Check Network Connection
     *
     * @return boolean
     */
    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }


    private void uploadFileServerCall() {
        try {
            if(apiInProgress) {
                Log.e(TAG, "***************ApiInProgress*************");
                return;
            }
            if (isNetworkAvailable()) {
                getClient();
                String data = Prefs.with(this).getString(KEY, "");
                Log.v(TAG, "uploadFileServerCall 1: "+data);
                fileuploadModels = new Gson().fromJson(data, fileuploadType);

                if(fileuploadModels == null || fileuploadModels.size()==0) {
                    Prefs.with(this).removeAll();
                    stopFayeClient();
                    stopForeground(true);
                    stopSelf();
                    return;
                }

                fileuploadModel = fileuploadModels.get(0);

                LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(fileuploadModel.getChannelId());
                if(unsentMessageMapNew == null || unsentMessageMapNew.size() == 0) {
                    Log.e(TAG, "File item not found "+fileuploadModel.getMuid());
                    updatePref();
                    return;
                }
                if(!unsentMessageMapNew.containsKey(fileuploadModel.getMuid())) {
                    Log.e(TAG, "File item not found "+fileuploadModel.getMuid());
                    updatePref();
                    return;
                }

                isFirstTime = true;
                ProgressRequestBody fileBody = new ProgressRequestBody(new File(fileuploadModel.getFilePath()),  this,
                        getMimeType(fileuploadModel.getFilePath()), fileuploadModel.getFilePath(), fileuploadModel.getMessageIndex(),
                        fileuploadModel.getMuid());
                MultipartBody.Part filePart =
                        MultipartBody.Part.createFormData("file", fileuploadModel.getFileName(), fileBody);

                MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
                MultipartParams multipartParams = multipartBuilder
                        .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                        .add(APP_VERSION, BuildConfig.VERSION_NAME)
                        .add(DEVICE_TYPE, 1)
                        .add("allow_all_mime_type", true)
                        .add("file_name", fileuploadModel.getFileName())
                        .build();

                apiInProgress = true;
                Log.v("map = ", multipartParams.getMap().toString());
                Logger.INSTANCE.apiRequest("/api/conversation/uploadFile", new Gson().toJson(multipartParams.getMap()));
                RestClient.getApiInterface()
                        .uploadFile(HippoApplication.getInstance().getUserData().getAccessToken(), 1,
                                BuildConfig.VERSION_CODE, filePart, multipartParams.getMap())
                        .enqueue(new ResponseResolver<FuguUploadImageResponse>() {

                            @Override
                            public void success(FuguUploadImageResponse fuguUploadImageResponse) {
                                Logger.INSTANCE.apiResponse("/api/conversation/uploadFile", "");
                                String image_url = fuguUploadImageResponse.getData().getUrl();
                                String thumbnail_url = fuguUploadImageResponse.getData().getThumbnailUrl();
                                
                                String data = Prefs.with(UploadingService.this).getString(KEY, "");
                                Log.v(TAG, "In response: " + data);
                                fileuploadModels = new Gson().fromJson(data, fileuploadType);
                                
                                JSONObject jsonObject = fileuploadModels.get(0).getMessageObject();
                                try {
                                    jsonObject.put(IMAGE_URL, image_url);
                                    jsonObject.put(THUMBNAIL_URL, thumbnail_url);
                                    jsonObject.put("url", image_url);
                                    jsonObject.remove("local_url");
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                fileuploadModels.get(0).setFileUploaded(true);
                                fileuploadModels.get(0).setMessageObject(jsonObject);

                                if(fileuploadModels.get(0).getChannelId() < 1) {

                                    Intent mIntent = new Intent(HIPPO_FILE_UPLOAD);
                                    mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.CREATE_CHANNEL);
                                    mIntent.putExtra("fileuploadModel", new Gson().toJson(fileuploadModels.get(0)));
                                    LocalBroadcastManager.getInstance(HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);

                                    updatePref();

                                } else {
                                    data = new Gson().toJson(fileuploadModels, fileuploadType);
                                    Log.e(TAG, "In response else case "+data);
                                    Prefs.with(UploadingService.this).save(KEY, data);

                                    fileuploadModel = fileuploadModels.get(0);

                                    if(isOpenedChatActivityMsg(fileuploadModel.getChannelId())) {
                                        Log.e(TAG, "in isOpenedChatActivityMsg");
                                        Intent mIntent = new Intent(HIPPO_FILE_UPLOAD);
                                        mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.UPLOADED_SUCESSFULLY);
                                        mIntent.putExtra("channelId", fileuploadModel.getChannelId());
                                        mIntent.putExtra("muid", fileuploadModel.getMuid());
                                        mIntent.putExtra("messageIndex", fileuploadModel.getMessageIndex());
                                        mIntent.putExtra("image_url", image_url);
                                        mIntent.putExtra("thumbnail_url", thumbnail_url);
                                        mIntent.putExtra("fileuploadModel", new Gson().toJson(fileuploadModel));
                                        LocalBroadcastManager.getInstance(HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
                                        updatePref();

                                    } else {
                                        updateLocalMessageObj(fileuploadModel.getChannelId(), false, image_url, thumbnail_url, jsonObject, new UpdateLocalMsgListener() {
                                            @Override
                                            public void onUpdation(JSONObject jsonObject) {
                                                apiInProgress = false;
                                                getClient(fileuploadModel.getChannelId(), jsonObject);
                                            }
                                        });
                                    }
                                }
                            }

                            @Override
                            public void failure(APIError error) {
                                Logger.INSTANCE.apiFailed("/api/conversation/uploadFile", error.getMessage());
//                                Log.e(TAG, "In uploading failure");
//                                apiInProgress = false;
//                                setMessageExpired();
//                                Intent mIntent = new Intent(HIPPO_FILE_UPLOAD);
//                                mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.UPLOADING_FAILED);
//                                LocalBroadcastManager.getInstance(HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
                                Log.e(TAG, "In uploading failure");
                                handleException();
//                                String data = new Gson().toJson(fileuploadModels, fileuploadType);
//                                Log.e(TAG, "In response else case "+data);
//                                Prefs.with(UploadingService.this).save(KEY, data);
//
//                                fileuploadModel = fileuploadModels.get(0);
//
//                                if(isOpenedChatActivityMsg(fileuploadModel.getChannelId())) {
//                                    apiInProgress = false;
//                                    setMessageExpired();
//                                    Intent mIntent = new Intent(HIPPO_FILE_UPLOAD);
//                                    mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.UPLOADING_FAILED);
//                                    LocalBroadcastManager.getInstance(HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
//                                } else {
//                                    apiInProgress = false;
//                                    setMessageExpired();
//                                    uploadingFailed(fileuploadModel.getChannelId());
//                                }
                            }
                        });
            } else {
//                setAllMessageExpired();
//                apiInProgress = false;
                Log.e(TAG, "In uploading else");
                handleException();
//                Intent mIntent = new Intent(HIPPO_FILE_UPLOAD);
//                mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.UPLOADING_FAILED);
//                LocalBroadcastManager.getInstance(HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
            }
        } catch (Exception e) {
            e.printStackTrace();
//            apiInProgress = false;
            Log.e(TAG, "In uploading else 2");
            handleException();
            //setAllMessageExpired();
//            Intent mIntent = new Intent(HIPPO_FILE_UPLOAD);
//            mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.UPLOADING_FAILED);
//            LocalBroadcastManager.getInstance(HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
        }
    }

    private void handleException() {
        Log.e(TAG, "In handleException failure");
        try {
            String data = Prefs.with(this).getString(KEY, "");
            Log.e(TAG, "In response else case "+data);
            fileuploadModels = new Gson().fromJson(data, fileuploadType);
            if(fileuploadModels == null || fileuploadModels.size() == 0) {
                Prefs.with(this).removeAll();
                stopFayeClient();
                stopForeground(true);
                stopSelf();
                return;
            }
            fileuploadModel = fileuploadModels.get(0);
            apiInProgress = false;
            if(isOpenedChatActivityMsg(fileuploadModel.getChannelId())) {
                setMessageExpired();
                Intent mIntent = new Intent(HIPPO_FILE_UPLOAD);
                mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.UPLOADING_FAILED);
                mIntent.putExtra("channelId", fileuploadModel.getChannelId());
                mIntent.putExtra("muid", fileuploadModel.getMuid());
                mIntent.putExtra("messageIndex", fileuploadModel.getMessageIndex());
                mIntent.putExtra("fileuploadModel", new Gson().toJson(fileuploadModel));
                LocalBroadcastManager.getInstance(HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
            } else {
                uploadingFailed(fileuploadModel.getChannelId());
                setMessageExpired();
            }
        } catch (Exception e) {
            e.printStackTrace();
            Prefs.with(this).removeAll();
            stopFayeClient();
            stopForeground(true);
            stopSelf();
        }
    }



    /**
     * get mime type of selected file/image on basis of extension
     */
    public String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl(url);
        if (extension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return type;
    }


    private void updatePref() {
        Log.e(TAG, "updatePref: "+Prefs.with(this).getString(KEY, ""));
        fileuploadModels = new Gson().fromJson(Prefs.with(this).getString(KEY, ""), fileuploadType);
        if(fileuploadModels == null || fileuploadModels.size() == 0) {
            Prefs.with(this).removeAll();
            stopFayeClient();
            stopForeground(true);
            stopSelf();
        } else {
            fileuploadModels.remove(0);
            String data = new Gson().toJson(fileuploadModels, fileuploadType);
            Prefs.with(this).save(KEY, data);

            Log.e(TAG, "int updatePref set data : "+data);
            if(fileuploadModels.size() == 0) {
                Prefs.with(this).removeAll();
                stopFayeClient();
                stopForeground(true);
                stopSelf();
            } else {
                apiInProgress = false;
                uploadFileServerCall();
            }
        }
    }

    boolean isFirstTime;
    @Override
    public void onProgressUpdate(int percentage, int mMessageIndex, String muid) {
        //Log.v(TAG, "percentage = "+percentage);
        if(isFirstTime && percentage == 10) {
            isFirstTime = false;
            return;
        }
        if(!isFirstTime && percentage == 10)
            isFirstTime = true;

        if(isFirstTime)
            updateProgress(percentage, 100);

        //Log.e(TAG, "In onProgressUpdate else 2");
    }

    @Override
    public void onError(int percentage, int mMessageIndex, String muid) {
//        ToastUtil.getInstance(this).showToast("onError");
        Log.e(TAG, "In onError else 2");
    }

    @Override
    public void onFinish(int percentage, int mMessageIndex, String muid) {
//        ToastUtil.getInstance(this).showToast("onFinish");
        Log.e(TAG, "In onFinish else 2");
    }

    public void getClient() {
        if (mClient == null) {
            FuguAgentMetaMessage meta = new FuguAgentMetaMessage();
            JSONObject jsonExt = new JSONObject();
            try {
                if (HippoApplication.getInstance().getUserData() != null) {
                    jsonExt.put("user_id", HippoApplication.getInstance().getUserData().getUserId());
                    jsonExt.put("device_type", 1);
                    jsonExt.put("source", 1);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
            meta.setAllExt(jsonExt.toString());
            mClient = new FuguAgentFayeClient(Config.getFayeServerUrl() + "faye", meta);
            mClient.connectServer();
        }
    }

    private void getClient(final int channelId, final JSONObject messageJson) {
        try {
            Log.e(TAG, "In getClient");
            if(mClient == null) {
                FuguAgentMetaMessage meta = new FuguAgentMetaMessage();
                JSONObject jsonExt = new JSONObject();
                try {
                    if (HippoApplication.getInstance().getUserData() != null) {
                        jsonExt.put("user_id", HippoApplication.getInstance().getUserData().getUserId());
                        jsonExt.put("device_type", 1);
                        jsonExt.put("source", 1);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                meta.setAllExt(jsonExt.toString());
                mClient = new FuguAgentFayeClient(Config.getFayeServerUrl() + "faye", meta);
                mClient.connectServer();
                Log.e(TAG, "In mClient null");
//                        updatePref();
//                        return;
            }
            if(mClient == null) {
                Log.e(TAG, "In mClient null return");
                return;
            }
            afterSetUpFayeConnection(channelId, messageJson);
            /*HippoApplication.getInstance().getClient(new fayeClient() {
                @Override
                public void Listener(@NotNull FuguAgentFayeClient client) {
                    mClient = client;
                    Log.e(TAG, "In getClient listener");
                    if(mClient == null) {
                        FuguAgentMetaMessage meta = new FuguAgentMetaMessage();
                        JSONObject jsonExt = new JSONObject();
                        try {
                            if (FuguConfig.getInstance().getUserData() != null) {
                                jsonExt.put("user_id", FuguConfig.getInstance().getUserData().getUserId());
                                jsonExt.put("device_type", 1);
                                jsonExt.put("source", 1);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        meta.setAllExt(jsonExt.toString());
                        mClient = new FuguAgentFayeClient(Config.getFayeServerUrl() + "faye", meta);
                        Log.e(TAG, "In mClient null");
//                        updatePref();
//                        return;
                    }
                    if(mClient == null) {
                        Log.e(TAG, "In mClient null return");
                        return;
                    }
                    afterSetUpFayeConnection(channelId, messageJson);
                }
            });*/
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void afterSetUpFayeConnection(int channelId, JSONObject messageJson) {
        mClient.setServiceListener(this);
        if (!mClient.isConnectedServer() && isNetworkAvailable()) {
            mClient.connectServer();
            mClient.publish("/" + String.valueOf(channelId), messageJson);
            updatePref();
            Log.e(TAG, "************isConnectedServer*********");
        } else if (mClient.isConnectedServer()) {
            Log.e(TAG, "************publish*********");
            mClient.publish("/" + String.valueOf(channelId), messageJson);
            updatePref();
        } else if(!isNetworkAvailable()) {
            Log.e(TAG, "************isNetworkAvailable*********");
            Intent mIntent = new Intent(HIPPO_FILE_UPLOAD);
            mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.UPLOADED_SUCESSFULLY);
            LocalBroadcastManager.getInstance(HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
            updatePref();
        }
    }

    @Override
    public void onConnectedServer(FuguAgentFayeClient fc) {
        Log.e(TAG, "************onConnectedServer*********");

        ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(UploadingService.this).getString(KEY, ""), fileuploadType);
        for(FileuploadModel fileuploadModel : fileuploadModels) {
            if(fileuploadModel.isFileUploaded()) {
                if(mClient.hasSubscribed("/" + String.valueOf(fileuploadModel.getChannelId()))) {
                    mClient.subscribeChannel("/" + String.valueOf(fileuploadModel.getChannelId()));
                }

                mClient.publish("/" + String.valueOf(fileuploadModel.getChannelId()), fileuploadModel.getMessageObject());
//                updatePref();
                break;
            }
        }
    }

    @Override
    public void onDisconnectedServer(FuguAgentFayeClient fc) {

    }

    @Override
    public void onReceivedMessage(FuguAgentFayeClient fc, String msg, String channel) {
        try {
            JSONObject messageJson = new JSONObject(msg);
            if(messageJson.optInt(MESSAGE_TYPE, 0) == IMAGE_MESSAGE ||
                    messageJson.optInt(MESSAGE_TYPE, 0) == FILE_MESSAGE) {
                int value = messageJson.optInt("channel_id");
                if (!isOpenedChatActivityMsg(value)) {
                    updateLocalMessageObj(value, true, "", "", null, null);
                }
                updatePref();
                //Toast.makeText(this, "" + msg, Toast.LENGTH_SHORT).show();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPongReceived() {

    }

    @Override
    public void onWebSocketError() {

    }

    @Override
    public void onErrorReceived(FuguAgentFayeClient fc, String msg, String channel) {

    }

    private boolean isOpenedChatActivityMsg(int channelId) {
        ActivityManager mngr = (ActivityManager) getSystemService(ACTIVITY_SERVICE);
        List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);
        if (taskList.get(0).topActivity.getClassName().equals("com.hippoagent.activities.FuguChatActivity")
                && FuguChatActivity.currentChannelId == channelId) {
            return true;
        }
        return false;
    }

    private void uploadingFailed(int channelId) {
        String data = Prefs.with(UploadingService.this).getString(KEY, "empty");
        if(data.equals("empty")) {
            apiInProgress = false;
            Log.v(TAG, "data = "+data);
            return;
        }
        ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(data, fileuploadType);
        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
        if(index == -1)
            return;
        FileuploadModel fileuploadModel = fileuploadModels.get(index);

        LinkedHashMap<String, Message> unsentMessages = CommonData.getUnsentMessageByChannel(channelId);
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(channelId);

        Message listItem = unsentMessages.get(fileuploadModel.getMuid());
        if (listItem == null)
            return;

        Message message = listItem;
        message.setUploadStatus(UPLOAD_FAILED);
        message.setMessageStatus(MESSAGE_FILE_RETRY);
        message.setIsMessageExpired(1);
        message.setLocalImagePath(fileuploadModel.getFilePath());
        unsentMessages.put(fileuploadModel.getMuid(), message);
        CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
    }

    private void updateLocalMessageObj(int channelId, boolean isPublished, String url, String thumbnailUrl,
                                       JSONObject jsonObject, UpdateLocalMsgListener msgListener) {
        String data = Prefs.with(UploadingService.this).getString(KEY, "empty");
        Log.v(TAG, "data = "+data);
        if(data.equals("empty")) {
            apiInProgress = false;
            updatePref();
            return;
        }
        ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(data, fileuploadType);
        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
        if(index == -1) {
            updatePref();
            return;
        }
        FileuploadModel fileuploadModel = fileuploadModels.get(index);

        LinkedHashMap<String, Message> sentMessages = CommonData.getSentMessageByChannel(channelId);
        LinkedHashMap<String, Message> unsentMessages = CommonData.getUnsentMessageByChannel(channelId);
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(channelId);

        Message listItem = unsentMessages.get(fileuploadModel.getMuid());
        Log.v(TAG, "listItem data = "+new Gson().toJson(listItem));
        if (listItem == null) {
            updatePref();
            return;
        }

        if(isPublished) {
            listItem.setMessageStatus(MESSAGE_SENT);
            List<String> reverseOrderedKeys = new ArrayList<>(sentMessages.keySet());
            Collections.reverse(reverseOrderedKeys);
            String tempSentAtUTC = "";
            for (String key : reverseOrderedKeys) {
                if (sentMessages.get(key).isDateView()) {
                    tempSentAtUTC = key;
                    break;
                }
            }
            String time = listItem.getSentAtUtc();
            String localDate = DateUtils.getInstance().convertToLocal(time, inputFormat, outputFormat);
            if (!tempSentAtUTC.equalsIgnoreCase(localDate)) {
                sentMessages.put(localDate, new Message(localDate, true));
            }
            sentMessages.put(fileuploadModel.getMuid(), listItem);

            unsentMessages.remove(fileuploadModel.getMuid());
            unsentMessageMapNew.remove(fileuploadModel.getMuid());

            CommonData.setSentMessageByChannel(channelId, sentMessages);

        } else {
            Message message = listItem;
            message.setFileUrl(url);
            message.setUrl(url);
            message.setThumbnailUrl(thumbnailUrl);
            message.setUploadStatus(UPLOAD_COMPLETED);

            unsentMessages.put(fileuploadModel.getMuid(), message);

            JSONObject object = null;
            try {
                object = unsentMessageMapNew.get(fileuploadModel.getMuid());
                object.put(IMAGE_URL, url);
                object.put(THUMBNAIL_URL, thumbnailUrl);
                object.put("url", url);
                unsentMessageMapNew.put(fileuploadModel.getMuid(), object);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
        CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMapNew);

        Log.v(TAG, "unsentMessageMapNew data = "+new Gson().toJson(unsentMessageMapNew));

        if(msgListener != null)
            msgListener.onUpdation(jsonObject);

    }

    private void setAllMessageExpired() {
        fileuploadModels = new Gson().fromJson(Prefs.with(this).getString(KEY, ""), fileuploadType);
        if(fileuploadModels == null || fileuploadModels.size()==0) {
            Prefs.with(this).remove(KEY);
            stopFayeClient();
            stopForeground(true);
            stopSelf();
            return;
        } else {
            for(FileuploadModel fileuploadModel : fileuploadModels) {
                if (isOpenedChatActivityMsg(fileuploadModel.getChannelId())) {
                    sendLocalBroadcast(fileuploadModel);
                } else {
                    updateLocalMessages(fileuploadModels.get(0));
                }
            }
            fileuploadModels.clear();
            Prefs.with(this).remove(KEY);
            stopFayeClient();
            stopForeground(true);
            stopSelf();

        }
    }

    private void setMessageExpired() {
        String data = Prefs.with(this).getString(KEY, "");
        Log.e(TAG, "In setMessageExpired: "+data);
        fileuploadModels = new Gson().fromJson(data, fileuploadType);
        if(fileuploadModels == null || fileuploadModels.size()==0) {
            Prefs.with(this).removeAll();
            stopFayeClient();
            stopForeground(true);
            stopSelf();
        } else {
            //FileuploadModel fileuploadModel = fileuploadModels.get(0);
            if (isOpenedChatActivityMsg(fileuploadModels.get(0).getChannelId())) {
                sendLocalBroadcast(fileuploadModels.get(0));
            } else {
                updateLocalMessages(fileuploadModels.get(0));
            }
            fileuploadModels.remove(0);
            data = new Gson().toJson(fileuploadModels, fileuploadType);
            Log.e(TAG, "In setMessageExpired after update: "+data);
            Prefs.with(this).save(KEY, data);

            uploadFileServerCall();
        }
    }

    private void sendLocalBroadcast(FileuploadModel fileuploadModel) {
        Intent mIntent = new Intent(HIPPO_FILE_UPLOAD);
        mIntent.putExtra("muid", fileuploadModel.getMuid());
        mIntent.putExtra("messageIndex", fileuploadModel.getMessageIndex());
        mIntent.putExtra(BROADCAST_STATUS, BroadCastStatus.MESSAGE_EXPIRED);
        LocalBroadcastManager.getInstance(HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
    }

    private void updateLocalMessages(FileuploadModel fileuploadModel) {
        String muid = fileuploadModel.getMuid();

        LinkedHashMap<String, Message> unsentMessages = CommonData.getUnsentMessageByChannel(fileuploadModel.getChannelId());
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(fileuploadModel.getChannelId());

        if (unsentMessages == null)
            unsentMessages = new LinkedHashMap<>();

        Message listItem = unsentMessages.get(muid);
        listItem.setIsMessageExpired(1);
        try {
            JSONObject messageJson = unsentMessageMapNew.get(muid);
            messageJson.put("is_message_expired", 1);
            unsentMessageMapNew.put(muid, messageJson);
        } catch (Exception e) {
            //e.printStackTrace();
        }

        CommonData.setUnsentMessageByChannel(fileuploadModel.getChannelId(), unsentMessages);
        CommonData.setUnsentMessageMapByChannel(fileuploadModel.getChannelId(), unsentMessageMapNew);

    }

    public interface UpdateLocalMsgListener {
        void onUpdation(JSONObject jsonObject);
    }
}