package com.hippoagent.utils;

import android.app.Activity;
import android.util.Patterns;
import android.widget.EditText;

import com.hippoagent.R;
import com.hippoagent.langs.Restring;

public class ValidateClass {

    private Activity context;
    private int fifteen=15;
    private int ten=10;
    private int twelve= 12;

    public ValidateClass(Activity context) {

        this.context = context;
    }

    /**
     * Method to validate field is empty or not
     *
     * @param et
     * @return
     */
    public boolean genericEmpty(EditText et) {

        return et.getText().toString().trim().isEmpty();
    }

    /**
     * Method to validate field is empty or not and display error
     * like on state,city and any other whose specific validations are not required
     *
     * @param et
     * @param msg
     * @return boolean
     */
    public boolean genericEmpty(EditText et, String msg) {
        if (genericEmpty(et)) {
            return setErrorAndRequestFoucs(et, msg);
        }
        return true;
    }

    /**
     * set Error on materialEditText and return false
     *
     * @param et
     * @param errorMessage
     * @return
     */
    public boolean setErrorAndRequestFoucs(EditText et, String errorMessage) {
        et.setSelection(et.getText().toString().length());
        et.setHovered(true);
        et.requestFocus();
        et.setError(errorMessage);
        return false;
    }

    /**
     * Password validation
     *
     * @param et
     * @return
     */
    public Boolean checkPassword(EditText et) {

        if (genericEmpty(et)) {
            return setErrorAndRequestFoucs(et, Restring.getString(context, R.string.PleaseEnterPassword));
        } else if (et.getText().toString().length() < 6) {
            return setErrorAndRequestFoucs(et, Restring.getString(context, R.string.PasswordContainAtleastSixChar));
        }
        return true;
    }

    /**
     * for password matching
     *
     * @param passEt
     * @param confirmPassEt
     * @return
     */
    public Boolean passwordMatch(EditText passEt, EditText confirmPassEt) {
        if (genericEmpty(confirmPassEt)) {
            return setErrorAndRequestFoucs(confirmPassEt, Restring.getString(context, R.string.PleaseEnterConfrimPassword));

        } else if (!passEt.getText().toString().equals(confirmPassEt.getText().toString())) {
            return setErrorAndRequestFoucs(confirmPassEt, Restring.getString(context, R.string.PasswordDoesntMatch));

        }
        return true;

    }

    /**
     * first name validation
     *
     * @param et
     * @return
     */
    public Boolean checkName(EditText et) {
        if (genericEmpty(et)) {
            return setErrorAndRequestFoucs(et, Restring.getString(context, R.string.PleaseEnterFirstName));
        } else if (et.getText().toString().trim().length() < 3) {
            return setErrorAndRequestFoucs(et, Restring.getString(context, R.string.NameThreeCharLong));
        } else if (!et.getText().toString().matches("^[\\p{L} .'-]+$")) {//It takes alphabets and spaces and dots...
            return setErrorAndRequestFoucs(et, Restring.getString(context, R.string.NameCannotContainSpecialCharacters));
        }
        return true;

    }

    /**
     * last name validation
     *
     * @param et
     * @return
     */
    public Boolean checkLastName(EditText et) {

        if (genericEmpty(et)) {
            return setErrorAndRequestFoucs(et, context.getString(R.string.PleaseEnterLastName));
        } else if (!et.getText().toString().trim().matches("\\p{L}+")) { //It takes alphabets only...
            return setErrorAndRequestFoucs(et, context.getString(R.string.LastNameCannotContainSpecialChar));
        }
        return true;

    }

    /**
     * email address validation
     * @param et
     * @return
     */
    public Boolean checkEmail(EditText et) {
        String email = et.getText().toString().trim();
        if (genericEmpty(et))
            return setErrorAndRequestFoucs(et, context.getString(R.string.PleaseEnterEmailId));

        if (!email.matches(Patterns.EMAIL_ADDRESS.toString()))
            return setErrorAndRequestFoucs(et, context.getString(R.string.PleaseEnterValidEmail));

        return true;

    }

    /**
     * phone number validation
     * @param et
     * @return
     */
    public Boolean checkPhoneNumber(EditText et,boolean loginScreen) {

        try {
            String phone = et.getText().toString();
            if (phone.matches("[^a-zA-Z]+")) {
                phone = phone.replace("[^a-zA-Z]+", "");
            }
            if (genericEmpty(et)) {
                return setErrorAndRequestFoucs(et, context.getString(R.string.PleaseEnterPhoneNo));
            } else if (phone.trim().charAt(0) == '0') {
                return setErrorAndRequestFoucs(et, context.getString(R.string.PhoneNoCannotStartFromZero));
            } else if (phone.trim().length() > fifteen) {
                return setErrorAndRequestFoucs(et, context.getString(R.string.PhoneLengthAtmostfifteen));

            }
            else if (phone.trim().length() < ten && loginScreen) {
                return setErrorAndRequestFoucs(et, context.getString(R.string.PleaseEnterValidPhoneNo));
            }
            else if (phone.trim().length() < twelve && !loginScreen) {
                return setErrorAndRequestFoucs(et, context.getString(R.string.PleaseEnterValidPhoneNo));
            /*else if (et.getText().toString().trim().length() < 6) {
                return setErrorAndRequestFoucs(et, context.getString(R.string.PhoneLengthAtleastSix));*/

//            } else if (Long.valueOf(et.getText().toString().trim()) == 0) {
//
//                return setErrorAndRequestFoucs(et, context.getString(R.string.PleaseEnterValidPhoneNo));
            }

            return true;
        } catch (NumberFormatException e) {
            return setErrorAndRequestFoucs(et, context.getString(R.string.PleaseEnterValidPhoneNo));
        }
    }

    /**
     * OTP validation
     * @param otp
     * @param et
     * @return
     */
    public Boolean checkOTP(String otp, EditText et) {

        if (otp.compareTo("") == 0) {
            return setErrorAndRequestFoucs(et, context.getString(R.string.PleaseEnterOtp));
        }
        if (otp.length() < 4) {
            return setErrorAndRequestFoucs(et, context.getString(R.string.PleaseEnterFourDigitOtp));
        }

        return true;
    }

}
