package com.hippoagent.utils;

import android.app.IntentService;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;

import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.MessageMode;
import com.hippoagent.fcm.NotificationDatabase;
import com.hippoagent.fcm.NotificationUtils;
import com.hippoagent.fcm.PushHandler;
import com.hippoagent.fcm.SendReplyMessage;
import com.hippoagent.model.Conversation;
import com.google.gson.Gson;

import org.json.JSONObject;

import static com.hippoagent.activities.FuguChatActivity.pushChannelId;
import static com.hippoagent.datastructure.FuguAppConstant.NOTIFICATION_TAPPED;

/**
 * Created by Bhavya Rattan on 26/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public class PushIntentService extends IntentService {

    private static final String TAG = "PushIntentService";

    public PushIntentService() {
        super(TAG);
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        String message = (String) PushHandler.Reply.INSTANCE.getReplyMessage(intent);
        if(!TextUtils.isEmpty(message)) {
            Log.d(TAG, "Message := "+message);

            try {
                String payload = intent.getStringExtra("json");
                JSONObject data = new JSONObject(payload);
                new SendReplyMessage(this).sendMessage(data, message);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        Intent notificationIntent = null;
        try {
            String payload = intent.getStringExtra("json");
            JSONObject data = new JSONObject(payload);

            int channedId = data.optInt("channel_id", -1);
            int userId = data.optInt("user_id", -1);
            int disableReply = data.optInt("disable_reply", 0);
            String label = data.optString("label", "User");
            boolean isRecreated = data.optBoolean("is_recreated", false);
            boolean isPromotionalPush = data.optBoolean("is_promotional", false);


            Conversation conversation = new Conversation();
            conversation.setChannelId(channedId);
            conversation.setLabel(label);
            if(isRecreated) {
                String messageData = data.optString("push_message");
                Log.e(TAG, "messageData = "+messageData);
                conversation.setPushMessage(messageData);
            }

            conversation.setUserId(userId);
            conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());
            conversation.setDisableReply(disableReply);

//            if(isPromotionalPush) {
//                notificationIntent = new Intent(this, SplashActivity.class);
//                notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
//            } else
                {
                if (HippoConfig.getInstance() != null && HippoApplication.getInstance().getUserData() != null
                && HippoConfig.getInstance().isHippoInit()) {
                    notificationIntent = new Intent(this, HomeActivity.class);
                    if(pushChannelId > 0) {
                        Intent mIntent = new Intent(NOTIFICATION_TAPPED);
                        notificationIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                        LocalBroadcastManager.getInstance(this).sendBroadcast(mIntent);
                        return;
                    } else if(channedId > 0) {
                        notificationIntent = new Intent(this, FuguChatActivity.class);
                        notificationIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                        notificationIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        //notificationIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
                        //notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);

                    }
                } else {
                    PackageManager pm = this.getPackageManager();
                    notificationIntent = pm.getLaunchIntentForPackage(this.getPackageName());
                    notificationIntent.putExtra("startChatActivity", true);
                    notificationIntent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        startActivity(notificationIntent);
    }

    private void clearNotification(int channelId) {
        try {
            NotificationDatabase.INSTANCE.removeNotifications(channelId);
            NotificationUtils.clearNotifications(this, channelId);
            CommonData.removeNotificationChannel(channelId);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
