package com.hippoagent.utils;

import android.content.res.Resources;
import android.util.DisplayMetrics;

/**
 * Created by ankit on 07/06/17.
 */

public interface Constants {
    // global topic to receive app wide push notifications
    public final String TOPIC_GLOBAL = "global";
//    public final String URL = "https://api.fuguchat.com:3002/"; // Live
//    public final String URL = "https://alpha-api.fuguchat.com:3000/"; // Dev
    public final String URL = "https://beta-api.fuguchat.com:3001/"; // Test

    // broadcast receiver intent filters
    public final String REGISTRATION_COMPLETE = "registrationComplete";

    // id to handle the notification in the notification tray
    public final int NOTIFICATION_ID = 100;
    public final int NOTIFICATION_ID_BIG_IMAGE = 101;
    public final int defaultPageSize = 20;

    public final String SHARED_PREF = "ah_firebase";
    String ACCESS_TOKEN = "access_token";
    String AUTH_TOKEN = "auth_token";
    String AGENT_SECRET_KEY = "agent_secret_key";
    String USER_ID = "user_id";
    String EN_USER_ID = "en_user_id";
    String CHANNEL_ID = "channel_id";
    String MESSAGE_TYPE = "1";
    String CONVERSATION = "conversation";
    String TAGS_DATA = "tag_data";
    String RESULT = "result";
    String STATUS = "status";
    String CLOSING_NOTES = "activity_message";
    String CHANNEL_STATUS = "channel_status";
    String BUSINESS_ID = "business_id";
    String ONLINE_STATUS = "online_status";
    String DEVICE_TOKEN = "device_token";
    String APP_VERSION_CODE = "app_version_code";
    String ANDROID = "1";
    String PASSWORD = "password";
    String EMAIL = "email";
    String TYPE = "type";
    String PAGE_START = "page_start";
    String PAGE_OFFSET = "page_offset";
    String ROW_COUNT = "row_count";
    String PAGE_END = "page_end";
    String USER_TYPE = "user_type";
    String LABEL = "label";
    String START_DATE = "startDate";
    String END_DATE = "endDate";
    int CONVERSATION_OPEN = 0;
    String AGENT_ID = "agent_id";
    String LABEL_ID = "label_id";
    String AGENT_EMAIL_ID = "agent_email";
    String PAPER_COLOR_CONFIG = "paper_color_config";
    String FULL_NAME = "full_name";
    String PHONE_NUMBER = "phone_number";
    String FILE = "file";
    String AGENT_TYPE = "agent_type";
    String OLD_PASSWORD = "old_password";
    String NEW_PASSWORD = "new_password";
    String AGENT_IDS = "agentIds";
    String CHANNEL_IDS = "channelIds";
    String TAG_IDS = "tagIds";

    String DEVICE_ID = "device_id";
    String APP_TYPE = "app_type";
    String DEVICE_TYPE = "device_type";
    String APP_VERSION = "app_version";
    String DEVICE_DETAILS = "device_details";
    String APP_SOURCE = "source";
    String CREATED_BY = "created_by";
    String DEAL_ID = "deal_id";
    String APP_SOURCE_TYPE = "source_type";
    int ANDROID_USER = 1;
    int APPTYPE = 1;
    String FOLLOWERS_DATA = "follower_data";

    public static float convertDpToPixel(float dp){
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * (metrics.densityDpi / 160f);
        return Math.round(px);
    }


    /**
     * Custom Fields Data
     */
    interface CustomField {

        /**
         * Custom Field: DataTypes
         */
        interface DataType {

//            String TEXT            = "TEXT";
//            String TEXTVIEW        = "TEXTVIEW";
//            String NUMBER          = "NUMBER";
//            String TELEPHONE       = "PHONE_NUMBER";
//            String EMAIL           = "EMAIL";
//            String DOCUMENT        = "ATTACHMENT";

            String EMAIL = "EMAIL";
            String NUMBER = "NUMBER";
            String TELEPHONE = "TELEPHONE";
            String TEXT = "TEXT";
            String DOCUMENT = "DOCUMENT";
            String TEXTAREA = "TEXTAREA";
            String ACTION_BUTTON_DONE = "ACTION_BUTTON_DONE";

            String DATE = "DATE";
            String DATE_FUTURE = "DATE-FUTURE";
            String DATE_PAST = "DATE-PAST";
            String DATE_TIME = "DATE-TIME";
            String TIME = "TIME";
            String DATETIME_FUTURE= "DATETIME-FUTURE";
            String DATETIME_PAST = "DATETIME-PAST";
            String CHECKBOX = "CHECKBOX";
            String IMAGE = "IMAGE";
            String SINGLE_SELECT = "SINGLE-SELECT";
            String MULTI_SELECT = "MULTI-SELECT";

        }

        interface Label {
            String DESTINATION_ADDRESS        = "destinationAddress";
            String DISTANCE_UNIT              = "distanceUnit";
            String DISTANCE_CONVERSION_FACTOR = "distanceConversionFactor";
            String FIXED_FARE                 = "baseFare";
            String THRESHOLD_DISTANCE         = "thresholdDistance";
            String FARE_PER_DISTANCE          = "distanceFare";
            String FARE_PER_MIN               = "timeFare";
            String FREE_MINUTES               = "thresholdTime";
            String DESTINATION_LATITUDE       = "destinationLatitude";
            String DESTINATION_LONGITUDE      = "destinationLongitude";
            String SURGE_FACTOR               = "surgeFactor";
            String MIN_PICK_UP_DISTANCE       = "minPickupDistance";
        }

        /**
         * Custom Field: DataTypes
         */
        interface EditableType {

            String READABLE   = "0";
            String READ_WRITE = "1";
            String HIDDEN     = "2";
            String READ_ONLY  = "Read Only";
        }

    }

}
