package com.hippoagent.model.user_details;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by gurmail on 2019-09-09.
 *
 * @author gurmail
 */
public class CJourney implements Parcelable {
    @SerializedName("time")
    @Expose
    String date;
    @SerializedName("url")
    @Expose
    String link;
    @SerializedName("description")
    @Expose
    String description;
    boolean isHeader;

    public boolean isHeader() {
        return isHeader;
    }

    public void setHeader(boolean header) {
        isHeader = header;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CJourney() {
    }

    public CJourney(boolean isHeader, String date) {
        this.isHeader = isHeader;
        this.date = date;
    }

    public CJourney(String date, String description, String link) {
        this.date = date;
        this.description = description;
        this.link = link;
    }



    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.date);
        dest.writeString(this.link);
        dest.writeString(this.description);
        dest.writeByte(this.isHeader ? (byte) 1 : (byte) 0);
    }

    protected CJourney(Parcel in) {
        this.date = in.readString();
        this.link = in.readString();
        this.description = in.readString();
        this.isHeader = in.readByte() != 0;
    }

    public static final Creator<CJourney> CREATOR = new Creator<CJourney>() {
        @Override
        public CJourney createFromParcel(Parcel source) {
            return new CJourney(source);
        }

        @Override
        public CJourney[] newArray(int size) {
            return new CJourney[size];
        }
    };
}
