package com.hippoagent.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by gurmail on 2019-12-20.
 *
 * @author gurmail
 */
public class MultiSelectButtons implements Parcelable {

    @SerializedName("btn_id")
    @Expose
    private String btnId;
    @SerializedName("btn_title")
    @Expose
    private String title;
    @SerializedName("status")
    @Expose
    private int status;

    protected MultiSelectButtons(Parcel in) {
        btnId = in.readString();
        title = in.readString();
        status = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(btnId);
        dest.writeString(title);
        dest.writeInt(status);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<MultiSelectButtons> CREATOR = new Creator<MultiSelectButtons>() {
        @Override
        public MultiSelectButtons createFromParcel(Parcel in) {
            return new MultiSelectButtons(in);
        }

        @Override
        public MultiSelectButtons[] newArray(int size) {
            return new MultiSelectButtons[size];
        }
    };

    public String getBtnId() {
        return btnId;
    }

    public void setBtnId(String btnId) {
        this.btnId = btnId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

