package com.hippoagent.model.LoginResponse;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by gurmail on 2020-05-31.
 *
 * @author gurmail
 */
public class BusinessCurrency implements Parcelable {
    @SerializedName("currency")
    @Expose
    private String currency;
    @SerializedName("currency_symbol")
    @Expose
    private String currencySymbol;

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCurrencySymbol() {
        return currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    protected BusinessCurrency(Parcel in) {
        currency = in.readString();
        currencySymbol = in.readString();
    }

    public BusinessCurrency(String currency, String currencySymbol) {
        this.currency = currency;
        this.currencySymbol = currencySymbol;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(currency);
        dest.writeString(currencySymbol);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<BusinessCurrency> CREATOR = new Creator<BusinessCurrency>() {
        @Override
        public BusinessCurrency createFromParcel(Parcel in) {
            return new BusinessCurrency(in);
        }

        @Override
        public BusinessCurrency[] newArray(int size) {
            return new BusinessCurrency[size];
        }
    };
}
