package com.hippoagent.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.SerializedName;

/**
 * Created by cl-macmini-01 on 12/15/17.
 */

public class ActionButtonModel implements Parcelable {

    @SerializedName("button_text")
    private String buttonText;

    @SerializedName("button_action")
    private Object buttonAction;

    public Object getButtonAction() {
        return buttonAction;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(final String buttonText) {
        this.buttonText = buttonText;
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable) this.buttonAction, flags);
        dest.writeString(this.buttonText);
    }

    public ActionButtonModel() {
    }

    protected ActionButtonModel(Parcel in) {
        this.buttonAction = in.readParcelable(getClass().getClassLoader());
        this.buttonText = in.readString();
    }

    public static final Creator<ActionButtonModel> CREATOR = new Creator<ActionButtonModel>() {
        @Override
        public ActionButtonModel createFromParcel(Parcel source) {
            return new ActionButtonModel(source);
        }

        @Override
        public ActionButtonModel[] newArray(int size) {
            return new ActionButtonModel[size];
        }
    };
}
