package com.hippoagent.hippocall;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;

import com.hippoagent.BuildConfig;
import com.hippoagent.HippoConfig;
import com.hippoagent.model.FuguDeviceDetails;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;

import io.paperdb.Paper;

import java.util.HashMap;

/**
 * Created by gurmail on 21/02/19.
 *
 * @author gurmail
 */
public final class CommonData {

    private static String name = "hippo.paperdb";

    static String PAPER_CALL_STATUS = "hippo_call_status";
    static String PAPER_VIDEO_CALL = "hippo_video_call_cred";
    static String PAPER_CALL_TYPE = "hippo_call_type";
    static String PAPER_USER_ID = "hippo_user_id";
    static String PAPER_CHANEL_ID = "hippo_channel_id";
    private static final String VIDEO_CALL_MODEL = "video_call_model_new";

    public static String getCallStatus() {
        return Paper.book(name).read(PAPER_CALL_STATUS);
    }

    public static String getCallType() {
        return Paper.book(name).read(PAPER_CALL_TYPE);
    }

    public static JsonObject deviceDetails(Context context) {
        Gson gson = new GsonBuilder().create();
        JsonObject deviceDetailsJson = null;
        try {
            deviceDetailsJson = gson.toJsonTree(new FuguDeviceDetails(
                    getAppVersion(context)).getDeviceDetails()).getAsJsonObject();
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return deviceDetailsJson;

    }

    public static void setCallStatus(String callStatus) {
        Paper.book(name).write(PAPER_CALL_STATUS, callStatus);
    }

    public static void setCallAnswered(boolean b) {
        Paper.book(name).write("hippo_call_answer", b);
    }

    public static boolean isCallAnswered() {
        return Paper.book(name).read("hippo_call_answer", false);
    }

    public static void setCallType(String callType) {
        Paper.book(name).write(PAPER_CALL_TYPE, callType);
    }

    public static void setUserId(Long userId) {
        Paper.book(name).write(PAPER_USER_ID, userId);
    }

    public static Long getUserId() {
        return Long.parseLong(Paper.book(name).read(PAPER_USER_ID));
    }

    public static int getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getPackageName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0).packageName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getUniqueIMEIId(Context activity) {
        String android_id = "";
        try {
            try {
                android_id = Settings.Secure.getString(activity.getContentResolver(), Settings.Secure.ANDROID_ID);
            } catch (Exception e) {
                if(HippoConfig.getInstance().getAttributes().isShowLog())
                    e.printStackTrace();
            }
            android_id = TextUtils.isEmpty(android_id) ? Build.SERIAL : android_id;
        } catch (Exception e) {
            if(HippoConfig.getInstance().getAttributes().isShowLog())
                e.printStackTrace();
        }

        android_id = TextUtils.isEmpty(android_id) ? "12345" : android_id;

        try {
            android_id = android_id + CommonData.getPackageName(activity);
        } catch (Exception e) {

        }
        return android_id;
    }

    public static boolean hasExtraView() {
        return Paper.book(name).read("hippo_call_extra_view", false);
    }

    public static void setExtraView(boolean b) {
        Paper.book(name).write("hippo_call_extra_view", b);
    }

    public static HashMap<String, Long> CHANNEL_IDS = new HashMap<>();

    public static void setChannelIds(String transactionId, Long channelId) {
        try {
            CHANNEL_IDS =  getChannelId();
            if(CHANNEL_IDS.size()>2500)
                CHANNEL_IDS.clear();

            CHANNEL_IDS.put(transactionId, channelId);
            Paper.book(name).write(PAPER_CHANEL_ID, CHANNEL_IDS);
        } catch (Exception e) {

        }
    }

    public static HashMap<String, Long> getChannelId() {
        try {
            return Paper.book(name).read(PAPER_CHANEL_ID, new HashMap<>());
        } catch (Exception e) {
            return new HashMap<>();
        }
    }

    public static Long getChannelId(String transactionId) {
        try {
            CHANNEL_IDS =  getChannelId();
            return CHANNEL_IDS.get(transactionId);
        } catch (Exception e) {
            return null;
        }
    }

    public static void setVideoCallModel(VideoCallModel videoCallModel) {
        if (videoCallModel == null) {
            Paper.book(name).write(VIDEO_CALL_MODEL, "");
        } else {
            Paper.book(name).write(VIDEO_CALL_MODEL, videoCallModel);
        }
    }

    public static VideoCallModel getVideoCallModel() {
        return Paper.book(name).read(VIDEO_CALL_MODEL);
    }
}
