package com.hippoagent.fragments

import android.content.Context
import android.graphics.PorterDuff
import android.os.Bundle
import com.google.android.material.tabs.TabLayout
import androidx.core.content.ContextCompat
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.hippoagent.R
import com.hippoagent.eventbus.BusProvider
import com.hippoagent.eventbus.FragmentEvent
import com.hippoagent.eventbus.UpdateEvent
import com.squareup.otto.Subscribe
import kotlinx.android.synthetic.main.fragment_pager.*

/**
 * Created by gurmail on 2019-12-27.
 * @author gurmail
 */
class LauncherFragment : androidx.fragment.app.Fragment(), androidx.viewpager.widget.ViewPager.OnPageChangeListener {

    companion object {
        fun newInstance() = LauncherFragment()
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_pager, container, false)
    }

    var tabIcons = intArrayOf(R.drawable.ic_chat_tab, R.drawable.ic_analytics, R.drawable.ic_menu_tab)

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        val pagerAdapter = MainPager(childFragmentManager, 1)
        pagerView.adapter = pagerAdapter
        pagerView.setPagingEnabled(false)
        pagerView.offscreenPageLimit = 3
        pagerView.addOnPageChangeListener(this)
        tabs.setupWithViewPager(pagerView)
        tabs.visibility = View.GONE
        tabs.getTabAt(0)?.setIcon(tabIcons[0])
        tabs.getTabAt(1)?.setIcon(tabIcons[1])
        tabs.getTabAt(2)?.setIcon(tabIcons[2])

        tabs.addOnTabSelectedListener(object : TabLayout.ViewPagerOnTabSelectedListener(pagerView) {
            override fun onTabSelected(tab: TabLayout.Tab) {
                super.onTabSelected(tab)
                val tabIconColor = ContextCompat.getColor(activity?.applicationContext!!, R.color.tabSelectedIconColor)
                tab.icon?.setColorFilter(tabIconColor, PorterDuff.Mode.SRC_IN)
            }

            override fun onTabUnselected(tab: TabLayout.Tab) {
                super.onTabUnselected(tab)
                val tabIconColor = ContextCompat.getColor(activity?.applicationContext!!, R.color.tabUnselectedIconColor)
                tab.icon?.setColorFilter(tabIconColor, PorterDuff.Mode.SRC_IN)
            }

            override fun onTabReselected(tab: TabLayout.Tab) {
                super.onTabReselected(tab)
            }
        }
        )
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
    }

    override fun onDestroyView() {
        super.onDestroyView()
        pagerView.removeOnPageChangeListener(this)
    }

    override fun onResume() {
        super.onResume()

    }

    override fun onPause() {
        super.onPause()
    }

    override fun onDestroy() {
        super.onDestroy()
    }

    override fun onPageScrollStateChanged(position: Int) {

    }

    override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {
        BusProvider.getInstance().post(UpdateEvent(4, position))
    }

    override fun onPageSelected(position: Int) {

    }

    override fun onStart() {
        super.onStart()
        BusProvider.getInstance().register(this);
    }

    override fun onStop() {
        super.onStop()
        BusProvider.getInstance().unregister(this);
    }

    @Subscribe
    public fun onFragmentEvent(event: FragmentEvent) {
        if(event.fragmentType == 3) {
            pagerView.currentItem = 0
        }
    }
}