package com.hippoagent.fragments

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.graphics.Typeface
import android.net.ConnectivityManager
import android.net.NetworkInfo
import android.os.Bundle
import android.os.Handler
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import android.widget.Toast
import com.google.android.material.tabs.TabLayout
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.activities.FilterActivity
import com.hippoagent.datastructure.AgentType
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.datastructure.MessageMode
import com.hippoagent.eventbus.BusProvider
import com.hippoagent.eventbus.FilterEvent
import com.hippoagent.eventbus.FragmentEvent
import com.hippoagent.helper.ConversationApiHelper
import com.hippoagent.model.EditProfileResponse
import com.hippoagent.model.FilterModel
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.MultipartParams
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.Constants
import com.hippoagent.utils.UniqueIMEIID
import com.hippoagent.utils.filelogger.Logger
import com.google.gson.Gson
import com.hippoagent.database.CommonData
import com.hippoagent.eventbus.ButtonClick
import com.hippoagent.langs.Restring
import com.squareup.otto.Subscribe
import kotlinx.android.synthetic.main.fragment_web_pager.*

/**
 * Created by gurmail on 2019-12-29.
 * @author gurmail
 */
class HomePagerFragment: androidx.fragment.app.Fragment(), androidx.viewpager.widget.ViewPager.OnPageChangeListener {

    companion object {
        fun newInstance() = HomePagerFragment()
    }

    override fun onPageScrollStateChanged(position: Int) {

    }

    override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {
        var title = ""
        when (position) {
            0 -> {
                //title = "My Chats"
                filter.visibility = View.VISIBLE
                isAllChatClicked = false
                if(isMyChatFilter) {
                    filter.setImageResource(R.drawable.ic_filter)
                } else {
                    filter.setImageResource(R.drawable.ic_filter_unslected)
                }
            }
            1 -> {
                if(isAllChatEnable) {
                    filter.visibility = View.VISIBLE
                    isAllChatClicked = true
                    if (isAllChatFilter) {
                        filter.setImageResource(R.drawable.ic_filter)
                    } else {
                        filter.setImageResource(R.drawable.ic_filter_unslected)
                    }
                } else {
                    filter.visibility = View.GONE
                    isAllChatClicked = false
                }
            }
            2 -> {
                //title = "P2P Chats"
                filter.visibility = View.GONE
                isAllChatClicked = false
            }
        }
        //tvUserName2.text = title
    }

    override fun onPageSelected(position: Int) {

    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_web_pager, container, false)
    }

    var itemCount: Int = 1
    private var isAllChatClicked = false
    private var isMyChatFilter = false
    private var isAllChatFilter = false
    private var isAllChatEnable = false

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        //tvUserName2.text = "My Chats"

        tvUserName2.textSize = 20f

        try {
            try {
                if (!HippoApplication.getInstance().userData.businessProperty.hideAllChatTab() || HippoApplication.getInstance().userData.agentType == AgentType.ADMIN.getOrdinal()) {
                    itemCount += 1
                    isAllChatEnable = true
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }

            if (HippoApplication.getInstance().userData.businessProperty.p2pEnabled != null && HippoApplication.getInstance().userData.businessProperty.p2pEnabled!!.toInt() == 1) {
                itemCount += 1
            }
        } catch (e: Exception) {

        }


        ConversationApiHelper().getAgentData()

        val adapter = SavedPager(childFragmentManager)
        pagerView.adapter = adapter
        pagerView.offscreenPageLimit = itemCount
        pagerView.setPagingEnabled(true)
        pagerView.addOnPageChangeListener(this)
        tabs.setupWithViewPager(pagerView)

        filter.visibility = View.VISIBLE
        switchOnline.visibility = View.VISIBLE

        tvUserName2.text = Restring.getString(activity, R.string.support)

        if(itemCount < 2) {
            tabs.visibility = View.GONE
        }

        customBold = Typeface.createFromAsset(getActivity()?.assets, "fonts/ProximaNova-Sbold.ttf")
        customNormal = Typeface.createFromAsset(getActivity()?.assets, "fonts/ProximaNova-Reg.ttf")

//        changeTabsFont()
        setTabColor()

        ConversationApiHelper().apiGetAgents()
        status()

        ivBack?.setOnClickListener {
            BusProvider.getInstance().post(ButtonClick(1, 1))
        }

        //setFilterAdapter()
        filter.setOnClickListener {

            var selectedData = Gson().toJson(myChatFilterModel)
            if(isAllChatClicked)
                selectedData = Gson().toJson(allChatFilterModel)


            //BusProvider.getInstance().post()

            val intent = Intent(activity, FilterActivity::class.java)
            intent.putExtra("filterData", selectedData)
            intent.putExtra("isAllChat", isAllChatClicked)
            startActivityForResult(intent, 200)
        }
    }

    private fun status() {
        switchOnline.setOnCheckedChangeListener { button, flag ->
            if(button.isPressed) {
                if (isNetworkAvailable()) {
                    setAgentOnlineStatus()
                } else {
                    Toast.makeText(activity, Restring.getString(activity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
                    switchOnline.isChecked = !flag
                }
            }
        }
    }

    internal var activity: Activity? = null

    override fun onAttach(context: Context) {
        super.onAttach(context)
        if (context is Activity) {
            activity = context
        }
    }

    override fun onStart() {
        super.onStart()
        BusProvider.getInstance().register(this)
    }

    override fun onStop() {
        super.onStop()
        BusProvider.getInstance().unregister(this)
    }

    override fun onDestroy() {
        super.onDestroy()

    }

    override fun onResume() {
        super.onResume()
        checkOnlineStatus()
    }

    inner class SavedPager(private val fm: androidx.fragment.app.FragmentManager): androidx.fragment.app.FragmentStatePagerAdapter(fm) {
        override fun getItem(position: Int): androidx.fragment.app.Fragment {
            val savedFragment = HomeFragment()
            val bundle = Bundle()
            val messageMod = MessageMode.OPEN_CHAT.getOrdinal()
            if(position == 1 && !isAllChatEnable)
                bundle.putInt("position", 2)
            else
                bundle.putInt("position", position)
            bundle.putInt("selectedMode", messageMod)
            bundle.putString("param2", "")

            savedFragment.arguments = bundle
            return savedFragment
        }

        override fun getPageTitle(position: Int): CharSequence? {
            var title: String? = null
            when (position) {
                0 -> title = Restring.getString(activity, R.string.my_chats)//"My Chats"
                1 -> {
                    if (!HippoApplication.getInstance().userData.businessProperty.hideAllChatTab() || HippoApplication.getInstance().userData.agentType == AgentType.ADMIN.getOrdinal()) {
                        title = Restring.getString(activity, R.string.all_chats)//"All Chats"
                    } else {
                        title = Restring.getString(activity, R.string.p2p_chats)//"P2P Chats"
                    }
                }//
                2 -> title = Restring.getString(activity, R.string.p2p_chats)//"P2P Chats"
            }
            return title
        }

        override fun getCount(): Int {
            return itemCount
        }

    }

    private fun changeTabsFont() {
        try {
            //val font = Typeface.createFromAsset(context?.assets, "fonts/TitilliumWeb-SemiBold")
            val vg = tabs.getChildAt(0) as ViewGroup
            val tabsCount = vg.childCount
            for (j in 0 until tabsCount)
            {
                val vgTab = vg.getChildAt(j) as ViewGroup
                val tabChildsCount = vgTab.childCount
                for (i in 0 until tabChildsCount)
                {
                    val tabViewChild = vgTab.getChildAt(i)
                    if (tabViewChild is TextView)
                    {
                        (tabViewChild as TextView).typeface = customNormal
                    }
                }
            }
        } catch (e: Exception) {
        }
    }

    private var customBold: Typeface? = null
    private var customNormal:Typeface? = null


    private fun setTabColor() {
//        tabs.setSelectedTabIndicatorColor(activity?.getResources()!!.getColor(R.color.hippo_tab_indicator_color))
//        tabs.setTabTextColors(CommonData.getColorConfig().getHippoTabTextColor(),
//                CommonData.getColorConfig().getHippoTabSelectedTextColor())

        tabs.setSelectedTabIndicatorColor(CommonData.getColorConfig().getHippoSelectedTabIndicatorColor())
        tabs.setTabTextColors(CommonData.getColorConfig().getHippoTabTextColor(),
                CommonData.getColorConfig().getHippoTabSelectedTextColor())

        tabs.addOnTabSelectedListener(object : TabLayout.OnTabSelectedListener {
            override fun onTabSelected(tab: TabLayout.Tab) {
                val tabLayout1 = (tabs.getChildAt(0) as ViewGroup).getChildAt(tab.position) as LinearLayout
                val tabTextView = tabLayout1.getChildAt(1) as TextView
                tabTextView.typeface = customBold
                tabTextView.textSize = 16f
            }

            override fun onTabUnselected(tab: TabLayout.Tab) {
                val tabLayout1 = (tabs.getChildAt(0) as ViewGroup).getChildAt(tab.position) as LinearLayout
                val tabTextView = tabLayout1.getChildAt(1) as TextView
                tabTextView.typeface = customNormal
                tabTextView.textSize = 16f
            }

            override fun onTabReselected(tab: TabLayout.Tab) {
                val tabLayout1 = (tabs.getChildAt(0) as ViewGroup).getChildAt(tab.position) as LinearLayout
                val tabTextView = tabLayout1.getChildAt(1) as TextView
                tabTextView.typeface = customBold
                tabTextView.textSize = 16f
            }
        })


        if(itemCount>2) {
            val tabLayout1 = (tabs.getChildAt(0) as ViewGroup).getChildAt(2) as LinearLayout
            val tabTextView = tabLayout1.getChildAt(1) as TextView
            tabTextView.typeface = customNormal
            tabTextView.textSize = 16f
        }
        if(itemCount>1) {
            val tabLayout1 = (tabs.getChildAt(0) as ViewGroup).getChildAt(1) as LinearLayout
            val tabTextView = tabLayout1.getChildAt(1) as TextView
            tabTextView.typeface = customNormal
            tabTextView.textSize = 16f
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (resultCode == Activity.RESULT_OK) {
            when (requestCode) {
                200 -> {
                    val filterType: Int = if(isAllChatClicked) 1 else 0
                    Handler().postDelayed(Runnable {
                        BusProvider.getInstance().post(FilterEvent(filterType, data))
                    }, 50)


                    if(isAllChatClicked)
                        allChatFilterModel = Gson().fromJson(data!!.getStringExtra("filterData"), FilterModel::class.java)
                    else
                        myChatFilterModel = Gson().fromJson(data!!.getStringExtra("filterData"), FilterModel::class.java)

                }
                else -> {
                }
            }
        }
    }

    private var myChatFilterModel: FilterModel? = null
    private var allChatFilterModel: FilterModel? = null


    private fun isNetworkAvailable(): Boolean {
        val cm = activity!!.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        var networkInfo: NetworkInfo? = null
        if (cm != null) {
            networkInfo = cm.activeNetworkInfo
        }
        return networkInfo != null && networkInfo.isConnected
    }

    @Subscribe
    fun onFragmentEvent(fragmentEvent: FragmentEvent) {
        if (fragmentEvent.fragmentType != 1)
            return
        when (fragmentEvent.dataType) {
            1 -> {
                checkOnlineStatus()
                val flag = fragmentEvent.`object` as Boolean
                if (flag) {
                    // Available

                } else {
                    // Away

                }
            }
            2 -> {
                myChatFilterModel = fragmentEvent.`object` as FilterModel?
            }
            3 -> {
                allChatFilterModel = fragmentEvent.`object` as FilterModel?
            }
            4 -> {
                isMyChatFilter = fragmentEvent.`object` as Boolean
                if(!isAllChatClicked && isMyChatFilter) {
                    filter.setImageResource(R.drawable.ic_filter)
                } else {
                    filter.setImageResource(R.drawable.ic_filter_unslected)
                }
            }
            5 -> {
                isAllChatFilter = fragmentEvent.`object` as Boolean
                if(isAllChatClicked && isAllChatFilter) {
                    filter.setImageResource(R.drawable.ic_filter)
                } else {
                    filter.setImageResource(R.drawable.ic_filter_unslected)
                }
            }
            else -> {
            }
        }
    }

    private fun checkOnlineStatus() {
        try {
            switchOnline.updateStatus(HippoApplication.getInstance().userData.onlineStatus == FuguAppConstant.AVAILABLE)
        } catch (e: Exception) {
            e.printStackTrace()
            getActivity()!!.runOnUiThread {
                switchOnline.updateStatus(HippoApplication.getInstance().userData.onlineStatus == FuguAppConstant.AVAILABLE)
            }
        }

    }

    private fun setAgentOnlineStatus() {
        val multipartBuilder = MultipartParams.Builder()
        val multipartParams: MultipartParams
        multipartParams = multipartBuilder
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                .add(Constants.EN_USER_ID, HippoApplication.getInstance().userData.enUserId)
                .add(Constants.AGENT_TYPE, HippoApplication.getInstance().userData.agentType.toString())
                .add(Constants.BUSINESS_ID, HippoApplication.getInstance().userData.businessId.toString())
                .add(Constants.DEVICE_TYPE, Constants.ANDROID)
                .add("device_id", UniqueIMEIID.getUniqueIMEIId(activity))
                .add(Constants.ONLINE_STATUS, if (switchOnline.isChecked) FuguAppConstant.AVAILABLE else FuguAppConstant.AWAY).build()

        val value = Gson().toJson(multipartParams.map)
        Logger.apiRequest("/api/agent/editInfo", value)

        RestClient.getApiInterface().editAgentInfo(multipartParams.map)
                .enqueue(object : ResponseResolver<EditProfileResponse>(activity, false, true) {
                    override fun success(editProfileResponse: EditProfileResponse) {
                        Logger.apiResponse("/api/agent/editInfo", "")
                        try {
                            if (switchOnline.isChecked) {
                                HippoApplication.getInstance().userData.onlineStatus = FuguAppConstant.AVAILABLE
                                //HippoApplication.getInstance().trackEvent(GAEvents.HOME_SCREEN, GAEvents.STATUS_CLICKED, "status_available_home")
                                HippoApplication.getInstance().userData.onlineStatus = FuguAppConstant.AVAILABLE
                                BusProvider.getInstance().post(FragmentEvent(2, 1, true))
                            } else {
                                HippoApplication.getInstance().userData.onlineStatus = FuguAppConstant.AWAY
                                BusProvider.getInstance().post(FragmentEvent(2, 1, false))
                            }
                        } catch (e: Exception) {
                        }
                    }

                    override fun failure(error: APIError) {
                        Logger.apiFailed("/api/agent/editInfo", error.message)
                        Toast.makeText(activity, error.message, Toast.LENGTH_SHORT).show()
                        checkOnlineStatus()
                    }

                })
    }
}