package com.hippoagent.fragments

import android.app.Dialog
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.graphics.Color
import android.net.ConnectivityManager
import android.net.Uri
import android.os.Bundle
import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.widget.*
import com.facebook.react.bridge.UiThreadUtil
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.activities.*
import com.hippoagent.adapters.*
import com.hippoagent.callback.OnAgentParseCallback
import com.hippoagent.database.CommonData
import com.hippoagent.dialogs.DialogPop
import com.hippoagent.helper.ParseAgents
import com.hippoagent.model.*
import com.hippoagent.model.LoginResponse.Tag
import com.hippoagent.model.assigne_tag.AssignTagResponse
import com.hippoagent.model.create_tag.CreateTagResponse
import com.hippoagent.model.gettags.GetTagsResponse
import com.hippoagent.model.user_details.*
import com.hippoagent.retrofit.*
import com.hippoagent.utils.*
import com.hippoagent.utils.Constants.TAGS_DATA
import com.hippoagent.utils.filelogger.Logger
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.hippoagent.HippoConfig
import com.hippoagent.datastructure.*
import com.hippoagent.helper.ConversationApiHelper
import com.hippoagent.langs.Restring
import com.hippoagent.utils.loadingBox.LoadingBox
import io.paperdb.Paper
import kotlinx.android.synthetic.main.dialog_show_agents.*
import kotlinx.android.synthetic.main.fragment_chat_options.*
import org.json.JSONObject
import java.util.ArrayList

/**
 * Created by gurmail on 17/05/19.
 * @author gurmail
 */
class ChatOptionFragment : androidx.fragment.app.Fragment(), ConversationApiHelper.ConversationHelperListener {

    override fun onDataSuccess() {
        try {
            getActivity()?.runOnUiThread(Runnable {
                dialogShowAgents(Paper.book(CommonData.name).read<Any>(SPLabels.AGENTS) as GetAgentsResponse)
            })
        } catch (e: Exception) {
        }
    }

    private val TAG = ChatOptionFragment::class.java.simpleName

    val RECIEVER_MSG_AGENT_REFRESH = "com.fugu.agent.refresh.msg"
    private var getAgentData: GetAgentData? = null
    private var conversation: Conversation? = null
    private var status: Int = 0
    private var tagData: ArrayList<TagData> = ArrayList()
    var tagList = ArrayList<String>()
    private val colors: IntArray? = null
    private val colorList = ArrayList<IntArray>()
    var colorsTag: MutableList<IntArray> = ArrayList()
    internal var dialogTag: Dialog? = null
    internal var dialogAddTags:Dialog? = null
    internal var filteredTagData: ArrayList<Tag> = ArrayList()
    internal var showTagsAdapter: ShowTagsAdapter? = null
    internal var selectedTagColor: String? = null
    internal var isUseTag: Boolean = false
    private var visitorInfo: ArrayList<CustomAttributeList>? = null
    private var dealId: String? = null
    private var migrateUser: MigrateData? = null
    private var hasHistoryEnabled: Boolean = false
    private var hasBotRunning: Boolean = false
    private var directOpen: Boolean = false

    private var activity : ChannelInfoActivity? = null
    var journeyType = object : TypeToken<List<CJourney>>() {

    }.type
    //private var botEnded: BotEnded? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if(arguments != null) {
            conversation = Gson().fromJson<Conversation>(arguments?.getString(Constants.CONVERSATION), Conversation::class.java)
            if(arguments!!.containsKey(TAGS_DATA))
                tagData = arguments?.getParcelableArrayList(TAGS_DATA)!!
            if(arguments!!.containsKey("deal_id"))
                dealId = arguments?.getString("deal_id")
            if(arguments!!.containsKey("btnHistory"))
                hasHistoryEnabled = arguments?.getBoolean("btnHistory", false)!!
            if(arguments!!.containsKey("hasBotRunning"))
                hasBotRunning = arguments?.getBoolean("hasBotRunning", false)!!
            if(arguments!!.containsKey("directOpen"))
                directOpen = arguments?.getBoolean("directOpen", false)!!
        }
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_chat_options, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        if (conversation?.getStatus() != null)
            status = if (conversation?.getStatus() == MessageMode.OPEN_CHAT.getOrdinal()) MessageMode.CLOSED_CHAT.getOrdinal() else MessageMode.OPEN_CHAT.getOrdinal()

        try {
            if (conversation?.getChatType()!!) {
                ll_top_view.setVisibility(View.GONE)
            }
        } catch (e: Exception) {
        }

        tvActions?.text = Restring.getString(activity, R.string.actions)
        tvChannelInfo?.text = Restring.getString(activity, R.string.channel_info)
        tvChannelJourney?.text = Restring.getString(activity, R.string.channel_journey)
        tvAddLabel?.text = Restring.getString(activity, R.string.add_label)
        tvUserInfo?.text = Restring.getString(activity, R.string.user_info)
        tvEditProfile?.text = Restring.getString(activity, R.string.edit_profile)
        tvCustomAttributes?.text = Restring.getString(activity, R.string.custom_attributes)
        tvCustomAttributes?.text = Restring.getString(activity, R.string.visitor_info)

        setAgentData()
        setTags()

        getUserData()

        try {
            if(directOpen) {
                val getAgentsResponse: GetAgentsResponse = Paper.book(CommonData.name).read<Any>(SPLabels.AGENTS, GetAgentsResponse()) as GetAgentsResponse
                if(getAgentsResponse == null || getAgentsResponse.data == null || getAgentsResponse.data.agents == null) {
                    ConversationApiHelper(ConversationApiHelper.HelperListener {
                        getActivity()?.runOnUiThread(Runnable {
                            setAgentData()
                        })
                    }).apiGetAgents()
                }
            }
        } catch (e: Exception) {
        }

        if(hasBotRunning) {
            tvAssignConversation.visibility = View.GONE
        }

        if (conversation?.getStatus() == MessageMode.OPEN_CHAT.getOrdinal()) {
            tvCloseConversation.text = Restring.getString(activity, R.string.close_conversation)
        } else {
            tvCloseConversation.text = Restring.getString(activity, R.string.reopen_conversation)
        }
        tvCloseConversation.setOnClickListener {
            if (conversation?.getStatus() == MessageMode.OPEN_CHAT.getOrdinal()
                    && HippoApplication.getInstance().userData.businessProperty.isClosingReasonEnabled
                    && !TextUtils.isEmpty(dealId)
                    && HippoApplication.getInstance().userData.businessProperty.crmIntegrationType!!.toInt() == 1) {
                performMarkConversationWithMessage()
            } else {
                performMarkConversation()
            }
        }
        tvAssignConversation.setOnClickListener {
            val getAgentsResponse: GetAgentsResponse = Paper.book(CommonData.name).read<Any>(SPLabels.AGENTS, GetAgentsResponse()) as GetAgentsResponse
            if(getAgentsResponse == null || getAgentsResponse.data == null || getAgentsResponse.data.agents == null) {
                LoadingBox.showOn(getActivity())
                ConversationApiHelper(this).apiGetAgents()
            } else {
                dialogShowAgents(Paper.book(CommonData.name).read<Any>(SPLabels.AGENTS) as GetAgentsResponse)
            }
        }

        show_more_view.setOnClickListener {
            if (infoAdapter != null) {
                if (show_more_view.getText().toString().equals(Restring.getString(activity, R.string.show_more), ignoreCase = true)) {
                    show_more_view.setText(Restring.getString(activity, R.string.show_less))
                    infoAdapter?.showData(false)
                    scrollView.post { scrollView.fullScroll(ScrollView.FOCUS_DOWN) }

                } else {
                    show_more_view.setText(Restring.getString(activity, R.string.show_more))
                    infoAdapter?.showData(true)
                }
            }
        }
        etCustomerPhone.setOnClickListener {
            goToPhone(etCustomerPhone.getText().toString())
        }
        etCustomerEmail.setOnClickListener {
            goToGmail(etCustomerEmail.getText().toString())
        }


        try {
            if(HippoApplication.getInstance().userData.businessProperty.isChannelJourneyEnabled()) {
                rlJourney.visibility = View.VISIBLE
            } else {
                rlJourney.visibility = View.GONE
            }
        } catch (e: Exception) {
            rlJourney.visibility = View.GONE
        }

        tvChannelJourney.setOnClickListener {
            val intent = Intent(getActivity(), ChannelJourney::class.java)
            var data = Gson().toJson(cJourneyList)
            intent.putExtra("cJourneyList", data)
            startActivity(intent)
        }
//        rlJourney.setOnClickListener {
//            //activity?.startActivity(Intent(activity?, ChannelJourney::class.java))
//            val intent = Intent(getActivity(), ChannelJourney::class.java)
//            var data = Gson().toJson(cJourneyList)
//            intent.putExtra("cJourneyList", data)
//            startActivity(intent)
//        }

        if (conversation?.getAgentId()?.toInt()!! > 0) {
            tvAssignConversation.text = Restring.getString(activity, R.string.reassign_conversation)
        } else {
            tvAssignConversation.text = Restring.getString(activity, R.string.assign_conversation)
        }
        migrateUser = MigrateData()
        activity?.registerReceiver(migrateUser, IntentFilter(FuguChatActivity.MIGRATE_USER))

        addTags.setOnClickListener { getTags() }


        getAgentData = GetAgentData()
        activity?.registerReceiver(getAgentData, IntentFilter(RECIEVER_MSG_AGENT_REFRESH))

//        botEnded = BotEnded()
//        activity?.registerReceiver(botEnded, IntentFilter(FuguChatActivity.RECIEVER_BOT_ENDED))
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        activity = context as ChannelInfoActivity
    }

    override fun onDestroyView() {
        super.onDestroyView()
        if (getAgentData != null)
            activity?.unregisterReceiver(getAgentData)
        activity?.unregisterReceiver(migrateUser)
        //activity?.unregisterReceiver(botEnded)
    }

    override fun onHiddenChanged(hidden: Boolean) {
        super.onHiddenChanged(hidden)
        if(!hidden) {
            //scrollView.
        }
    }

    override fun onResume() {
        super.onResume()
    }

    override fun onDestroy() {
        super.onDestroy()
    }

    override fun onPause() {
        super.onPause()
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)

    }

    fun setTags() {
        try {
            if (tagData.isEmpty()) {
                tvAddLabel.visibility = View.VISIBLE
                tagLayout.visibility = View.GONE
            } else {
                tvAddLabel.visibility = View.GONE
                tagLayout.visibility = View.VISIBLE
            }
            tagLayout.removeAllTags()
            for (i in tagData.indices) {
                Log.v("tag----->>>>>>--->>>>>>>", ":" + tagData.get(i).color_code.trim { it <= ' ' }.toLowerCase() + ":")
                tagList.add(tagData.get(i).tag_name)
                val col1 = intArrayOf(Color.parseColor(tagData.get(i).color_code.toLowerCase()), Color.parseColor(tagData.get(i).color_code.toLowerCase()), Color.parseColor("#ffffff"), Color.parseColor(tagData.get(i).color_code.toLowerCase()))
                colorsTag.add(col1)
            }

            Log.v("colorList----->>>>>>--->>>>>>>", ":" + tagData.size + "--" + colorsTag.toString() + ":")
            //tagLayout.setBackgroundResource(Color.RED)
            tagLayout.tags = tagList
            tagLayout.setTags(tagList, colorsTag)
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    private fun performMarkConversation() {
        val message = if (status == MessageMode.OPEN_CHAT.getOrdinal()) Restring.getString(activity, R.string.reopen_chat_message) else Restring.getString(activity, R.string.close_chat_message)
        val positive = if (status == MessageMode.OPEN_CHAT.getOrdinal()) Restring.getString(activity, R.string.reopen_caps) else Restring.getString(activity, R.string.close)
        val dialogPop = DialogPop()
        dialogPop.alertPopupWithTwoButton(activity, "", message, positive, Restring.getString(activity, R.string.cancel), object : DialogPop.Callback {
            override fun onPositiveClick() {
                apiMarkConversation()
            }

            override fun onNegativeClick() {}
        })
    }

    private fun performMarkConversationWithMessage() {

        val title = Restring.getString(activity, R.string.hippo_close_conversation)
        val message = Restring.getString(activity, R.string.hippo_closing_notes)
        val positive = if (status == MessageMode.OPEN_CHAT.getOrdinal()) Restring.getString(activity, R.string.reopen_caps) else Restring.getString(activity, R.string.close)
        val dialogPop = DialogPop()
        dialogPop.alertPopupWithEditText(activity, title, message, positive, Restring.getString(activity, R.string.cancel), object : DialogPop.CallbackListener {
            override fun onPositiveClick(notes: String) {
                apiMarkConversation(notes)
            }

            override fun onNegativeClick() {}
        })


    }

    private fun apiMarkConversation() {
        apiMarkConversation("")
    }

    private fun apiMarkConversation(notes: String) {
        if (isNetworkAvailable()) {
            val builder = CommonParams.Builder()
            builder.add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
            builder.add(Constants.CHANNEL_ID, conversation?.getChannelId().toString())
            builder.add(Constants.EN_USER_ID, HippoApplication.getInstance().userData.enUserId)
            builder.add(Constants.STATUS, status.toString())
            builder.add(Constants.CREATED_BY, HippoApplication.getInstance().userData.fullName)
            if (!TextUtils.isEmpty(notes)) {
                builder.add(Constants.CLOSING_NOTES, notes)
            }
            if (!TextUtils.isEmpty(dealId)) {
                try {
                    if (HippoApplication.getInstance().userData.businessProperty.crmIntegrationType!!.toInt() == 1)
                        builder.add(Constants.DEAL_ID, dealId)
                } catch (e: Exception) {

                }

            }

            val commonParams = builder.build()
            Logger.apiRequest("/api/conversation/markConversation", Gson().toJson(commonParams.map))
            RestClient.getApiInterface().markConversation(commonParams.map)
                    .enqueue(object : ResponseResolver<GetConversationResponse>(activity, true, true) {
                        override fun success(loginResponse: GetConversationResponse) {
                            Logger.apiResponse("/api/conversation/markConversation", "")
                            try {
                                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.statusCode) {
                                    val conData = Bundle()
                                    conData.putString(Constants.CHANNEL_ID, conversation?.getChannelId().toString())
                                    val intent = Intent()
                                    intent.putExtras(conData)
                                    if (conversation?.getStatus() == MessageMode.OPEN_CHAT.getOrdinal()) {
                                        activity?.setResult(MessageMode.CLOSED_CHAT.getOrdinal(), intent)
                                    } else {
                                        activity?.setResult(MessageMode.OPEN_CHAT.getOrdinal(), intent)
                                    }
                                    activity?.onBackPressed()
                                }
                            } catch (e: Exception) {
                                Logger.apiFailed("/api/conversation/markConversation", e.localizedMessage)
                                e.printStackTrace()
                            }

                        }

                        override fun failure(error: APIError) {
                            Logger.apiFailed("/api/conversation/markConversation", error.message)
                            Log.e("error", "error")
                        }
                    })
        } else {
            Toast.makeText(activity, Restring.getString(activity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }

    private fun apiAssignAgent(userId: Int) {
        if (isNetworkAvailable()) {
            val commonParams = CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                    .add(Constants.CHANNEL_ID, conversation?.getChannelId().toString())
                    .add(Constants.USER_ID, userId.toString())
                    .build()

            Logger.apiRequest("/api/agent/assignAgent", Gson().toJson(commonParams.map))
            RestClient.getApiInterface().assignAgent(commonParams.map)
                    .enqueue(object : ResponseResolver<GetConversationResponse>(activity, true, true) {
                        override fun success(loginResponse: GetConversationResponse) {
                            Logger.apiResponse("/api/agent/assignAgent", "")
                            try {
                                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.statusCode) {
                                    val conData = Bundle()
                                    conData.putString(Constants.CHANNEL_ID, conversation?.getChannelId().toString())
                                    val intent = Intent()
                                    intent.putExtras(conData)
                                    activity?.setResult(Overlay.ASSIGNMENT.getOrdinal(), intent)
                                    activity?.onBackPressed()
                                }
                            } catch (e: Exception) {
                                e.printStackTrace()
                                Logger.apiFailed("/api/agent/assignAgent", e.localizedMessage)
                            }

                        }

                        override fun failure(error: APIError) {
                            Logger.apiFailed("/api/agent/assignAgent", error.message)
                            Log.e("error", "error")
                        }
                    })
        } else {
            Toast.makeText(activity, Restring.getString(activity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }

    private fun dialogShowAgents(getAgentsResponse: GetAgentsResponse) {
        val dialog = Dialog(activity, android.R.style.Theme_Translucent_NoTitleBar)
        dialog.window!!.attributes.windowAnimations = R.style.Animations_LoadingDialogBottomIn
        dialog.setContentView(R.layout.dialog_show_agents)
        val layoutParams = dialog.window!!.attributes
        layoutParams.dimAmount = 0.6f
        dialog.window!!.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)
        val showAgentsAdapter: ShowAgentsAdapter
        val llsearch = dialog.findViewById<View>(R.id.llsearch) as LinearLayout
        llsearch.visibility = View.VISIBLE
        val tvTitle = dialog.findViewById<View>(R.id.tvTitle) as TextView
        val tvSavedData = dialog.findViewById<View>(R.id.tvSavedData) as TextView
        val ivClose = dialog.findViewById<View>(R.id.ivClose) as ImageView
        val rvAgents = dialog.findViewById<View>(R.id.rvAgents) as androidx.recyclerview.widget.RecyclerView
        val etSearch = dialog.findViewById<View>(R.id.etSearch) as EditText
        val noData = dialog.findViewById<View>(R.id.no_data_found) as TextView
        rvAgents.layoutManager = androidx.recyclerview.widget.LinearLayoutManager(activity)
        rvAgents.itemAnimator = androidx.recyclerview.widget.DefaultItemAnimator()
        rvAgents.setHasFixedSize(false)

        tvTitle.text = Restring.getString(activity, R.string.assign_conversation)
        noData.text = Restring.getString(activity, R.string.no_data_found)
        tvSavedData.text = Restring.getString(activity, R.string.hippo_no_saved_data_found)
        etSearch.hint = Restring.getString(activity, R.string.Search)


        val agentsList = ArrayList<GetAgentsResponse.Agents>()
        var tempAgentsList = ArrayList<GetAgentsResponse.Agents>()

        if (HippoApplication.getInstance().agentsResponse != null) {
            for (agent in getAgentsResponse.data.agents) {
                if (agent.status == 1) {
                    agentsList.add(agent)
                }
                if (conversation?.getAgentId() == HippoApplication.getInstance().userData.userId && agent.userId == HippoApplication.getInstance().userData.userId) {
                    agentsList.remove(agent)
                }

            }
        }

        tempAgentsList.addAll(agentsList)
        showAgentsAdapter = ShowAgentsAdapter(activity, agentsList, object : Callback {
            override fun onClick(position: Int, agent: GetAgentsResponse.Agents) {
                performAgentClick(agent, dialog)
            }
        })
        rvAgents.adapter = showAgentsAdapter

        var mSearchNetworkQueryHelper: SearchViewNetworkQueryHelper = SearchViewNetworkQueryHelper(etSearch, object: SearchViewNetworkQueryHelper.SearchCallbacks {
            override fun showLoader() {

            }

            override fun performQuery(query: String?) {
                tempAgentsList.clear()

                for (filter in agentsList) {
                    if (filter.fullName.toLowerCase().contains(query.toString(), true)) {
                        tempAgentsList.add(filter)
                    }
                }
                showAgentsAdapter.setData(tempAgentsList)
                if(tempAgentsList.size<1) {
                    noData.visibility = View.VISIBLE
                    rvAgents.visibility = View.GONE
                } else {
                    noData.visibility = View.GONE
                    rvAgents.visibility = View.VISIBLE
                }
            }

            override fun showAllData() {
                showAgentsAdapter.setData(agentsList)
                noData.visibility = View.GONE
                rvAgents.visibility = View.VISIBLE
            }

        })

        mSearchNetworkQueryHelper.suggestCountThreshold = 2
        mSearchNetworkQueryHelper.suggestWaitThreshold = 100

        ivClose.setOnClickListener { dialog.dismiss() }
        dialog.show()
    }

    private fun dialogShowTags(tagData: List<Tag>, selectedTagData: List<Tag>) {
        dialogTag = Dialog(activity, android.R.style.Theme_Translucent_NoTitleBar)
        dialogTag!!.getWindow()!!.attributes.windowAnimations = R.style.Animations_LoadingDialogBottomIn
        dialogTag!!.getWindow()!!.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN)
        dialogTag!!.setContentView(R.layout.dialog_show_tags)
        val layoutParams = dialogTag!!.getWindow()!!.attributes
        layoutParams.dimAmount = 0.6f
        dialogTag!!.getWindow()!!.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)

        var selectedTag = ArrayList<Tag>()
        for(tags in selectedTagData) {
            selectedTag.add(tags)
        }

        val tvTitle = dialogTag!!.findViewById<View>(R.id.tvTitle) as TextView
        tvTitle.text = Restring.getString(activity, R.string.add_label)

        val rvLabels = dialogTag!!.findViewById<View>(R.id.rvLabels) as androidx.recyclerview.widget.RecyclerView
        rvLabels.layoutManager = androidx.recyclerview.widget.LinearLayoutManager(activity)
        rvLabels.itemAnimator = androidx.recyclerview.widget.DefaultItemAnimator()
        rvLabels.setHasFixedSize(false)
        val etSearchLabel = dialogTag!!.findViewById<View>(R.id.etSearchLabel) as EditText
        etSearchLabel.hint = Restring.getString(activity, R.string.search_here)

        etSearchLabel.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(charSequence: CharSequence, i: Int, i1: Int, i2: Int) {

            }

            override fun onTextChanged(charSequence: CharSequence, i: Int, i1: Int, i2: Int) {

            }

            override fun afterTextChanged(editable: Editable) {
                filteredTagData = ArrayList()
                for (i in tagData.indices) {
                    if (tagData[i].tagName.toLowerCase().contains(editable.toString().toLowerCase())) {
                        val tags = Tag()
                        tags.colorCode = tagData[i].colorCode
                        tags.status = tagData[i].status
                        tags.tagId = tagData[i].tagId
                        tags.tagName = tagData[i].tagName
                        filteredTagData.add(tags)
                    }
                }
                showTagsAdapter = ShowTagsAdapter(filteredTagData, object : ShowTagsAdapter.ShowTagsListener {
                    override fun onAssignTags(tags: Tag?, i: Int) {
                        tags?.let {
                            val index = selectedTag.indexOf(tags)
                            if(index == -1)
                                selectedTag.add(it)
                            else {
                                selectedTag[index] = tags
                            }
                        }
                    }

                })

                rvLabels.adapter = showTagsAdapter
            }
        })
        val btAdd = dialogTag!!.findViewById<View>(R.id.btAdd) as Button
        val btCancelLabel = dialogTag!!.findViewById<View>(R.id.btCancelLabel) as Button
        val ibAddLabels = dialogTag!!.findViewById<View>(R.id.ibAddLabels) as ImageButton
        val ivAddLabel = dialogTag!!.findViewById<View>(R.id.ivAddLabel) as ImageView

        btAdd.text = Restring.getString(activity, R.string.done)
        btCancelLabel.text = Restring.getString(activity, R.string.cancel)

        val tagsList = ArrayList<Tag>()
        if (HippoApplication.getInstance().agentsResponse != null) {
            for (tags in tagData) {
                tagsList.add(tags)
            }
        }


        showTagsAdapter = ShowTagsAdapter(tagsList, object : ShowTagsAdapter.ShowTagsListener {
            override fun onAssignTags(tags: Tag?, i: Int) {
                //tags?.let { assignTags(it, i) }

                tags?.let {
                    val index = selectedTag.indexOf(tags)
                    if(index == -1)
                        selectedTag.add(it)
                    else {
                        selectedTag[index] = tags
                    }
                }
                //Log.e("TAG", "Old tags: "+Gson().toJson(selectedTagData))
            }

        })
        rvLabels.adapter = showTagsAdapter
        ivAddLabel.setOnClickListener {
            selectedTagColor = null
            dialogShowAddTags()
        }
        btCancelLabel.setOnClickListener { dialogTag!!.dismiss() }
        btAdd.setOnClickListener {

            for(tag in selectedTagData) {
                val index = selectedTag.indexOf(tag)
                if((index != -1 && tag.status != 0 && tag.status == selectedTag.get(index).status)) {
                    selectedTag.removeAt(index)
                }
            }
            val ids = ArrayList<Int>()
            selectedTag.forEach {
                val index = selectedTagData.indexOf(it)
                if(index == -1 && it.status == 0) {
                    ids.add(it.tagId)
                }
            }
            for(id in ids) {
                val index = selectedTag.indexOf(Tag(id))
                if(index != -1)
                    selectedTag.removeAt(index)
            }
            if(selectedTag.isEmpty()) {
                dialogTag!!.dismiss()
            } else {
                assignTag(selectedTag)
            }

        }
        dialogTag!!.show()
    }

    private fun updateTags(selectedTagData: List<Tag>) {
        try {
            for(tag in selectedTagData) {
                if (tag.status == 0) {
                    val index = tagData.indexOf(TagData(tag.tagId.toString()))
                    if (index != -1)
                        tagData.removeAt(index)
                } else {
                    val tags = TagData()
                    tags.color_code = tag.colorCode
                    tags.is_enabled = tag.status.toString()
                    tags.tag_id = tag.tagId.toString()
                    tags.tag_name = tag.tagName
                    tagData.add(tags)
                }
            }
            tagList.clear()
            colorsTag.clear()
            setTags()
            dialogTag?.dismiss()
        } catch (e: Exception) {
        }
    }

    private fun assignTag(selectedTag: ArrayList<Tag>) {
        if (isNetworkAvailable()) {

            val data : TagsToChannel = TagsToChannel(HippoApplication.getInstance().userData.accessToken,
                    conversation?.getChannelId()!!, selectedTag, HippoConfig.getInstance().currentLanguage)

            Logger.apiRequest("/api/tags/v2/assignTagsToChannel", Gson().toJson(data))
            RestClient.getApiInterface().updateTagsToChannel(data)
                    .enqueue(object : ResponseResolver<CommonResponse>(activity, true, true) {
                        override fun success(assignTagResponse: CommonResponse) {
                            Logger.apiResponse("/api/tags/v2/assignTagsToChannel", "")
                            updateTags(selectedTag)

                        }

                        override fun failure(error: APIError) {
                            Logger.apiFailed("/tags/v2/assignTagsToChannel", error.message)
                            Log.e("error", "error")
                        }
                    })
        } else {
            Toast.makeText(activity, Restring.getString(activity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }

    private fun dialogShowAddTags() {
        dialogAddTags = Dialog(activity, android.R.style.Theme_Translucent_NoTitleBar)
        dialogAddTags!!.getWindow()!!.attributes.windowAnimations = R.style.Animations_LoadingDialogBottomIn
        dialogAddTags!!.getWindow()!!.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN)
        dialogAddTags!!.setContentView(R.layout.dialog_add_tags)
        val layoutParams = dialogAddTags!!.getWindow()!!.attributes
        layoutParams.dimAmount = 0.6f
        dialogAddTags!!.getWindow()!!.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)
        val addTagsAdapter: AddTagsAdapter

        val colors = ArrayList<Colors>()
        for (i in 0..11) {
            val color = Colors()
            color.isColorSelected = 0
            if (i == 0)
                color.color = "#61BD4F"
            if (i == 1)
                color.color = "#F2D600"
            if (i == 2)
                color.color = "#FFAB4A"
            if (i == 3)
                color.color = "#EB5A46"
            if (i == 4)
                color.color = "#C377E0"
            if (i == 5)
                color.color = "#0079BF"
            if (i == 6)
                color.color = "#00C2E0"
            if (i == 7)
                color.color = "#51E898"
            if (i == 8)
                color.color = "#FF80CE"
            if (i == 9)
                color.color = "#4d4d4d"
            if (i == 10)
                color.color = "#B6BBBF"
            if (i == 11)
                color.color = "#b04632"
            colors.add(color)
        }

        val etLabelName = dialogAddTags!!.findViewById<View>(R.id.etLabelName) as EditText
        val btAddLabel = dialogAddTags!!.findViewById<View>(R.id.btAddLabel) as Button
        val btUseLabel = dialogAddTags!!.findViewById<View>(R.id.btUseLabel) as Button
        val ivClose = dialogAddTags!!.findViewById<View>(R.id.ivClose) as ImageView
        val tvTitle = dialogAddTags!!.findViewById<View>(R.id.tvTitle) as TextView

        tvTitle.text = Restring.getString(activity, R.string.create_label)
        btAddLabel.text = Restring.getString(activity, R.string.add_deal)
        btUseLabel.text = Restring.getString(activity, R.string.use_label)
        tvTitle.text = Restring.getString(activity, R.string.use_label)
        etLabelName.hint = Restring.getString(activity, R.string.label_name)


        val rvLabelColors = dialogAddTags!!.findViewById<View>(R.id.rvLabelColors) as androidx.recyclerview.widget.RecyclerView
        val numberOfColumns = 5
        rvLabelColors.layoutManager = androidx.recyclerview.widget.GridLayoutManager(activity, numberOfColumns)
        rvLabelColors.itemAnimator = androidx.recyclerview.widget.DefaultItemAnimator()
        rvLabelColors.setHasFixedSize(false)

        val tagsList = ArrayList<Tag>()
        addTagsAdapter = AddTagsAdapter(colors, object : AddTagsAdapter.AddTagsClick {
            override fun onClickListener(color: String?) {
                selectedTagColor = color
            }
        })
        rvLabelColors.adapter = addTagsAdapter

        ivClose.setOnClickListener { dialogAddTags!!.dismiss() }
        btAddLabel.setOnClickListener(View.OnClickListener {
            isUseTag = false
            if (etLabelName.text.toString().isEmpty()) {
                Toast.makeText(activity, Restring.getString(activity, R.string.enter_label_name), Toast.LENGTH_SHORT).show()
                return@OnClickListener
            }
            if (selectedTagColor == null || selectedTagColor!!.isEmpty()) {
                Toast.makeText(activity, Restring.getString(activity, R.string.select_label_color), Toast.LENGTH_SHORT).show()
                return@OnClickListener
            }
            createTag(etLabelName.text.toString(), selectedTagColor!!)
        })
        btUseLabel.setOnClickListener(View.OnClickListener {
            isUseTag = true
            if (etLabelName.text.toString().isEmpty()) {
                Toast.makeText(activity, Restring.getString(activity, R.string.enter_label_name), Toast.LENGTH_SHORT).show()
                return@OnClickListener
            }
            if (selectedTagColor == null || selectedTagColor!!.isEmpty()) {
                Toast.makeText(activity, Restring.getString(activity, R.string.select_label_color), Toast.LENGTH_SHORT).show()
                return@OnClickListener
            }
            createTag(etLabelName.text.toString(), selectedTagColor!!)
        })
        dialogAddTags!!.show()
    }

    private fun performAgentClick(agent: GetAgentsResponse.Agents, dialog: Dialog) {
        val dialogPop = DialogPop()
        dialogPop.alertPopupWithTwoButton(activity, "", Restring.getString(activity, R.string.assign_agent_message),
                Restring.getString(activity, R.string.confirm), Restring.getString(activity, R.string.cancel), object : DialogPop.Callback {
            override fun onPositiveClick() {
                apiAssignAgent(agent.userId)
                dialog.dismiss()
            }

            override fun onNegativeClick() {}
        })
    }

    interface Callback {
        fun onClick(position: Int, agent: GetAgentsResponse.Agents)
    }

    private fun getUserData() {
        if (isNetworkAvailable()) {
            val commonParams = CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                    .add(Constants.USER_ID, conversation?.getUserId())
                    .add(Constants.CHANNEL_ID, conversation?.channelId)
                    .build()
            Logger.apiRequest("api/users/getUserDetails", Gson().toJson(commonParams.map))

            RestClient.getApiInterface().getUserDetails(commonParams.map)
                    .enqueue(object : ResponseResolver<UserDetailsResponse>(activity, true, true) {
                        override fun success(userDetailsResponse: UserDetailsResponse) {
                            Logger.apiResponse("api/users/getUserDetails", "")
                            try {
                                tvCustomerName.text = userDetailsResponse.data[0].fullName
                                tvCustomerActivationTime.text = Restring.getString(activity, R.string.last_logged_in)+" "+ DateUtils.getTimeToDisplay(getActivity(), userDetailsResponse.data[0].lastSeen)

                                if (userDetailsResponse.data[0].firstSeen == null || userDetailsResponse.data[0].firstSeen.isEmpty()) {
                                    viewSiteVisit.visibility = View.GONE
                                }

                                var flag = false
                                try {
                                    if(HippoApplication.getInstance().userData.agentType == AgentType.AGENT.getOrdinal()
                                            && HippoApplication.getInstance().userData.businessProperty.hideCustomerData())
                                        flag = true
                                } catch (e: Exception) {
                                }

                                if(flag) {
                                    etCustomerPhone.visibility = View.GONE
                                    etCustomerEmail.visibility = View.GONE
                                    viewCustomerDetails.visibility = View.GONE
                                } else {
                                    if (userDetailsResponse.data[0].phoneNumber == null
                                            || userDetailsResponse.data[0].phoneNumber.isEmpty()
                                            || userDetailsResponse.data[0].phoneNumber == "") {
                                        etCustomerPhone.visibility = View.GONE
                                    } else {
                                        etCustomerPhone.visibility = View.VISIBLE
                                        etCustomerPhone.text = userDetailsResponse.data[0].phoneNumber
                                        val phoneFunctions = PhoneFunctions()
                                        var phone = ""
                                        if (userDetailsResponse.data[0].phoneNumber.substring(0, 1) == "+") {
                                            phone = userDetailsResponse.data[0].phoneNumber.substring(1, userDetailsResponse.data[0].phoneNumber.length)
                                        }
                                        val countryCode = phoneFunctions.getCountry(resources.getStringArray(R.array.CountryCodes), phone)
                                        if (countryCode != null && !countryCode.isEmpty()) {
                                            etCustomerPhone.text = "+" + countryCode + "-" + userDetailsResponse.data[0].phoneNumber.substring(countryCode.length + 1)
                                        }
                                    }

                                    if (userDetailsResponse.data[0].email == null
                                            || userDetailsResponse.data[0].email.isEmpty()
                                            || userDetailsResponse.data[0].email == "") {
                                        etCustomerEmail.visibility = View.GONE
                                    } else {
                                        etCustomerEmail.visibility = View.VISIBLE
                                        etCustomerEmail.text = userDetailsResponse.data[0].email
                                    }

                                    if ((userDetailsResponse.data[0].phoneNumber == null
                                                    || userDetailsResponse.data[0].phoneNumber.isEmpty()
                                                    || userDetailsResponse.data[0].phoneNumber == "") && (userDetailsResponse.data[0].email == null
                                                    || userDetailsResponse.data[0].email.isEmpty()
                                                    || userDetailsResponse.data[0].email == "")) {
                                        viewCustomerDetails.visibility = View.GONE
                                    }
                                }


                                /*if (userDetailsResponse.data[0].email == null
                                        || userDetailsResponse.data[0].email.isEmpty()
                                        || userDetailsResponse.data[0].email == "") {
                                    etCustomerEmail.visibility = View.GONE
                                } else {
                                    etCustomerEmail.visibility = View.VISIBLE
                                    etCustomerEmail.text = userDetailsResponse.data[0].email
                                }

                                if ((userDetailsResponse.data[0].phoneNumber == null
                                                || userDetailsResponse.data[0].phoneNumber.isEmpty()
                                                || userDetailsResponse.data[0].phoneNumber == "") && (userDetailsResponse.data[0].email == null
                                                || userDetailsResponse.data[0].email.isEmpty()
                                                || userDetailsResponse.data[0].email == "")) {
                                    viewCustomerDetails.visibility = View.GONE
                                }*/

                                showVisitorInfo(userDetailsResponse.data[0].utmSources)

                                cJourneyList.addAll(userDetailsResponse.data[0].channelJourney)
                                if(cJourneyList.size == 0)
                                    rlJourney.visibility = View.GONE

//                                if(HippoConfig.getInstance().getAttributes().isdebugType()) {
//                                    rlJourney.visibility = View.VISIBLE
//                                }


                                //setViewPager(userDetailsResponse);

                            } catch (e: Exception) {
                                e.printStackTrace()
                                Logger.apiFailed("api/users/getUserDetails", e.localizedMessage)
                            }

                        }

                        override fun failure(error: APIError) {
                            Logger.apiFailed("api/users/getUserDetails", error.message)
                            Log.e("error", "error")
                        }
                    })
        } else {
            Toast.makeText(activity, Restring.getString(activity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }

    private var cJourneyList: ArrayList<CJourney> = ArrayList()
    private var infoAdapter: VisitorInfoAdapter? = null
    private var recyclerView: androidx.recyclerview.widget.RecyclerView? = null

    private fun showVisitorInfo(utmSources: UtmSources) {
        val property = HippoApplication.getInstance().userData.businessProperty
        visitorInfo = CreateVisitorData(activity).getVisitorData(property, utmSources)

        if (visitorInfo != null && visitorInfo?.size!! > 0) {
            visitor_info_layout.visibility = View.VISIBLE
            if (visitorInfo?.size!! > 2) {
                show_more_view.visibility = View.VISIBLE
            }

            infoAdapter = VisitorInfoAdapter(visitorInfo, visitorInfo?.size!! > 2)
            recycler_view!!.isNestedScrollingEnabled = false
            recycler_view!!.adapter = infoAdapter

        } else {
            visitor_info_layout.setVisibility(View.GONE)
        }

    }

    @Throws(Exception::class)
    private fun apiGetAgents() {
        if (isNetworkAvailable()) {
            val commonParams = CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                    .add(Constants.BUSINESS_ID, HippoApplication.getInstance().userData.businessId.toString())
                    .build()
            val value = Gson().toJson(commonParams.map)
            Logger.apiRequest("/api/agent/getAgents", value)
            RestClient.getApiInterface().getAgents(commonParams.map)
                    .enqueue(object : ResponseResolver<GetAgentsResponse>(activity, true, true) {
                        override fun success(getAgentsResponse: GetAgentsResponse) {
                            Logger.apiResponse("/api/agent/getAgents", "")
                            try {
                                if (getAgentsResponse.data != null && getAgentsResponse.data.agents != null && getAgentsResponse.data.agents.size > 0) run { parseAgentData(getAgentsResponse) } else {
                                    val onlineOfflineAgents = ArrayList<GetAgentsResponse.Agents>()
                                    getAgentsResponse.data.agents = onlineOfflineAgents
                                    try {
                                        if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getAgentsResponse.statuscode) {
                                            Paper.book(CommonData.name).delete(SPLabels.AGENTS)
                                            Paper.book(CommonData.name).write(SPLabels.AGENTS, getAgentsResponse)
                                            HippoApplication.getInstance().agentsResponse = getAgentsResponse
                                        }
                                    } catch (e: Exception) {
                                        e.printStackTrace()
                                    }
                                }
                            } catch (e: Exception) {
                            }
                        }

                        override fun failure(error: APIError) {
                            Logger.apiFailed("/api/agent/getAgents", error.message)
                            Log.e("error", "error")
                        }
                    })
        } else {
            Toast.makeText(activity, Restring.getString(activity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }

    private fun parseAgentData(getAgentsResponse: GetAgentsResponse) {
        ParseAgents(object : OnAgentParseCallback {
            override fun onCallbackListener(allAgents: ArrayList<GetAgentsResponse.Agents>) {
                try {
                    getAgentsResponse.data.agents = allAgents
                    try {
                        if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getAgentsResponse.statuscode) {
                            Paper.book(CommonData.name).delete(SPLabels.AGENTS)
                            Paper.book(CommonData.name).write(SPLabels.AGENTS, getAgentsResponse)
                            HippoApplication.getInstance().agentsResponse = getAgentsResponse
                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }
        }).execute(getAgentsResponse)
    }

    private inner class GetAgentData : BroadcastReceiver() {
        override fun onReceive(context: Context, intent: Intent) {
            try {
                apiGetAgents()
            } catch (e: Exception) {
                e.printStackTrace()
            }

        }
    }

    private fun goToGmail(mail: String) {
        try {
            val emailIntent = Intent(Intent.ACTION_SENDTO, Uri.fromParts(
                    "mailto", mail, null))
            startActivity(Intent.createChooser(emailIntent, "Send email..."))
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    private fun goToPhone(phone: String) {
        try {
            val phoneIntent = Intent(Intent.ACTION_DIAL, Uri.fromParts(
                    "tel", phone, null))
            startActivity(phoneIntent)
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    private fun setAgentData() {
        try {
            if (conversation?.getAgentId() != null) {
                if (conversation?.getAgentId()!! < 1) {
                    rlAgentName.visibility = View.GONE
                    return
                }
            }

            for (i in 0 until HippoApplication.getInstance().agentsResponse?.data?.agents?.size!!) {
                if (conversation?.getAgentId() == HippoApplication.getInstance().agentsResponse.data.agents[i].userId) {
                    tvChannelInfo.visibility = View.VISIBLE
                    tvAgentName.text = HippoApplication.getInstance().agentsResponse.data.agents[i].fullName
                    LoadImageFile.getInstance().loadImage(activity, HippoApplication.getInstance().agentsResponse.data.agents[i].userImage,
                            R.drawable.agent_ic_profile_placeholder, ivAgentImage, 1)
                    if (HippoApplication.getInstance().agentsResponse.data.agents[i].fullName.isEmpty()) {
                        rlAgentName.visibility = View.GONE
                    }
                    break
                }
            }
        } catch (e: Exception) {
        }

    }

    private fun getTags() {
        if (isNetworkAvailable()) {
            val commonParams = CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                    .build()
            Logger.apiRequest("/api/tags/getTags", Gson().toJson(commonParams.map))
            RestClient.getApiInterface().getTags(commonParams.map)
                    .enqueue(object : ResponseResolver<GetTagsResponse>(activity, true, true) {
                        override fun success(getTagsResponse: GetTagsResponse) {
                            Logger.apiResponse("/api/tags/getTags", "")
                            val tags = ArrayList<Tag>()
                            val sortedTags = ArrayList<Tag>()
                            val selectedTags = ArrayList<Tag>()
                            for (i in 0 until getTagsResponse.data.tags.size) {
                                val tagsResponse = Tag()
                                tagsResponse.tagName = getTagsResponse.data.tags[i].tagName
                                tagsResponse.tagId = getTagsResponse.data.tags[i].tagId
                                tagsResponse.status = 0
                                tagsResponse.colorCode = getTagsResponse.data.tags[i].colorCode
                                tags.add(tagsResponse)
                            }
                            if (tagData.size > 0) {
                                for (i in tags.indices) {
                                    for (j in tagData.indices) {
                                        if (tagData[j].tag_id.equals(tags[i].tagId.toString(), ignoreCase = true)) {
                                            tags[i].status = 1
                                        }
                                    }
                                }

                                for (i in tags.indices) {
                                    if (tags[i].status == 1) {
                                        val tagsResponse = Tag()
                                        tagsResponse.tagName = tags[i].tagName
                                        tagsResponse.tagId = tags[i].tagId
                                        tagsResponse.status = tags[i].status
                                        tagsResponse.colorCode = tags[i].colorCode
                                        sortedTags.add(tagsResponse)
                                        selectedTags.add(tagsResponse)
                                    }
                                }
                                for (i in tags.indices) {
                                    if (tags[i].status == 0) {
                                        val tagsResponse = Tag()
                                        tagsResponse.tagName = tags[i].tagName
                                        tagsResponse.tagId = tags[i].tagId
                                        tagsResponse.status = tags[i].status
                                        tagsResponse.colorCode = tags[i].colorCode
                                        sortedTags.add(tagsResponse)
                                    }
                                }
                            } else {
                                for (i in 0 until getTagsResponse.data.tags.size) {
                                    val tags1 = Tag()
                                    tags1.tagName = getTagsResponse.data.tags[i].tagName
                                    tags1.tagId = getTagsResponse.data.tags[i].tagId
                                    tags1.status = 0
                                    tags1.colorCode = getTagsResponse.data.tags[i].colorCode
                                    sortedTags.add(tags1)
                                }
                            }
                            if (dialogTag != null && dialogTag!!.isShowing()) {
                                dialogTag!!.dismiss()
                            }
                            dialogShowTags(sortedTags, selectedTags)
                        }

                        override fun failure(error: APIError) {
                            Logger.apiFailed("/api/tags/getTags", error.message)
                            Log.e("error", "error")
                        }
                    })
        } else {
            Toast.makeText(activity, Restring.getString(activity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }

    private fun assignTags(tags: Tag, status: Int) {
        if (isNetworkAvailable()) {

            try {
                if (tags.status == 0) {
                    try {
                        for (i in tagData.indices) {
                            if (tagData[i].tag_id.equals(tags.tagId.toString(), ignoreCase = true)) {
                                tagData.removeAt(i)
                                break;
                            }
                        }
                    } catch (e: Exception) {
                    }

                } else {
                    val tag = TagData()
                    tag.color_code = tags.colorCode
                    tag.is_enabled = tags.status.toString()
                    tag.tag_id = tags.tagId.toString()
                    tag.tag_name = tags.tagName
                    tagData.add(tag)
                }
                tagList.clear()
                colorsTag.clear()
                //activity.colorsTag.add(Color.parseColor(tags.getColorCode().toLowerCase()));
                setTags()
            } catch (e: Exception) {
            }

            val commonParams = CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                    .add(Constants.CHANNEL_ID, conversation?.getChannelId().toString())
                    .add("tag_id", tags.tagId)
                    .add(Constants.STATUS, status.toString())
                    .build()
            Logger.apiRequest("/api/tags/assignTagsToChannel", Gson().toJson(commonParams.map))
            RestClient.getApiInterface().assignTags(commonParams.map)
                    .enqueue(object : ResponseResolver<AssignTagResponse>(activity, false, true) {
                        override fun success(assignTagResponse: AssignTagResponse) {
                            Logger.apiResponse("/api/tags/assignTagsToChannel", "")

                        }

                        override fun failure(error: APIError) {
                            Logger.apiFailed("/api/tags/assignTagsToChannel", error.message)
                            Log.e("error", "error")
                        }
                    })
        } else {
            Toast.makeText(activity, Restring.getString(activity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }


    private fun createTag(tagName: String, colorCode: String) {
        if (isNetworkAvailable()) {
            val commonParams = CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().userData.accessToken)
                    .add("tag_name", tagName)
                    .add("color_code", colorCode)
                    .build()
            Logger.apiRequest("/api/tags/createTags", Gson().toJson(commonParams.map))
            RestClient.getApiInterface().createTag(commonParams.map)
                    .enqueue(object : ResponseResolver<CreateTagResponse>(activity, true, true) {
                        override fun success(createTagResponse: CreateTagResponse) {
                            Logger.apiResponse("/api/tags/createTags", "")
                            if (isUseTag) {
                                //dialogTag.dismiss();
                                val tags = Tag()
                                tags.status = createTagResponse.data.tag.status
                                tags.tagName = createTagResponse.data.tag.tagName
                                tags.tagId = createTagResponse.data.tag.tagId
                                tags.colorCode = createTagResponse.data.tag.colorCode
                                assignTags(tags, 1)
                            }
                            dialogTag?.dismiss()
                            getTags()
                            dialogAddTags?.dismiss()
                        }

                        override fun failure(error: APIError) {
                            Logger.apiFailed("/api/tags/createTags", error.message)
                            Log.e("error", "error")
                        }
                    })
        } else {
            Toast.makeText(activity, Restring.getString(activity, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show()
        }
    }

//    private inner class BotEnded : BroadcastReceiver() {
//        override fun onReceive(context: Context, intent: Intent?) {
//            hasBotRunning = intent?.getBooleanExtra("hasBotRunning", false)!!
//            if(hasBotRunning) {
//                tvAssignConversation.visibility = View.GONE
//            } else {
//                tvAssignConversation.visibility = View.VISIBLE
//            }
//        }
//    }

    private inner class MigrateData : BroadcastReceiver() {
        override fun onReceive(context: Context, intent: Intent?) {
            val notificationType = intent!!.getIntExtra(FuguAppConstant.NOTIFICATION_TYPE, 7)
            Log.e(TAG, "MigrateData: $notificationType")
            if (notificationType == FuguAppConstant.USER_MIGRATION) {
                try {
                    val msgData: JSONObject
                    if (intent != null) {
                        msgData = JSONObject(intent.getStringExtra("msgData"))
                        if (msgData.optInt("user_id") == conversation?.getUserId()!!.toInt()) {
                            conversation?.setUserId(msgData.optInt("migrated_to"))
                            getUserData()
                        }
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }
        }
    }

    fun isNetworkAvailable(): Boolean {
        val cm = activity?.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager?
        val networkInfo = cm!!.activeNetworkInfo
        return if (networkInfo != null && networkInfo.isConnected) {
            true
        } else false
    }

}