package com.hippoagent.fragments;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.Toast;

import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.adapters.OptionAdapter;
import com.hippoagent.callback.OptionSelectedCallback;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.get_all_bots.Bot;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by amit on 07/05/18.
 */

@SuppressLint("ValidFragment")
public class BottomSheetFragment extends BottomSheetDialogFragment implements OptionSelectedCallback {
    private RecyclerView rvOptions;
    private View mView;
    private Context mContext;
    private OptionAdapter optionAdapter;
    private Bot mBot;
    private List<Bot> bot = new ArrayList<>();

    private Button btnNex, btnCancel;

    public BottomSheetFragment(List<Bot> data) {
        this.bot = data;
    }

    @Override
    public int getTheme() {
        return R.style.HippoBottomSheetDialogTheme;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.bottom_sheet_bot_option, container, false);
        init(view);
        return view;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        mContext = context;
    }

    private void init(View rootView) {
        rvOptions = (RecyclerView) rootView.findViewById(R.id.rvOptions);

        LinearLayoutManager layoutManager = new LinearLayoutManager(mContext);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        rvOptions.setLayoutManager(layoutManager);
        optionAdapter = new OptionAdapter(mContext, this);
        rvOptions.setAdapter(optionAdapter);
        optionAdapter.setData(bot);

        btnNex = rootView.findViewById(R.id.btnNex);
        btnCancel = rootView.findViewById(R.id.btnCancel);

        btnNex.setText(Restring.getString(getActivity(), R.string.hippo_send));
        btnCancel.setText(Restring.getString(getActivity(), R.string.cancel));

        btnNex.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(mBot!=null) {
                    ((FuguChatActivity) getActivity()).sendFaye(mBot);
                } else{
                    Toast.makeText(mContext, Restring.getString(mContext, R.string.hippo_please_select_field), Toast.LENGTH_SHORT).show();
                }
            }
        });
        btnCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ((FuguChatActivity) getActivity()).closeBottomSheet();
            }
        });
    }

    @Override
    public void optionSelected(Bot id) {
        mBot = id;
    }


}
