package com.hippoagent.fragments

import android.content.Context
import android.os.Bundle
import com.google.android.material.tabs.TabLayout
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.hippoagent.HippoApplication
import com.hippoagent.R
import kotlinx.android.synthetic.main.fragment_web_pager.*

/**
 * Created by gurmail on 2019-12-28.
 * @author gurmail
 */
public class AnalyticsWebFragment: androidx.fragment.app.Fragment(), androidx.viewpager.widget.ViewPager.OnPageChangeListener {
    override fun onPageScrollStateChanged(position: Int) {

    }

    override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {

    }

    override fun onPageSelected(position: Int) {

    }

    companion object {
        fun newInstance() = AnalyticsWebFragment()
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_web_pager, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        switchOnline.visibility = View.GONE
        tvUserName2.text = "Analytics"
        tabs.tabGravity = TabLayout.GRAVITY_CENTER
        tabs.tabMode = TabLayout.MODE_SCROLLABLE
        val adapter = SavedPager(childFragmentManager)
        pagerView.adapter = adapter
        pagerView.offscreenPageLimit = 4
        pagerView.setPagingEnabled(true)
        pagerView.addOnPageChangeListener(this)
        tabs.setupWithViewPager(pagerView)

    }

    override fun onAttach(context: Context) {
        super.onAttach(context)

    }

    override fun onDestroy() {
        super.onDestroy()

    }

    override fun onResume() {
        super.onResume()

    }

    inner class SavedPager(private val fm: androidx.fragment.app.FragmentManager): androidx.fragment.app.FragmentStatePagerAdapter(fm) {
        override fun getItem(position: Int): androidx.fragment.app.Fragment {
            /*val accessToken = HippoApplication.getInstance().userData.accessToken
            var url = "https://analytics.hippochat.io/login?access_token=$accessToken&external_parameters=true"
            when (position) {
                0 -> url = "https://analytics.hippochat.io/login?access_token=$accessToken&external_parameters=true&continue=/dashboard/402"
                1 -> url = "https://analytics.hippochat.io/login?access_token=$accessToken&external_parameters=true&continue=/dashboard/403"
                2 -> url = "https://analytics.hippochat.io/login?access_token=$accessToken&external_parameters=true&continue=/dashboard/404"
                3 -> url = "https://analytics.hippochat.io/login?access_token=$accessToken&external_parameters=true&continue=/dashboard/459"
                else -> {
                }
            }*/
            val savedFragment = AnalyticsWebViewFragment()
            val bundle = Bundle()
            bundle.putInt("position", position)
            bundle.putString("url", HippoApplication.getInstance().userDataa.analyticsListData[position].link)
            savedFragment.arguments = bundle
            return savedFragment
        }

        override fun getPageTitle(position: Int): CharSequence? {
            /*var title: String? = null
            if (position == 0) {
                title = getString(R.string.volume_trends)
            } else if (position == 1) {
                title = getString(R.string.time_trends)
            } else if (position == 2) {
                title = getString(R.string.agent_wise_trends)
            } else if(position == 3) {
                title = "Feedback"
            }*/
            return HippoApplication.getInstance().userDataa.analyticsListData[position].title
        }

        override fun getCount(): Int {
            return HippoApplication.getInstance().userDataa.analyticsListData.size
        }

    }

    /*inner class SavedPager(private val fm: FragmentManager): FragmentStatePagerAdapter(fm) {
        override fun getItem(position: Int): Fragment {
            val accessToken = HippoApplication.getInstance().userData.accessToken
            var url = "https://analytics.hippochat.io/login?access_token=$accessToken&external_parameters=true"
            when (position) {
                0 -> url = "https://analytics.hippochat.io/login?access_token=$accessToken&external_parameters=true&continue=/dashboard/402"
                1 -> url = "https://analytics.hippochat.io/login?access_token=$accessToken&external_parameters=true&continue=/dashboard/403"
                2 -> url = "https://analytics.hippochat.io/login?access_token=$accessToken&external_parameters=true&continue=/dashboard/404"
                3 -> url = "https://analytics.hippochat.io/login?access_token=$accessToken&external_parameters=true&continue=/dashboard/459"
                else -> {
                }
            }
            val savedFragment = AnalyticsWebViewFragment()
            val bundle = Bundle()
            bundle.putInt("position", position)
            bundle.putString("url", url)
            savedFragment.arguments = bundle
            return savedFragment
        }

        override fun getPageTitle(position: Int): CharSequence? {
            var title: String? = null
            if (position == 0) {
                title = getString(R.string.volume_trends)
            } else if (position == 1) {
                title = getString(R.string.time_trends)
            } else if (position == 2) {
                title = getString(R.string.agent_wise_trends)
            } else if(position == 3) {
                title = "Feedback"
            }
            return title
        }

        override fun getCount(): Int {
            return 4
        }

    }*/
}