package com.hippoagent.fragments

import android.content.Context
import android.os.Bundle
import androidx.recyclerview.widget.LinearLayoutManager
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.hippoagent.R
import com.hippoagent.activities.FilterActivity
import com.hippoagent.langs.Restring
import com.hippoagent.model.AgentListModel
import com.hippoagent.utils.SearchViewNetworkQueryHelper
import kotlinx.android.synthetic.main.fragment_people.*
import java.util.ArrayList

/**
 * Created by gurmail on 2019-09-25.
 * @author gurmail
 */
class AgentFragment: BaseFragment(), SearchViewNetworkQueryHelper.SearchCallbacks {

    var filterActivity: FilterActivity? = null
    lateinit var adapter: AgentsAdapter
    var agentListModels = ArrayList<AgentListModel>()
    lateinit var mSearchNetworkQueryHelper: SearchViewNetworkQueryHelper

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        filterActivity = context as FilterActivity?
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_people, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        filterActivity.let {
            agentListModels.addAll(it?.agentListModels!!)
            adapter = AgentsAdapter(filterActivity?.filterModel?.agentList!!, it.agentListModels)
            search_list.layoutManager = androidx.recyclerview.widget.LinearLayoutManager(activity, androidx.recyclerview.widget.LinearLayoutManager.VERTICAL, false)
            search_list.adapter = adapter
        }

        search_view.setHint(Restring.getString(activity, R.string.search_here))
        no_data_found.setText(Restring.getString(activity, R.string.no_data_found))

        mSearchNetworkQueryHelper = SearchViewNetworkQueryHelper(search_view, this)
        mSearchNetworkQueryHelper.suggestCountThreshold = 2
        mSearchNetworkQueryHelper.suggestWaitThreshold = 100

    }

    override fun showLoader() {

    }

    override fun performQuery(query: String?) {
        agentListModels.clear()
        for (filter in filterActivity?.agentListModels!!) {
            if (filter.name.toLowerCase().contains(query?.toLowerCase()!!)) {
                agentListModels.add(filter)
            }
        }

        adapter.setData(agentListModels)
        if (agentListModels.size == 0) {
            no_data_found.visibility = View.VISIBLE
            search_list.visibility = View.GONE
        } else {
            no_data_found.visibility = View.GONE
            search_list.visibility = View.VISIBLE
        }

    }

    override fun showAllData() {
        adapter.setData(filterActivity?.agentListModels!!)
        no_data_found.visibility = View.GONE
        search_list.visibility = View.VISIBLE
    }

}