package com.hippoagent.fragments

import android.content.Context
import android.os.Bundle
import android.os.Handler
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.inputmethod.InputMethodManager
import android.widget.EditText
import android.widget.LinearLayout
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.widget.AppCompatButton
import androidx.appcompat.widget.Toolbar
import androidx.core.widget.NestedScrollView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.google.android.material.checkbox.MaterialCheckBox
import com.google.android.material.textfield.TextInputEditText
import com.google.gson.Gson
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.activities.PlansActivity
import com.hippoagent.adapters.HippoPaymentAdapter
import com.hippoagent.apis.PaymentPlan
import com.hippoagent.apis.PaymentPlan.savePlan
import com.hippoagent.callback.OnItemOpertionListener
import com.hippoagent.callback.OnPaymentDialogListener
import com.hippoagent.langs.Restring
import com.hippoagent.model.LoginResponse.BusinessCurrency
import com.hippoagent.model.PaymentData
import com.hippoagent.model.PaymentModelData
import com.hippoagent.model.payment.PlanData
import com.hippoagent.utils.Log
import com.hippoagent.utils.Utils
import com.hippoagent.utils.countrypicker.Country
import kotlinx.android.synthetic.main.hippo_fragment_payment.*
import java.util.*

/**
 * Created by gurmail on 30/07/20.
 * @author gurmail
 */
class AddPlanFragment: BaseFragment(), OnItemOpertionListener, OnPaymentDialogListener {

    var plansActivity: PlansActivity? = null
    var addPlan: Boolean = false
    var sendPlan: Boolean = false
    var editPlan: Boolean = false
    var isEditable: Boolean = false


    private var paymentAdapter: HippoPaymentAdapter? = null
    private var paymentModelData = ArrayList<PaymentModelData>()
    private val businessCurrency = ArrayList<BusinessCurrency>()
    private var countryCurrency: Country? = null
    private var fromSavedPlan = false
    private var planData: PlanData? = null
    private var planType = 0
    private var showEditBtn = true

    private var planTitle: TextInputEditText? = null
    private var addOptionView: TextView? = null
    private  var title: TextView? = null
    private var totalCount: TextView? = null
    private var recyclerView: RecyclerView? = null
    private val scrollView: NestedScrollView? = null
    private var toolbar: Toolbar? = null
    private var buttonSubmit: AppCompatButton? = null
    private var topLayout: LinearLayout? = null
    private var savePlanCheck: MaterialCheckBox? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        if(arguments != null) {
            fromSavedPlan = arguments!!.getBoolean("from_saved_plan", false)//getIntent().getBooleanExtra("from_saved_plan", false)
            planData = Gson().fromJson<PlanData>(arguments!!.getString("data"), PlanData::class.java)
            editPlan = arguments!!.getBoolean("edit_plan", false)
            isEditable = arguments!!.getBoolean("is_editable", false)
            addPlan = arguments!!.getBoolean("add_plan", false)
            sendPlan = arguments!!.getBoolean("send_plan", false)

            if (isEditable) {
                planType = 1
            } else if (addPlan) {
                planType = 2
            }
        }
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.hippo_fragment_payment, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        handleData()
        onPostCreate(view)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)

        if(activity is PlansActivity) {
            plansActivity = activity as PlansActivity
        }

        plansActivity?.setSupportActionBar(my_toolbar)
        setHasOptionsMenu(true)
        val msg = Restring.getString(plansActivity, R.string.saved_plan)
        plansActivity?.setToolbar(my_toolbar, msg)

        my_toolbar.setNavigationIcon(R.drawable.hippo_ic_arrow_back)


        my_toolbar.setNavigationOnClickListener {
            hideKeyboard()
            plansActivity?.onBackPressed()
        }

        
    }

    private fun handleData() {

        paymentModelData = ArrayList<PaymentModelData>()
        businessCurrency.clear()
        businessCurrency.addAll(HippoApplication.getInstance().userData.businessProperty.businessCurrency)
        if (editPlan) {
            if (planData != null && planData!!.getPlans().size > 0) {
                for (i in planData!!.getPlans().indices) {
                    val modelData = PaymentModelData()
                    modelData.title = planData!!.getPlans().get(i).getTitle()
                    modelData.itemDescription = planData!!.getPlans().get(i).getDescription()
                    var amount = ""+planData!!.getPlans().get(i).getAmount()
                    try {
                        amount = Utils.getMoneyDecimalFormat().format(planData!!.getPlans().get(i).getAmount())
                    } catch (e: Exception) {
                    }
                    modelData.price = amount
                    modelData.symbol = planData!!.getPlans().get(i).getCurrencySymbol()
                    modelData.currency = planData!!.getPlans().get(i).getCurrency()
                    var position = 0
                    for (j in businessCurrency.indices) {
                        if (businessCurrency.get(j).getCurrency().equals(planData!!.getPlans().get(i).getCurrency(), ignoreCase = true)) {
                            position = j
                            break
                        }
                    }
                    modelData.position = position
                    paymentModelData.add(modelData)
                    Handler().post { hideKeyboard() }
                }
            }
            if (!isEditable) {
                showEditBtn = false
            }
        } else if (addPlan) {
            // first item added
            val modelData = PaymentModelData()
            modelData.title = ""
            modelData.itemDescription = ""
            modelData.price = ""
            modelData.position = 0
            paymentModelData.add(modelData)
        } else if (sendPlan) {
            //planData = Gson().fromJson<PlanData>(getIntent().getStringExtra("data"), PlanData::class.java)
            if(planData != null) {
                for (i in planData!!.plans.indices!!) {
                    val modelData = PaymentModelData()
                    modelData.title = planData!!.getPlans().get(i).getTitle()
                    modelData.itemDescription = planData!!.getPlans().get(i).getDescription()
                    //modelData.price = "" + planData!!.getPlans().get(i).getAmount()
                    var amount = "" + planData!!.getPlans().get(i).getAmount()
                    try {
                        amount = Utils.getMoneyDecimalFormat().format(planData!!.getPlans().get(i).getAmount())
                    } catch (e: Exception) {
                    }
                    modelData.price = amount
                    modelData.symbol = planData!!.getPlans().get(i).getCurrencySymbol()
                    modelData.currency = planData!!.getPlans().get(i).getCurrency()
                    var position = 0
                    for (j in businessCurrency.indices) {
                        if (businessCurrency.get(j).getCurrency().equals(planData!!.getPlans().get(i).getCurrency(), ignoreCase = true)) {
                            position = j
                            break
                        }
                    }
                    modelData.position = position
                    paymentModelData.add(modelData)

                }
            }

            hideKeyboard()
        } else {
            // first item added
            val modelData = PaymentModelData()
            modelData.title = ""
            modelData.itemDescription = ""
            modelData.price = ""
            modelData.position = 0
            paymentModelData.add(modelData)
        }
    }

    private fun hideKeyboard() {
        try {
            val view = activity?.currentFocus
            val imm = activity?.getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
            imm.hideSoftInputFromWindow(view?.windowToken, 0)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }


    private fun onPostCreate(view: View) {

        title = view.findViewById<TextView>(R.id.title_name)
        planTitle = view.findViewById<TextInputEditText>(R.id.plan_title)
        topLayout = view.findViewById<LinearLayout>(R.id.top_layout)
        recyclerView = view.findViewById<RecyclerView>(R.id.recycler_view)
        addOptionView = view.findViewById<TextView>(R.id.add_option_view)
        buttonSubmit = view.findViewById<AppCompatButton>(R.id.buttonSubmit)
        savePlanCheck = view.findViewById<MaterialCheckBox>(R.id.save_plan)
        totalCount = view.findViewById<TextView>(R.id.total_count)
        title!!.text = Restring.getString(activity, R.string.plan_name)
        planTitle!!.hint = Restring.getString(activity, R.string.hippo_plan_title)
        addOptionView!!.text = Restring.getString(activity, R.string.hippo_add_an_option)
        buttonSubmit!!.text = Restring.getString(activity, R.string.hippo_send_payment)
        savePlanCheck!!.text = Restring.getString(activity, R.string.hippo_save_plan)
        planTitle!!.visibility = View.GONE
        topLayout!!.visibility = View.GONE
        if (planType == 1) {
            planTitle!!.isEnabled = false
            //buttonSubmit!!.visibility = View.GONE
            addOptionView!!.visibility = View.GONE
            planTitle!!.visibility = View.VISIBLE
            topLayout!!.visibility = View.VISIBLE
        } else if (planType == 2) {
            planTitle!!.visibility = View.VISIBLE
            topLayout!!.visibility = View.VISIBLE
        }
        if (fromSavedPlan) {
            topLayout!!.visibility = View.VISIBLE
            planTitle!!.visibility = View.VISIBLE
        }
        if(editPlan) {
            savePlanCheck!!.visibility = View.GONE
            topLayout!!.visibility = View.VISIBLE
            planTitle!!.visibility = View.VISIBLE

        }
        totalCount!!.visibility = View.GONE
        val currency = arrayOfNulls<String>(businessCurrency.size)
        for (i in businessCurrency.indices) {
            val name = businessCurrency[i]
            currency[i] = name.currencySymbol
        }
        paymentAdapter = HippoPaymentAdapter(paymentModelData, this, planType, currency)
        val layoutManager = LinearLayoutManager(activity)
        layoutManager.orientation = LinearLayoutManager.VERTICAL
        recyclerView!!.layoutManager = layoutManager
        recyclerView!!.adapter = paymentAdapter
        addOptionView!!.setOnClickListener(View.OnClickListener {
            if (paymentModelData.size > 0) {
                if (TextUtils.isEmpty(paymentModelData[paymentModelData.size - 1].title.trim { it <= ' ' }) ||
                        TextUtils.isEmpty(paymentModelData[paymentModelData.size - 1].itemDescription.trim { it <= ' ' }) ||
                        TextUtils.isEmpty(paymentModelData[paymentModelData.size - 1].price.trim { it <= ' ' })) {
                    Toast.makeText(activity, Restring.getString(activity, R.string.hippo_fill_pre_field), Toast.LENGTH_SHORT).show()
                    return@OnClickListener
                }
                var aDouble1: Double? = null
                try {
                    if(!TextUtils.isEmpty(paymentModelData[paymentModelData.size - 1].price.trim { it <= ' ' })) {
                        aDouble1 = paymentModelData[paymentModelData.size - 1].price.trim { it <= ' ' }.toDouble()
                        paymentModelData[paymentModelData.size - 1].errorPrice = null
                        if(aDouble1 < .01) {
                            paymentModelData[paymentModelData.size - 1].errorPrice = Restring.getString(activity, R.string.hippo_invalid_price)
                            paymentAdapter?.notifyItemChanged(paymentModelData.size - 1)
                            return@OnClickListener
                        }
                    } else {
                        paymentModelData[paymentModelData.size - 1].errorPrice = Restring.getString(activity, R.string.hippo_invalid_price)
                        paymentAdapter?.notifyItemChanged(paymentModelData.size - 1)
                        return@OnClickListener
                    }
                } catch (e: NumberFormatException) {
                    e.printStackTrace()
                    paymentModelData[paymentModelData.size - 1].errorPrice = Restring.getString(activity, R.string.hippo_invalid_price)
                    paymentAdapter?.notifyItemChanged(paymentModelData.size - 1)
                    return@OnClickListener
                }
            }
            val modelData = PaymentModelData()
            modelData.title = ""
            modelData.itemDescription = ""
            modelData.price = ""
            modelData.position = 0
            paymentModelData.add(modelData)
            if(paymentModelData.size == 2) {
                paymentAdapter?.notifyDataSetChanged()
            } else {
                paymentAdapter?.notifyItemInserted(paymentModelData.size - 1)
            }
        })
        savePlanCheck!!.setOnCheckedChangeListener { buttonView, isChecked ->
            if(!editPlan) {
                if (buttonView.isChecked) {
                    topLayout!!.visibility = View.VISIBLE
                    planTitle!!.visibility = View.VISIBLE
                } else {
                    topLayout!!.visibility = View.GONE
                    planTitle!!.visibility = View.GONE
                }
            }
        }
        buttonSubmit!!.setOnClickListener(View.OnClickListener {
            hideKeyboard()
            val paymentData = ArrayList<PaymentData>()
            if (planTitle!!.visibility == View.VISIBLE && TextUtils.isEmpty(planTitle!!.text.toString().trim { it <= ' ' })) {
                planTitle!!.requestFocus()
                planTitle!!.error = Restring.getString(activity, R.string.hippo_field_cant_empty)
                return@OnClickListener
            }
            for (i in paymentModelData.indices) {
                val data1 = PaymentData()
                val modelData = paymentModelData[i]
                /*if (TextUtils.isEmpty(modelData.title.trim { it <= ' ' }) && TextUtils.isEmpty(modelData.itemDescription.trim { it <= ' ' })
                        && TextUtils.isEmpty(modelData.price.trim { it <= ' ' })) {
                    continue
                } else  {

                }*/
                paymentModelData[i].errorTitle = null
                paymentModelData[i].errorDesc = null
                paymentModelData[i].errorPrice = null
                if (TextUtils.isEmpty(modelData.title.trim { it <= ' ' })) {
                    paymentModelData[i].errorTitle = Restring.getString(activity, R.string.hippo_field_cant_empty)
                    paymentAdapter?.notifyItemChanged(i)
                    return@OnClickListener
                } else if (TextUtils.isEmpty(modelData.itemDescription.trim { it <= ' ' })) {
                    paymentModelData[i].errorDesc = Restring.getString(activity, R.string.hippo_field_cant_empty)
                    paymentAdapter?.notifyItemChanged(i)
                    return@OnClickListener
                } else if (TextUtils.isEmpty(modelData.price.trim { it <= ' ' })) {
                    paymentModelData[i].errorPrice = Restring.getString(activity, R.string.hippo_field_cant_empty)
                    paymentAdapter?.notifyItemChanged(i)
                    return@OnClickListener
                } else {
                    var aDouble: Double? = null
                    try {
                        aDouble = modelData.price.trim { it <= ' ' }.toDouble()
                    } catch (e: NumberFormatException) {
                        e.printStackTrace()
                        paymentModelData[i].errorPrice = Restring.getString(activity, R.string.hippo_invalid_price)
                        paymentAdapter?.notifyItemChanged(i)
                        return@OnClickListener
                    }
                    if (aDouble == null) {
                        paymentModelData[i].errorPrice = Restring.getString(activity, R.string.hippo_invalid_price)
                        paymentAdapter?.notifyItemChanged(i)
                        return@OnClickListener
                    }
                    if(aDouble <= 0 || aDouble < .01) {
                        paymentModelData[i].errorPrice = Restring.getString(activity, R.string.hippo_invalid_price)
                        paymentAdapter?.notifyItemChanged(i)
                        return@OnClickListener
//                        Toast.makeText(activity, Restring.getString(activity, R.string.hippo_invalid_price), Toast.LENGTH_SHORT).show()
//                        return@OnClickListener
                    }

                    data1.id = i + 1
                    data1.transactionId = UUID.randomUUID().toString() + "." + Date().time
                    data1.description = modelData.itemDescription.trim { it <= ' ' }
                    data1.amount = aDouble
                    val currency = businessCurrency[modelData.position].currency
                    val symbol = businessCurrency[modelData.position].currencySymbol
                    data1.currency = currency
                    data1.currencySymbol = symbol

                    /*if(countryCurrency != null) {
                            data1.setCurrency(countryCurrency.getCurrency());
                            data1.setCurrencySymbol(countryCurrency.getSymbol());
                        } else {
                            data1.setCurrency("INR");
                            data1.setCurrencySymbol("₹");
                        }*/
                    data1.title = modelData.title.trim { it <= ' ' }
                    paymentData.add(data1)
                }
            }
            if (paymentData.size == 0) {
                paymentModelData[0].errorTitle = Restring.getString(activity, R.string.hippo_field_cant_empty)
                paymentAdapter?.notifyItemChanged(0)
                return@OnClickListener
            }

            if (savePlanCheck!!.isChecked) {
                savePlan(paymentData, planData, planTitle!!.text.toString().trim { it <= ' ' })
            }
            Log.e("TAG", "data = " + Gson().toJson(paymentData))

            if(isEditable) {
                plansActivity?.sendPaymentRequest(paymentData)
            } else if(editPlan) {
                PaymentPlan.editPlan(activity!!, paymentData, planData, planTitle!!.text.toString().trim { it <= ' ' }, this)
            } else {
                plansActivity?.sendPaymentRequest(paymentData)
            }


        })
        setEditView()
    }

    private fun setEditView() {
        when (planType) {
            1 -> buttonSubmit!!.text = Restring.getString(activity, R.string.hippo_send_payment)
            2 -> buttonSubmit!!.text = Restring.getString(activity, R.string.hippo_send_payment)
        }
        if(editPlan) {
            savePlanCheck!!.isChecked = false
            buttonSubmit!!.text = Restring.getString(activity, R.string.hippo_update_plan)
        }
        if(isEditable) {
            buttonSubmit!!.visibility = View.GONE
            buttonSubmit!!.text = Restring.getString(activity, R.string.hippo_send_payment)
        }
        if (planData != null && planData!!.plans != null && planData!!.plans.size > 0) {
            planTitle!!.setText(planData!!.planName)
            try {
                countryCurrency = Country()
                countryCurrency?.setSymbol( planData!!.plans[0].currencySymbol)
                countryCurrency?.setCurrency(planData!!.plans[0].currency)
            } catch (e: java.lang.Exception) {
                e.printStackTrace()
            }
        }
    }

    override fun onItemRemoved(position: Int) {
        paymentModelData.removeAt(position)
        paymentAdapter!!.notifyDataSetChanged()
    }

    override fun onItemAdded() {
        var totalPrice = 0.0
        if (paymentModelData != null && paymentModelData.size > 0) {
            for (modelData in paymentModelData) {
                if (modelData != null && !TextUtils.isEmpty(modelData.price)) {
                    totalPrice = try {
                        totalPrice + modelData.price.trim { it <= ' ' }.toDouble()
                    } catch (e: java.lang.NumberFormatException) {
                        e.printStackTrace()
                        return
                    }
                }
            }
        }
    }

    override fun onPaymentSent() {

    }

    override fun onPaymentUpdate() {
        plansActivity?.onPaymentUpdate()
    }

    override fun onPlanDeleted(position: Int) {

    }

    override fun onPlanDeleteError(error: String?) {
        Toast.makeText(activity, error, Toast.LENGTH_SHORT).show()
    }

    /*private fun enabledView() {
        if (buttonSubmit!!.visibility == View.GONE) {
            planTitle!!.isEnabled = true
            addOptionView!!.visibility = View.VISIBLE
            buttonSubmit!!.visibility = View.VISIBLE
            if (paymentAdapter != null) paymentAdapter!!.updateEnabled(0)
            showEditBtn = false
            invalidateOptionsMenu()
        }
    }*/

}