package com.hippoagent.fcm;

import android.app.IntentService;
import android.content.Intent;

import org.json.JSONObject;

/**
 * Created by gurmail on 09/05/19.
 *
 * @author gurmail
 */
public class RetryIntentService extends IntentService {

    private static final String TAG = RetryIntentService.class.getSimpleName();
    public RetryIntentService() {
        super(TAG);
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        try {
            String payload = intent.getStringExtra("json");
            JSONObject data = new JSONObject(payload);
            String message = data.optString("push_message");
            NotificationUtils.clearNotifications(this, data.optInt("channel_id"));
            new SendReplyMessage(this).sendMessage(data, message);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
