package com.hippoagent.fcm

import com.hippoagent.database.CommonData
import io.paperdb.Paper
import java.util.*
import kotlin.collections.HashMap

/**
 * Created by gurmail on 07/05/19.
 * @author gurmail
 */
object NotificationDatabase {

    private var STACK_NOTIFICATIONS_MAP = TreeMap<Int, ArrayList<PushNotification>>()
    private var NOTIFICATION_TIMESTAMP = TreeMap<Int, Long>()
    private val STACK_NOTIFICATIONS = "hippo_stack_notifications"
    private val HIPPO_NOTIFICATION_TIMESTAMP = "hippo_notification_timestamp"

    fun setNotification(channelId: Int?, notificationsList: ArrayList<PushNotification>) {
        try {
            STACK_NOTIFICATIONS_MAP.put(channelId!!, notificationsList)
            Paper.book(CommonData.name).write(STACK_NOTIFICATIONS, STACK_NOTIFICATIONS_MAP)
        } catch (e: Exception) {
            Paper.book(CommonData.name).delete(STACK_NOTIFICATIONS)
        }
        updateNotiTimeStamp(channelId)
    }

    fun updateNotiTimeStamp(channelId: Int?) {
        try {
            NOTIFICATION_TIMESTAMP = getNotificationTime()
            NOTIFICATION_TIMESTAMP.put(channelId!!, System.currentTimeMillis())
            Paper.book(CommonData.name).write(HIPPO_NOTIFICATION_TIMESTAMP, NOTIFICATION_TIMESTAMP)
        } catch (e: Exception) {
        }
    }

    fun getNotifications(channelId: Int?): ArrayList<PushNotification> {
        try {
            if (STACK_NOTIFICATIONS_MAP.isEmpty()) {
                STACK_NOTIFICATIONS_MAP = Paper.book(CommonData.name).read(STACK_NOTIFICATIONS, TreeMap<Int, ArrayList<PushNotification>>())
            }
            return STACK_NOTIFICATIONS_MAP.get(channelId)!!
        } catch (e: Exception) {
            Paper.book(CommonData.name).delete(STACK_NOTIFICATIONS)
            return ArrayList()
        }
    }

    fun getNotificationTime() : TreeMap<Int, Long> {
        NOTIFICATION_TIMESTAMP = Paper.book(CommonData.name).read(HIPPO_NOTIFICATION_TIMESTAMP, TreeMap<Int, Long>())
        return NOTIFICATION_TIMESTAMP
    }

    fun updateNotificationTimeStamp(channelId: Int?) {
        try {
            var nTimeStamp = getNotificationTime()
            nTimeStamp.remove(channelId)
            Paper.book(CommonData.name).write(HIPPO_NOTIFICATION_TIMESTAMP, nTimeStamp)
        } catch (e: Exception) {
        }
    }

    fun removeNotifications(channelId: Int?) {
        try {
            if (!STACK_NOTIFICATIONS_MAP.isEmpty()) {
                val NEW_STACk_NOTIFICATIONS_MAP = STACK_NOTIFICATIONS_MAP
                NEW_STACk_NOTIFICATIONS_MAP.remove(channelId)
                Paper.book(CommonData.name).write<TreeMap<Int, ArrayList<PushNotification>>>(STACK_NOTIFICATIONS, NEW_STACk_NOTIFICATIONS_MAP)
                STACK_NOTIFICATIONS_MAP = NEW_STACk_NOTIFICATIONS_MAP;
            } else {
                val NEW_STACk_NOTIFICATIONS_MAP = Paper.book(CommonData.name).read(STACK_NOTIFICATIONS, TreeMap<Int, ArrayList<PushNotification>>())
                if(NEW_STACk_NOTIFICATIONS_MAP.containsKey(channelId)) {
                    NEW_STACk_NOTIFICATIONS_MAP.remove(channelId)
                    Paper.book(CommonData.name).write<TreeMap<Int, ArrayList<PushNotification>>>(STACK_NOTIFICATIONS, NEW_STACk_NOTIFICATIONS_MAP)
                    STACK_NOTIFICATIONS_MAP = NEW_STACk_NOTIFICATIONS_MAP;
                }
            }

        } catch (e: Exception) {
            Paper.book(CommonData.name).delete(STACK_NOTIFICATIONS)
        }
        updateNotificationTimeStamp(channelId)
    }
}