package com.hippoagent.fcm

import android.app.IntentService
import android.content.Intent
import com.hippoagent.database.CommonData
import org.json.JSONObject

/**
 * Created by gurmail on 09/05/19.
 * @author gurmail
 */
class CancelIntentService : IntentService("MyService") {

    override fun onHandleIntent(intent: Intent?) {
        val channedId = intent?.getIntExtra("channel_id", -1)
        if(channedId != null && channedId > 0)
            clearNotification(channedId)
    }

    private fun clearNotification(channelId: Int) {
        try {
            NotificationDatabase.removeNotifications(channelId)
            NotificationUtils.clearNotifications(this, channelId)
            CommonData.removeNotificationChannel(channelId)
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }
}