package com.hippoagent.dialogs;

import android.app.Activity;
import android.app.Dialog;
import android.content.Intent;
import android.os.Handler;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.hippoagent.Config;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HippoPaymentActivity;
import com.hippoagent.adapters.SavedPlanAdapter;
import com.hippoagent.apis.PaymentPlan;
import com.hippoagent.callback.OnPaymentDialogListener;
import com.hippoagent.callback.OnPlanListener;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.PaymentData;
import com.hippoagent.model.payment.GetPaymentLinks;
import com.hippoagent.model.payment.PlanData;
import com.hippoagent.model.payment.Plans;
import com.hippoagent.model.payment.SavedPlanResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;

/**
 * Created by gurmail on 2019-12-06.
 *
 * @author gurmail
 */
public class SavedPlanDialog implements OnPaymentDialogListener {
    private Activity context;
    private Dialog dialog;


    public SavedPlanDialog(Activity context) {
        this.context = context;
    }


    public Dialog show() {
        try {
            dialog = new Dialog(context, R.style.HippoAppTheme);
            dialog.getWindow().getAttributes().windowAnimations = R.style.Animations_LoadingDialogFade;
            dialog.setContentView(R.layout.dialog_show_agents);

            WindowManager.LayoutParams layoutParams = dialog.getWindow().getAttributes();
            layoutParams.dimAmount = 0.6f;
            dialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);

            final TextView tvTitle = dialog.findViewById(R.id.tvTitle);
            TextView tvSavedData = dialog.findViewById(R.id.tvSavedData);
            tvSavedData.setVisibility(View.GONE);
            tvTitle.setText(Restring.getString(context, R.string.saved_plan));
            ProgressBar pbLoadReply = dialog.findViewById(R.id.pbLoadReply);
            pbLoadReply.setVisibility(View.GONE);
            ImageView ivClose = dialog.findViewById(R.id.ivClose);
            ImageButton ibSearch = dialog.findViewById(R.id.ibSearch);
            LinearLayout llsearch = dialog.findViewById(R.id.llsearch);
            llsearch.setVisibility(View.GONE);
            ibSearch.setVisibility(View.GONE);
            ivClose.setVisibility(View.GONE);

            ImageView backBtn = dialog.findViewById(R.id.backBtn);
            ImageView ivAddNew = dialog.findViewById(R.id.ivAddNew);

            noDataFound = dialog.findViewById(R.id.no_data_found);
            noDataFound.setVisibility(View.GONE);

            ivAddNew.setVisibility(View.VISIBLE);
            backBtn.setVisibility(View.VISIBLE);

            backBtn.setOnClickListener(v -> dialog.dismiss());

            ivAddNew.setOnClickListener(v -> {
                Intent paymentIntent = new Intent(context, HippoPaymentActivity.class);
                paymentIntent.putExtra("from_saved_plan", true);
                context.startActivityForResult(paymentIntent, Config.REQUEST_CODE_PICK_PAYMENT);
                dialog.dismiss();
            });

            rvAgents = dialog.findViewById(R.id.rvAgents);
            rvAgents.setLayoutManager(new LinearLayoutManager(context));
            rvAgents.setItemAnimator(new DefaultItemAnimator());
            rvAgents.setHasFixedSize(false);

            adapter = new SavedPlanAdapter(new OnPlanListener() {
                @Override
                public void onPlanViewOnly(int pos, @NotNull PlanData planData) {

                }

                @Override
                public void onPlanEditView(int pos, @NotNull PlanData planData) {

                }

                @Override
                public void onPlanClicked(int pos, @NotNull PlanData planData) {
                    sendPayment(pos, planData);
                }
                @Override
                public void onDeleteClicked(int pos, @NotNull PlanData planData) {
                    //deletePlan(pos, planData);
                    onPlanEdit(context, planData);
                }
            }, false);

            ivClose.setOnClickListener(v -> dialog.dismiss());

            rvAgents.setAdapter(adapter);
            getSavedCard();

            dialog.show();

        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return dialog;
    }

    private SavedPlanAdapter adapter;
    private ArrayList<PlanData> plansList = new ArrayList<>();
    private TextView noDataFound;
    private RecyclerView rvAgents;

    private void getSavedCard() {
        if (((FuguChatActivity) context).isNetworkAvailable()) {

            ArrayList<Integer> array = new ArrayList();
            array.add(1);
            if (HippoConfig.getInstance().getAttributes() != null &&
                    HippoConfig.getInstance().getAttributes().getAdditionalInfo() != null
                    && HippoConfig.getInstance().getAttributes().getAdditionalInfo().showBusinessPlan()) {
                array.add(2);
            }

            GetPaymentLinks paymentLinks = new GetPaymentLinks(HippoApplication.getInstance().getUserData().getAccessToken(),
                    0, array, HippoConfig.getInstance().getCurrentLanguage());

            RestClient.getApiInterface().getPaymentLinks(paymentLinks).enqueue(new ResponseResolver<SavedPlanResponse>(context, true, true) {
                @Override
                public void success(SavedPlanResponse savedPlanResponse) {
                    try {
                        plansList.addAll(savedPlanResponse.getData());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    adapter.setData(plansList);
                    if (plansList.size() == 0) {
                        Intent paymentIntent = new Intent(context, HippoPaymentActivity.class);
                        paymentIntent.putExtra("from_saved_plan", true);
                        context.startActivityForResult(paymentIntent, Config.REQUEST_CODE_PICK_PAYMENT);
                        dialog.dismiss();
                    }
                }

                @Override
                public void failure(APIError error) {

                }
            });

        } else {
            Toast.makeText(context, context.getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    private void sendPayment(int position, PlanData planData) {
        String msg = Restring.getString(context, R.string.hippo_send_this_plan);
        String yes = Restring.getString(context, R.string.hippo_yes);
        String no = Restring.getString(context, R.string.hippo_no);
        new AlertDialog.Builder(context)
                .setMessage(msg)
                .setPositiveButton(yes, (dialog1, which) -> {
                    try {
                        ArrayList<PaymentData> paymentData = new ArrayList<>();
                        for(Plans data : planData.getPlans()) {
                            PaymentData data1 = new PaymentData();
                            data1.setTransactionId(UUID.randomUUID().toString() + "." + new Date().getTime());
                            data1.setTitle(data.getTitle());
                            data1.setId(data.getId());
                            data1.setDescription(data.getDescription());
                            data1.setAmount(data.getAmount());
                            data1.setCurrency(data.getCurrency());
                            data1.setCurrencySymbol(data.getCurrencySymbol());
                            paymentData.add(data1);
                        }
                        ((FuguChatActivity) context).sendPaymentRequest(paymentData);
                        new Handler().post(new Runnable() {
                            @Override
                            public void run() {
                                dialog1.dismiss();
                                if(dialog != null)
                                    dialog.dismiss();
                            }
                        });
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                })
                .setNegativeButton(no, (dialog1, which) -> {

                }).show();
    }

    private void deletePlan(int position, PlanData planData) {
        String msg = Restring.getString(context, R.string.hippo_delete_this_plan);
        String yes = Restring.getString(context, R.string.hippo_yes);
        String no = Restring.getString(context, R.string.hippo_no);
        new AlertDialog.Builder(context)
                .setMessage(msg)
                .setPositiveButton(yes, (dialog, which) -> PaymentPlan.INSTANCE.deletePlan(context, position, planData, this))
                .setNegativeButton(no, (dialog, which) -> {

                }).show();
    }


    @Override
    public void onPaymentSent() {
        if(dialog != null) {
            dialog.dismiss();
        } else {
            Toast.makeText(context, R.string.hippo_plan_sent, Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    public void onPlanDeleted(int position) {
        Toast.makeText(context, R.string.hippo_plan_deleted, Toast.LENGTH_SHORT).show();
        if(plansList != null && plansList.size()>0) {
            plansList.remove(position);
            adapter.notifyItemRemoved(position);
        }
        if(plansList != null && plansList.size() == 0) {
            noDataFound.setVisibility(View.VISIBLE);
            rvAgents.setVisibility(View.GONE);
            if(dialog != null)
                dialog.dismiss();
        }
    }

    @Override
    public void onPlanDeleteError(String message) {
        Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
    }

    private void onPlanEdit(Activity activity, PlanData planData) {
        Intent paymentIntent = new Intent(activity, HippoPaymentActivity.class);
        paymentIntent.putExtra("edit_plan", true);
        try {
            paymentIntent.putExtra("is_editable", planData.getUserId() == HippoApplication.getInstance().getUserData().getUserId().intValue());
        } catch (Exception e) {
            paymentIntent.putExtra("is_editable", false);
        }
        paymentIntent.putExtra("data", new Gson().toJson(planData));
        activity.startActivityForResult(paymentIntent, Config.REQUEST_CODE_PICK_PAYMENT);
    }

    @Override
    public void onPaymentUpdate() {

    }
}