package com.hippoagent.database;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.wifi.hotspot2.omadm.PpsMoParser;
import android.text.TextUtils;

import com.hippoagent.HippoConfig;
import com.hippoagent.HippoConfigAttributes;
import com.hippoagent.helper.VersionUpdate;
import com.hippoagent.langs.Translation;
import com.hippoagent.model.FuguConversation;
import com.hippoagent.model.FuguGetMessageResponse;
import com.hippoagent.model.Message;
import com.hippoagent.model.UnreadCountData;
import com.hippoagent.model.groupCall.GroupCallData;
import com.hippoagent.model.groupCall.GroupCallResponse;
import com.hippoagent.model.unreadResponse.AgentUnreadCount;
import com.hippoagent.model.user_details.DeviceDetails;
import com.hippoagent.utils.FuguColorConfig;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.SPLabels;
import com.hippoagent.utils.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;

import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;

import io.paperdb.Paper;

import static com.hippoagent.utils.Constants.PAPER_COLOR_CONFIG;

/**
 * Created by Bhavya Rattan on 15/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public final class CommonData implements PaperDbConstant {

    public static String name = "hippoagentsdk.paperdb";

    public static List<FuguConversation> CONVERSATION_LIST = Collections.emptyList();
    public static FuguColorConfig COLOR_CONFIG = new FuguColorConfig();

    private static HashMap<String, UnreadCountData> UNREAD_COUNT = new HashMap<>();
    private static HashMap<Integer, Integer> TOTAL_UNREAD_COUNT = new HashMap<>();
    /**
     * Empty Constructor
     * not called
     */
    private CommonData() {
    }

    public static void clearOldData() {
        try {
            Paper.book(name).delete(PAPER_GET_MESSAGE_RESPONSE_MAP);
            Paper.book(name).delete(PAPER_UNSENT_MESSAGE_MAP);
            Paper.book(name).delete(PAPER_UNSENT_MESSAGES);
            Paper.book(name).delete(PAPER_SENT_MESSAGES);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setlineBeforeFeedback(String key, String value) {
        if(TextUtils.isEmpty(value))
            return;
        Paper.book(name).write(key, value);
    }

    public static String getLineFeedback(String key) {
        return Paper.book(name).read(key);
    }


    /**
     * Save PAPER_CONVERSATION_LIST
     *
     * @param getMessageResponse
     */

    public static void setMessageResponse(Integer channelId, FuguGetMessageResponse getMessageResponse) {

        try {
            Paper.book(name).write(PAPER_GET_MESSAGE_RESPONSE_MAP+channelId, getMessageResponse);
        } catch (Exception e) {

        }

    }

    /**
     * Gets PAPER_GET_MESSAGE_RESPONSE_MAP
     *
     * @return the messageResponse
     */

    public static FuguGetMessageResponse getMessageResponse(Integer channelId) {
        try {
            return Paper.book(name).read(PAPER_GET_MESSAGE_RESPONSE_MAP+channelId, new FuguGetMessageResponse());
        } catch (Exception e) {
            return new FuguGetMessageResponse();
        }
    }

    public static void removeMessageResponse(Integer channelId) {
        Paper.book(name).delete(PAPER_GET_MESSAGE_RESPONSE_MAP+channelId);
    }


    public static FuguColorConfig getColorConfig() {

        if (COLOR_CONFIG == null) {
            COLOR_CONFIG = Paper.book(name).read(PAPER_COLOR_CONFIG, null);
        }
        return COLOR_CONFIG;
    }

    /**
     * Save PAPER_CONVERSATION_LIST
     *
     * @param conversationList
     */

    public static void setConversationList(List<FuguConversation> conversationList) {
        CommonData.CONVERSATION_LIST = conversationList;
        Paper.book(name).write(PAPER_CONVERSATION_LIST, conversationList);
    }

    /**
     * Gets PAPER_CONVERSATION_LIST
     *
     * @return the conversationList
     */

    public static List<FuguConversation> getConversationList() {
        CONVERSATION_LIST = Paper.book(name).read(PAPER_CONVERSATION_LIST, Collections.<FuguConversation>emptyList());
        return CONVERSATION_LIST;
    }


    // Unsent messages as JSONObject
    public static void setUnsentMessageMapByChannel(int channelId, LinkedHashMap<String, JSONObject> unsentMessageMap){
        Paper.book(name).write(PAPER_UNSENT_MESSAGE_MAP+channelId, unsentMessageMap);
    }

    public static void removeUnsentMessageMapChannel(Integer channelId) {
        Paper.book(name).delete(PAPER_UNSENT_MESSAGE_MAP+channelId);
    }

    public static LinkedHashMap<String, JSONObject> getUnsentMessageMapByChannel(Integer channelId) {
        return Paper.book(name).read(PAPER_UNSENT_MESSAGE_MAP+channelId, new LinkedHashMap<String, JSONObject>());
    }
    // Unsent messages as JSONObject ended

    public static void setUnsentMessageByChannel(Integer channelId, LinkedHashMap<String, Message> unsentMessage) {
        Paper.book(name).write(PAPER_UNSENT_MESSAGES+channelId, unsentMessage);

    }

    public static void removeUnsentMessageChannel(Integer channelId) {
        Paper.book(name).delete(PAPER_UNSENT_MESSAGES+channelId);
    }

    public static LinkedHashMap<String, Message> getUnsentMessageByChannel(Integer channelId) {
        return Paper.book(name).read(PAPER_UNSENT_MESSAGES+channelId, new LinkedHashMap<String, Message>());
    }

    //Unsent messages as Object ended


    //Sent messages
    public static void addExistingMessages(Integer channelId, LinkedHashMap<String, Message> sentMessage) {
        LinkedHashMap<String, Message> allSentMessages = getSentMessageByChannel(channelId);
        allSentMessages.putAll(sentMessage);
        setSentMessageByChannel(channelId, allSentMessages);
    }

    public static void setSentMessageByChannel(Integer channelId, LinkedHashMap<String, Message> sentMessage) {
        Paper.book(name).write(PAPER_SENT_MESSAGES+channelId, sentMessage);
    }

    public static void removeSentMessageChannel(Integer channelId) {
        Paper.book(name).delete(PAPER_SENT_MESSAGES+channelId);
    }

    public static LinkedHashMap<String, Message> getSentMessageByChannel(Integer channelId) {
        return Paper.book(name).read(PAPER_SENT_MESSAGES+channelId, new LinkedHashMap<String, Message>());
    }

    //Sent messages ended


    public static void setIsBkUser(boolean bkUser) {
        Paper.book(name).write(PAPER_BK_USER, bkUser);
    }

    public static boolean isBkUser() {
        return Paper.book(name).read(PAPER_BK_USER, false);
    }

    public static HashMap<Integer, ArrayList<Integer>> getAllNotificationChannels() {
        return Paper.book(name).read(PAPER_NOTIFICATION, new HashMap<Integer, ArrayList<Integer>>());
    }

    public static ArrayList<Integer> getNotificationArray(Integer channelId) {
        HashMap<Integer, ArrayList<Integer>> hashMap = getAllNotificationChannels();
        return hashMap.get(channelId);
    }

    public static void saveNotificationId(Integer channelId, Integer notificationChannel) {
        ArrayList<Integer> ids = getNotificationArray(channelId);
        if(ids == null || ids.size()==0)
            ids = new ArrayList<>();

        ids.add(notificationChannel);
        HashMap<Integer, ArrayList<Integer>> hashMap = getAllNotificationChannels();
        hashMap.put(channelId, ids);
        Paper.book(name).write(PAPER_NOTIFICATION, hashMap);
    }

    public static void removeNotificationChannel(Integer channelId) {
        try {
            HashMap<Integer, ArrayList<Integer>> hashMap = getAllNotificationChannels();
            if(hashMap.containsKey(channelId)) {
                hashMap.remove(channelId);
                Paper.book(name).write(PAPER_NOTIFICATION, hashMap);
            }
        } catch (Exception e) {

        }
    }

    public static void removeAllNotificationChannel() {
        Paper.book(name).delete(PAPER_NOTIFICATION);
    }

    //======================================== Clear UserData ===============================================

    /**
     * Delete paper.
     */
    public static void clearData() {
        CONVERSATION_LIST = Collections.emptyList();
        Paper.book(name).destroy();
        try {
            Paper.book().destroy();
        } catch (Exception e) {

        }
    }

    public static String getProvider() {
        return HippoConfig.getInstance().getAttributes().getProvider();
    }

    public static CopyOnWriteArraySet<Integer> getPushChannelID() {
        return Paper.book(name).read(PAPER_HIPPO_PUSH_CHANNEL_ID, new CopyOnWriteArraySet<Integer>());
    }

    public static void savePushChannels(CopyOnWriteArraySet<Integer> arrayList) {
        Paper.book(name).write(PAPER_HIPPO_PUSH_CHANNEL_ID, arrayList);
    }

    public static void savePushChannelID(int channelId) {
        CopyOnWriteArraySet<Integer> arrayList = getPushChannelID();
        if(arrayList == null)
            arrayList = new CopyOnWriteArraySet<>();

        Integer integer = channelId;
        arrayList.add(integer);
        Paper.book(name).write(PAPER_HIPPO_PUSH_CHANNEL_ID, arrayList);
    }

    public static String getCallStatus() {
        return Paper.book(name).read(PAPER_CALL_STATUS);
    }

    public static void setCallStatus(String callStatus) {
        Paper.book(name).write(PAPER_CALL_STATUS, callStatus);
    }

    public static JsonObject deviceDetails(Context context) {
        Gson gson = new GsonBuilder().create();
        JsonObject deviceDetailsJson = null;
        try {
            deviceDetailsJson = gson.toJsonTree(new DeviceDetails(getAppVersion(context)).getDeviceDetails())
                    .getAsJsonObject();
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return deviceDetailsJson;
    }


    public static int getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void setCallAnswered(boolean b) {
        Paper.book(name).write("hippo_call_answer", b);
    }

    public static boolean isCallAnswered() {
        return Paper.book(name).read("hippo_call_answer", false);
    }

    public static void saveDeepLinkURI(String uridata) {
        Paper.book(name).write("hippo_deeplink_uri", uridata);
    }

    public static String getDeepLinkURI() {
        return Paper.book(name).read("hippo_deeplink_uri");
    }

    public static void clearDeepLinkData() {
        Paper.book(name).delete("hippo_deeplink_uri");
    }

    public static String getUserCountryCode() {
        return Paper.book(name).read("hippo_country_code", "");
    }

    public static String getUserContCode() {
        return Paper.book(name).read("hippo_cont_code", "");
    }

    public static void setUserCountryCode(String userCountryCode) {
        Paper.book(name).write("hippo_country_code", userCountryCode);
    }

    public static void setUserContCode(String userContCode) {
        Paper.book(name).write("hippo_cont_code", userContCode);
    }

    public static void setTime(String timeStamp) {
        Paper.book(name).write("hippo_time_stamp", timeStamp);
    }

    public static String getTime() {
        return Paper.book(name).read("hippo_time_stamp");
    }

    public static void setImageMuid(String imageMuid) {
        Paper.book(name).write("hippo_image_muid", imageMuid);
    }

    public static String getImageMuid() {
        return Paper.book(name).read("hippo_image_muid");
    }

    public static void setFayeListener(boolean b) {
        Paper.book(name).write("reset_faye_listener", b);
    }

    public static boolean isListenerReset() {
        return Paper.book(name).read("reset_faye_listener", false);
    }

    public static void saveVersionInfo(VersionUpdate update) {
        Paper.book(name).write(PAPER_VERSION_CHECK, update);
    }

    public static VersionUpdate getVersionInfo() {
        try {
            return Paper.book(name).read(PAPER_VERSION_CHECK, null);
        } catch (Exception e) {
            return null;
        }
    }

    public static int getInstallType() {
        return Paper.book(name).read("installType", 0);
    }

    public static void saveInstallType(int installType) {
        Paper.book(name).write("installType", installType);
    }

    //private static LinkedHashMap<Integer, String> typedMessages = new LinkedHashMap<>();
    public static TreeMap<Integer, String> typedMessages = new TreeMap<>();

    public static void saveTypedMessage(int channelId, String message) {
        try {

            if(TextUtils.isEmpty(message)) {
                typedMessages.remove(channelId);
                Paper.book(name).write(PAPER_TYPED_MSG, typedMessages);
                Log.e("channelId", channelId+" *********** "+new Gson().toJson(typedMessages));
            } else {
                typedMessages.put(channelId, message);
                Paper.book(name).write(PAPER_TYPED_MSG, typedMessages);
                Log.e("channelId", channelId+" <------> "+message+" *********** "+new Gson().toJson(typedMessages));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getTypedMessage(int channelId) {
        try {
            if(typedMessages == null || typedMessages.size() == 0)
                typedMessages = Paper.book(name).read(PAPER_TYPED_MSG, new TreeMap<>());
            Log.e("channelId", channelId+" = "+new Gson().toJson(typedMessages));
            return typedMessages.get(channelId);
        } catch (Exception e) {
            typedMessages = new TreeMap<>();
            return "";
        }
    }

    public static void saveAttributes(HippoConfigAttributes configAttributes) {
        Paper.book(name).write("configAttributes", configAttributes);
    }

    public static HippoConfigAttributes getConfigAttributes() {
        return Paper.book(name).read("configAttributes");
    }


    // for SDK use
    // Handle unread count w.r.t user unique key.
    public static HashMap<String, UnreadCountData> getUnreadCount() {
        UNREAD_COUNT = Paper.book(name).read(PAPER_AGENT_UNREAD_COUNT, new HashMap<String, UnreadCountData>());
        return UNREAD_COUNT;
    }

    public static void addAllUnreadCount(HashMap<String, UnreadCountData> hashMap) {
        Paper.book(name).write(PAPER_AGENT_UNREAD_COUNT, hashMap);
    }

    public static UnreadCountData getUnreadCount(String userUniqueKey) {
        return getUnreadCount().get(userUniqueKey);
    }


    public static HashMap<String, UnreadCountData> addUnreadCount(String userUniqueKey, UnreadCountData unreadCountData) {
        UNREAD_COUNT = getUnreadCount();
        UNREAD_COUNT.put(userUniqueKey, unreadCountData);
        Paper.book(name).write(PAPER_AGENT_UNREAD_COUNT, UNREAD_COUNT);
        return UNREAD_COUNT;
    }

    public static HashMap<String, UnreadCountData> removeUnreadCount(String userUniqueKey) {
        UNREAD_COUNT = getUnreadCount();
        UNREAD_COUNT.remove(userUniqueKey);
        Paper.book(name).write(PAPER_AGENT_UNREAD_COUNT, UNREAD_COUNT);
        return UNREAD_COUNT;
    }

    public static void clearUnreadCount() {
        Paper.book(name).delete(PAPER_AGENT_UNREAD_COUNT);
    }


    //For Agent Total Unread Count
    public static HashMap<Integer, Integer> getTotalUnreadCount() {
        TOTAL_UNREAD_COUNT = Paper.book(name).read(PAPER_AGENT_TOTAL_UNREAD_COUNT, new HashMap<Integer, Integer>());
        return TOTAL_UNREAD_COUNT;
    }

    public static void addTotalUnreadCount(HashMap<Integer, Integer> hashMap) {
        Paper.book(name).write(PAPER_AGENT_TOTAL_UNREAD_COUNT, hashMap);
    }

    public static Integer getTotalUnreadCount(Integer channelId) {
        return getTotalUnreadCount().get(channelId);
    }

    public static HashMap<Integer, Integer> addTotalUnreadCount(Integer channelId, Integer count) {
        TOTAL_UNREAD_COUNT = getTotalUnreadCount();
        TOTAL_UNREAD_COUNT.put(channelId, count);
        Paper.book(name).write(PAPER_AGENT_TOTAL_UNREAD_COUNT, TOTAL_UNREAD_COUNT);
        return TOTAL_UNREAD_COUNT;
    }

    public static HashMap<Integer, Integer> removeTotalUnreadCount(Integer channelId) {
        TOTAL_UNREAD_COUNT = getTotalUnreadCount();
        TOTAL_UNREAD_COUNT.remove(channelId);
        Paper.book(name).write(PAPER_AGENT_TOTAL_UNREAD_COUNT, TOTAL_UNREAD_COUNT);
        return TOTAL_UNREAD_COUNT;
    }

    public static void clearTotalUnreadCount() {
        Paper.book(name).delete(PAPER_AGENT_TOTAL_UNREAD_COUNT);
    }



    public static ArrayList<String> getAgentUniqueKey() {
        return Paper.book(name).read(SPLabels.AGENT_LIST, null);
    }

    public static void setAgentUniqueKey(ArrayList<String> strings) {
        Paper.book(name).write(SPLabels.AGENT_LIST, strings);
    }

    public static void saveLangKeys(Translation translation) {
        Paper.book(name).write("hippo_lang_keys", translation);
    }

    public static Translation getLangKeys() {
        return Paper.book(name).read("hippo_lang_keys", new Translation());
    }

    public static String getCurrentLanguage() {
        return Paper.book(name).read("hippo_current_lang", "");
    }

    public static void saveCurrentLang(String lang) {
        Paper.book(name).write("hippo_current_lang", lang);
    }

    private static HashMap<String, GroupCallData> GROUP_CALL_DATA = new HashMap<>();
    public static void saveGroupCall(String transactionId, GroupCallData callResponse) {
        GROUP_CALL_DATA = getAllGroupCallData();
        GROUP_CALL_DATA.put(transactionId, callResponse);
        Paper.book(name).write("hippo_group_call_data", GROUP_CALL_DATA);
    }

    public static GroupCallData getGroupData(String transactionId) {
        GROUP_CALL_DATA = getAllGroupCallData();
        return GROUP_CALL_DATA.get(transactionId);
    }

    public static GroupCallData deleteGroupData(String transactionId) {
        GROUP_CALL_DATA = getAllGroupCallData();
        GROUP_CALL_DATA.remove(transactionId);
        return GROUP_CALL_DATA.get(transactionId);
    }

    private static HashMap<String, GroupCallData> getAllGroupCallData() {
        return Paper.book(name).read("hippo_group_call_data", new HashMap<String, GroupCallData>());
    }
}
