package com.hippoagent.apis

import android.app.Activity
import android.text.TextUtils
import com.hippoagent.HippoApplication
import com.hippoagent.HippoConfig
import com.hippoagent.callback.OnPaymentDialogListener
import com.hippoagent.model.PaymentData
import com.hippoagent.model.payment.EditPaymentRequest
import com.hippoagent.model.payment.PlanData
import com.hippoagent.model.payment.SavedPlanResponse
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient

/**
 * Created by gurmail on 29/07/20.
 * @author gurmail
 */
object PaymentPlan {

    fun savePlan(data: ArrayList<PaymentData>, planData: PlanData?, planName: String) {
        val paymentData1 = java.util.ArrayList<PaymentData>()
        for (a in data) {
            val data = PaymentData()
            data.amount = a.amount
            data.currency = a.currency
            data.currencySymbol = a.currencySymbol
            data.description = a.description
            data.id = a.id
            data.title = a.title
            paymentData1.add(data)
        }

        var updatePlan: EditPaymentRequest = EditPaymentRequest()
        updatePlan.access_token = HippoApplication.getInstance().userData.accessToken
        updatePlan.plan_name = planName
        updatePlan.payment_plans = paymentData1
        updatePlan.type = 1

        if (planData != null) {
            updatePlan.plan_id = planData.planId
            updatePlan.operation_type = 1
        } else {
            updatePlan.plan_id = null
            updatePlan.operation_type = null
        }


        RestClient.getApiInterface().editPaymentLinks(updatePlan).enqueue(object : ResponseResolver<SavedPlanResponse>() {
            override fun success(t: SavedPlanResponse?) {

                //getSavedCard()
            }

            override fun failure(error: APIError?) {

            }
        })
    }

    fun editPlan(activity: Activity, data: ArrayList<PaymentData>, planData: PlanData?, planName: String, listener: OnPaymentDialogListener) {
        val paymentData1 = java.util.ArrayList<PaymentData>()
        for (a in data) {
            val data = PaymentData()
            data.amount = a.amount
            data.currency = a.currency
            data.currencySymbol = a.currencySymbol
            data.description = a.description
            data.id = a.id
            data.title = a.title
            paymentData1.add(data)
        }

        var updatePlan: EditPaymentRequest = EditPaymentRequest()
        updatePlan.access_token = HippoApplication.getInstance().userData.accessToken
        updatePlan.plan_name = planName
        updatePlan.payment_plans = paymentData1
        updatePlan.type = 1

        if (planData != null) {
            updatePlan.plan_id = planData.planId
            updatePlan.operation_type = 1
        } else {
            updatePlan.plan_id = null
            updatePlan.operation_type = null
        }


        RestClient.getApiInterface().editPaymentLinks(updatePlan).enqueue(object : ResponseResolver<SavedPlanResponse>(activity, true, false) {
            override fun success(t: SavedPlanResponse?) {
                listener?.onPaymentUpdate()
                //getSavedCard()
            }

            override fun failure(error: APIError?) {
                listener?.onPlanDeleteError(error?.message)
            }
        })
    }

    fun deletePlan(activity: Activity, position: Int, planData: PlanData, listener: OnPaymentDialogListener) {
        val updatePlan: EditPaymentRequest = EditPaymentRequest()
        updatePlan.access_token = HippoApplication.getInstance().userData.accessToken
        updatePlan.plan_id = planData.planId
        updatePlan.operation_type = 2
        if (!TextUtils.isEmpty(HippoConfig.getInstance().currentLanguage))
            updatePlan.setLang(HippoConfig.getInstance().currentLanguage)

        RestClient.getApiInterface().editPaymentLinks(updatePlan).enqueue(object : ResponseResolver<SavedPlanResponse>(activity, true, true) {
            override fun success(t: SavedPlanResponse?) {
                listener?.onPlanDeleted(position)
                /*plansList.removeAt(position)
                adapter.notifyItemRemoved(position)

                if(plansList == null || plansList?.size == 0) {
                    recyclerView.visibility = View.GONE
                    add_plan_layout.visibility = View.VISIBLE
                } else {
                    recyclerView.visibility = View.VISIBLE
                    add_plan_layout.visibility = View.GONE
                }*/
            }

            override fun failure(error: APIError?) {
                listener?.onPlanDeleteError(error?.message)
            }
        })
    }

}