package com.hippoagent.apis

import com.hippoagent.BuildConfig
import com.hippoagent.HippoApplication
import com.hippoagent.HippoConfig
import com.hippoagent.UnreadCountHelper
import com.hippoagent.database.CommonData
import com.hippoagent.model.GetConversationResponse
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParamsObj
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.Constants
import java.util.*

/**
 * Created by gurmail on 2020-05-18.
 * @author gurmail
 */
object Conversation {

    fun getAllConversation() {
        val params = HashMap<String, Any>()
        params[Constants.ACCESS_TOKEN] = HippoApplication.getInstance().userData.accessToken.toString()
        params[Constants.CHANNEL_STATUS] = "[1]"
        params[Constants.DEVICE_TYPE] = Constants.ANDROID
        params[Constants.APP_VERSION] = BuildConfig.VERSION_CODE
        params[Constants.PAGE_OFFSET] = 1
        params[Constants.ROW_COUNT] = 20
        params["fetch_all_chats"] = true

        val paramsObj = CommonParamsObj.Builder()
                .addAll(params)
                .build()

        RestClient.getApiInterface().getConversation(paramsObj.map).enqueue(object: ResponseResolver<GetConversationResponse>(){
            override fun success(getConversationResponse: GetConversationResponse?) {
                try {
                    val hashMap = CommonData.getTotalUnreadCount()
                    var totalCount = 0
                    for (conversation in getConversationResponse?.data?.conversation!!) {
                        hashMap[conversation.channelId] = conversation.unreadCount
                        totalCount += conversation.unreadCount
                    }

                    CommonData.addTotalUnreadCount(hashMap)
                    if (HippoConfig.getInstance().getCallbackListener() != null) {
                        HippoConfig.getInstance().getCallbackListener().count(totalCount, hashMap.values.size)
                    }
                } catch (e: Exception) {
                }

            }

            override fun failure(error: APIError?) {

            }

        })
    }
}