package com.hippoagent.adapters;

import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.hippoagent.R;
import com.hippoagent.model.LoginResponse.Tag;

import java.util.ArrayList;

/**
 * Created by gurmail on 17/05/19.
 *
 * @author gurmail
 */
public class ShowTagsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ShowTagsListener tagsListener;
    private ArrayList<Tag> tagListAdapter;

    public ShowTagsAdapter(ArrayList<Tag> tagListAdapter, ShowTagsListener tagsListener) {
        this.tagsListener = tagsListener;
        this.tagListAdapter = tagListAdapter;
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item_tags, parent, false);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder viewholder, final int position) {
        if (viewholder instanceof ViewHolder) {
            ViewHolder holder = (ViewHolder) viewholder;
            final Tag tags = tagListAdapter.get(position);
            holder.tvLabel.setTag(position);
            holder.tvLabel.setText(tags.getTagName());

            // Initialize a new GradientDrawable
            GradientDrawable gd = new GradientDrawable();

            // Specify the shape of drawable
            gd.setShape(GradientDrawable.RECTANGLE);

            // Set the fill color of drawable
            gd.setColor(Color.parseColor(tags.getColorCode())); // make the background transparent

            // Create a 2 pixels width red colored border for drawable
            gd.setStroke(2, Color.parseColor(tags.getColorCode())); // border width and color

            // Make the border rounded
            gd.setCornerRadius(15.0f); // border corner radius

            // Finally, apply the GradientDrawable as TextView background
            holder.tvLabel.setBackground(gd);


            //holder.tvLabel.setBackgroundColor(Color.parseColor(tags.getColorCode()));
            if (tags.getStatus() == 1) {
                holder.tvLabel.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.ic_single_tick_white, 0);
            } else {
                holder.tvLabel.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            }
            holder.tvLabel.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (tags.getStatus() == 1) {
                        tagListAdapter.get(position).setStatus(0);
                    } else {
                        tagListAdapter.get(position).setStatus(1);
                    }
                    tagsListener.onAssignTags(tags, tags.getStatus() == 1 ? 1 : 0);
                    notifyItemChanged(position);
                    //notifyDataSetChanged();
                }
            });
        }
    }

    @Override
    public int getItemCount() {
        if (tagListAdapter == null || tagListAdapter.size() == 0) {
            return 0;
        } else {
            return tagListAdapter.size();
        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        public TextView tvLabel;

        public ViewHolder(final View itemView) {
            super(itemView);
            tvLabel = itemView.findViewById(R.id.tvLabel);
        }
    }

    public interface ShowTagsListener {
        void onAssignTags(Tag tags, int i);
    }
}
