package com.hippoagent.adapters;

import android.content.Context;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.databinding.LayoutLoadmoreBinding;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.conversation_search.User;

import java.util.ArrayList;
import java.util.List;

public class PeopleAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Context context;
    private List<User> peopleData = new ArrayList<>();
    private PeopleClickListener peopleClickListener;
    private Integer totalItemCount;

    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        context = parent.getContext();
        if (viewType == VIEW_TYPE_LOADING) {
            return new LoadMoreHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_loadmore, parent, false));
        } else {
            return new FuguTagging(LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item_people, parent, false));
        }
    }

    public PeopleAdapter(List<User> peopleData, PeopleClickListener peopleClickListener) {
        this.peopleData = peopleData;
        this.peopleClickListener = peopleClickListener;
    }

    @Override
    public void onBindViewHolder(final RecyclerView.ViewHolder holder, final int position) {
        if (holder instanceof FuguTagging) {
            final FuguTagging holder1 = (FuguTagging) holder;
            holder1.tvPersonName.setText(peopleData.get(position).getFullName());
            holder1.tvPersonPhone.setText(peopleData.get(position).getPhoneNumber());
            holder1.tvPersonEmail.setText(peopleData.get(position).getEmail());
            if (HippoApplication.getInstance().getUserData().getBusinessProperty().getEnableAgentCustomerChat().equalsIgnoreCase("1")) {
                holder1.tvNewChat.setVisibility(View.VISIBLE);
            } else {
                holder1.tvNewChat.setVisibility(View.GONE);
            }
        } else if (holder instanceof LoadMoreHolder) {
            final LoadMoreHolder holder2 = (LoadMoreHolder) holder;
            holder2.loadmoreBinding.progressWheel.setVisibility(View.GONE);
            holder2.loadmoreBinding.tvLoadmore.setVisibility(View.VISIBLE);
        }
    }

    @Override
    public int getItemCount() {
        if (peopleData == null || peopleData.size() == 0) {
            return 0;
        } else {
            if (totalItemCount > peopleData.size()) {
                return peopleData.size() + 1;
            } else {
                return peopleData.size();
            }
        }
    }

    @Override
    public int getItemViewType(int position) {
        try {
            if (isPositionFooter(position)) {
                return VIEW_TYPE_LOADING;
            }
            return VIEW_TYPE;
        } catch (Exception e) {
            return VIEW_TYPE;
        }
    }

    private boolean isPositionFooter(int position) {
        return position == peopleData.size();
    }

    public void setData(ArrayList<User> peopleData, int totalItemCount) {
        this.peopleData = peopleData;
        this.totalItemCount = totalItemCount;
        notifyDataSetChanged();
    }

    class FuguTagging extends RecyclerView.ViewHolder {
        private TextView tvNewChat, tvPersonEmail, tvPersonPhone, tvPersonName;
        private LinearLayout llMain;

        public FuguTagging(View itemView) {
            super(itemView);
            tvNewChat = itemView.findViewById(R.id.tvNewChat);
            tvPersonEmail = itemView.findViewById(R.id.tvPersonEmail);
            tvPersonPhone = itemView.findViewById(R.id.tvPersonPhone);
            tvPersonName = itemView.findViewById(R.id.tvPersonName);
            llMain = itemView.findViewById(R.id.llMain);
            tvNewChat.setText(Restring.getString(context, R.string.hippo_new_chat));

            llMain.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    peopleClickListener.onItemClick(peopleData.get(getAdapterPosition()));
                }
            });

            tvNewChat.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    Conversation conversation = new Conversation();
                    conversation.setChannelId(-5);
                    conversation.setChannelName("dummyChannelName");
                    conversation.setStatus(-2);
                    conversation.setAgentId(-2);
                    conversation.setUserId(peopleData.get(getAdapterPosition()).getUserId());
                    conversation.setLabel(peopleData.get(getAdapterPosition()).getFullName());
                    conversation.setUnreadCount(0);
                    peopleClickListener.onNewChatClick(conversation);
                }
            });
        }
    }

    public class LoadMoreHolder extends RecyclerView.ViewHolder {
        private LayoutLoadmoreBinding loadmoreBinding;

        public LoadMoreHolder(View itemView) {
            super(itemView);
            loadmoreBinding = DataBindingUtil.bind(itemView);
            loadmoreBinding.rlMainLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    peopleClickListener.onLoadMoreClick();
                }
            });
        }
    }

    public interface PeopleClickListener {
        void onItemClick(User datum);
        void onNewChatClick(Conversation conversation);
        void onLoadMoreClick();
    }
}

