package com.hippoagent.adapters;

import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.model.response_modals.Datum;
import com.hippoagent.model.response_modals.GiffyResponse;
import com.hippoagent.utils.LoadImageFile;

import java.util.ArrayList;

/**
 * Created by harsh on 29/09/17.
 */

public class GiffyAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private FuguChatActivity fuguChatActivity;
    private ArrayList<Datum> giffyResponseList = new ArrayList<>();
    private Callback callback;

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.giffy_view_layout, parent, false);
        return null;
    }

    public GiffyAdapter(FuguChatActivity fuguChatActivity, ArrayList<Datum> giffyResponses, Callback callback) {
        this.fuguChatActivity = fuguChatActivity;
        this.giffyResponseList = giffyResponses;
        this.callback = callback;
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        final Giffy holder1 = (Giffy) holder;
        LoadImageFile.getInstance().loadImage(fuguChatActivity, giffyResponseList.get(position).getUser().getBannerUrl(), holder1.gvGiff);
//        Glide.with(fuguChatActivity).load(giffyResponseList.get(position).getUser().getBannerUrl()).into(holder1.gvGiff);
    }

    @Override
    public int getItemCount() {
        return giffyResponseList.size();
    }

    class Giffy extends RecyclerView.ViewHolder {
        private ImageView gvGiff;

        public Giffy(View view) {
            super(view);
            gvGiff = (ImageView) view.findViewById(R.id.gvGiff);
        }
    }

    public interface Callback {
        void onClick(GiffyResponse giffyResponse);
    }
}
