package com.hippoagent.adapters;

import android.content.Context;
import androidx.databinding.DataBindingUtil;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.hippoagent.R;
import com.hippoagent.databinding.LayoutBroadcastItemHistoryBinding;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.BroadCastObjectModel;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.ProgressBarDisplayRunnable;
import com.hippoagent.utils.Utils;

import java.util.ArrayList;

/**
 * Created by gurmail on 12/02/19.
 *
 * @author gurmail
 */
public class BroadcastListAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private static final String TAG = BroadcastListAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<BroadCastObjectModel> arrayList = new ArrayList<>();
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private RecyclerView recyclerView;
    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm aa";
    private OnItemClickListener onItemClickListener;

    public BroadcastListAdapter(RecyclerView recyclerView, OnItemClickListener onItemClickListener) {
        this.recyclerView = recyclerView;
        this.onItemClickListener = onItemClickListener;
    }

    public void setData(ArrayList<BroadCastObjectModel> arrayList) {
        this.arrayList = arrayList;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        context = parent.getContext();
        if(viewType == VIEW_TYPE_LOADING) {
            return new LoadMoreHolder(LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_loaddata, parent, false));
        } else {
            return new ViewHolder(LayoutInflater.from(context)
                    .inflate(R.layout.layout_broadcast_item_history, parent, false));
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if(holder instanceof ViewHolder) {
            ViewHolder viewHolder = (ViewHolder) holder;
            BroadCastObjectModel objectModel = arrayList.get(position);
            viewHolder.historyBinding.textViewFromValue.setText(objectModel.getFullName());
            String localDate = DateUtils.getInstance().convertToLocal(objectModel.getCreatedAt(), STANDARD_DATE_FORMAT_TZ, OUTPUT_FORMAT);
            viewHolder.historyBinding.textViewDateValue.setText(localDate);
            viewHolder.historyBinding.textViewTitleValue.setText(objectModel.getBroadcastTitle());
            Utils.setColor(context, viewHolder.historyBinding.textViewMsgValue, objectModel.getMessage());
            if(!TextUtils.isEmpty(objectModel.getFallbackText())) {
                viewHolder.historyBinding.textViewFallbackValue.setText(objectModel.getFallbackText());
                viewHolder.historyBinding.rlFallback.setVisibility(View.VISIBLE);
            } else {
                viewHolder.historyBinding.rlFallback.setVisibility(View.GONE);
            }

            if(!TextUtils.isEmpty(objectModel.getBroadcastType())) {
                viewHolder.historyBinding.layoutType.setVisibility(View.VISIBLE);
                if(objectModel.getBroadcastType().equalsIgnoreCase("email")) {
                    viewHolder.historyBinding.textViewTypeValue.setText(Restring.getString(context, R.string.email));
                } else {
                    viewHolder.historyBinding.textViewTypeValue.setText(Restring.getString(context, R.string.hippo_in_app));
                }
            } else {
                viewHolder.historyBinding.layoutType.setVisibility(View.GONE);
            }

            viewHolder.historyBinding.textViewFrom.setText(Restring.getString(context, R.string.hippo_sender_name));
            viewHolder.historyBinding.textViewDate.setText(Restring.getString(context, R.string.hippo_date));
            viewHolder.historyBinding.textViewTitle.setText(Restring.getString(context, R.string.hippo_title));
            viewHolder.historyBinding.textViewFallback.setText(Restring.getString(context, R.string.hippo_fallback_name));
            viewHolder.historyBinding.textViewMsg.setText(Restring.getString(context, R.string.hippo_message));
            viewHolder.historyBinding.textViewType.setText(Restring.getString(context, R.string.hippo_broadcast_type));

        }
    }


    @Override
    public int getItemCount() {
        return arrayList == null ? 0 : arrayList.size();
    }

    @Override
    public int getItemViewType(int position) {
        try {
            if(arrayList.get(position).getChannelId().equals(-1)) {
                return VIEW_TYPE_LOADING;
            } else {
                return VIEW_TYPE;
            }
        } catch (Exception e) {
            return VIEW_TYPE;
        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private LayoutBroadcastItemHistoryBinding historyBinding;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            historyBinding = DataBindingUtil.bind(itemView);
            historyBinding.relative.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(onItemClickListener != null)
                        onItemClickListener.onClickItem(getAdapterPosition());
                }
            });
        }
    }

    public class LoadMoreHolder extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);
//            loadmoreBinding = DataBindingUtil.bind(itemView);
        }
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        if(arrayList == null || arrayList.size() == 0)
            return;

        boolean isProgressBarExist = arrayList.get(arrayList.size() - 1).getChannelId() != null
                && arrayList.get(arrayList.size() - 1).getChannelId().intValue() == -1;
        if(show) {
            if (!isProgressBarExist) {
                arrayList.add(ProgressBarModel.getInstance());
                if(notifyAdapter){
                    recyclerView.post(getProgressDisplayRunnable(true, arrayList.size()));
                }
            }
        }else{
            if(arrayList.remove(ProgressBarModel.getInstance())){
                if(notifyAdapter){
                    recyclerView.post(getProgressDisplayRunnable(false, arrayList.size()));
                }
            }

        }

    }
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;
    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position){
        if(progressBarDisplayRunnable == null){
            progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        progressBarDisplayRunnable.setInsert(isInsert);
        progressBarDisplayRunnable.setPosition(position);

        return progressBarDisplayRunnable;
    }


    private static class ProgressBarModel {
        private static BroadCastObjectModel progressBarModel;
        private ProgressBarModel() {
        }
        public static BroadCastObjectModel getInstance(){
            if(progressBarModel ==null)
                progressBarModel = new BroadCastObjectModel(-1);
            return progressBarModel;
        }
    }

//    public String getBtnString(Context context, String text) {
//        String msg = text.replace("{{{full_name}}}", "@");
//        String[] data = msg.split("@");
//
//        if(data.length>1) {
//
//            String first = data[0];
//            String name = "First Name";
//            String last = data[1];
//
//            String finalmsg = first+name+last;
//
//            SpannableStringBuilder title = new SpannableStringBuilder(finalmsg);
//
//            final StyleSpan boldTitleSpan = new StyleSpan(android.graphics.Typeface.BOLD);
//            final RelativeSizeSpan relativeValidDateSpan = new RelativeSizeSpan(2.2f);
//            final ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(ContextCompat.getColor(context, R.color.colorPrimary));
//
//            title.setSpan(boldTitleSpan, finalmsg.indexOf(name), finalmsg.indexOf(name)+name.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
//            title.setSpan(relativeValidDateSpan, finalmsg.indexOf(name), finalmsg.indexOf(name)+name.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
//            title.setSpan(foregroundColorSpan, finalmsg.indexOf(name), finalmsg.indexOf(name)+name.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
//
//            return title.toString();
//        }
//        return text;
//    }
}
