package com.hippoagent.activities;

import android.content.Intent;
import android.os.Bundle;
import androidx.appcompat.widget.Toolbar;
import android.view.View;

import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.appData.UserOnBoard;
import com.hippoagent.database.CommonData;
import com.hippoagent.eventbus.BusConstant;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.eventbus.ProfileData;
import com.hippoagent.fragments.ChangePasswordFragment;
import com.hippoagent.fragments.EditProfileFragment;
import com.hippoagent.fragments.EditProfileFragmentNew;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.SPLabels;
import com.hippoagent.utils.filelogger.Logger;
import com.google.gson.Gson;

import java.util.HashMap;

import io.paperdb.Paper;

import static com.hippoagent.appData.AppManager.USER_ONBOARD_HASCLASS;
import static com.hippoagent.appData.AppManager.USER_ONBOARD_VALUE;

/**
 * Created by gurmail on 2019-12-31.
 *
 * @author gurmail
 */
public class ProfileActivityName extends FuguBaseActivity implements View.OnClickListener {

    private Toolbar toolbar;

    private int userOnBoardingValue = 0;
    private boolean onboardClassFinish = true;
    private boolean isOpenAnotherFrag = false, isChangePass = false;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_profile);

        toolbar = findViewById(R.id.my_toolbar);
        toolbar.setVisibility(View.GONE);

        if (getIntent().hasExtra(USER_ONBOARD_VALUE)) {
            userOnBoardingValue = getIntent().getIntExtra(USER_ONBOARD_VALUE, 0);
            onboardClassFinish = getIntent().getBooleanExtra(USER_ONBOARD_HASCLASS, true);
        } else if (savedInstanceState != null) {
            userOnBoardingValue = savedInstanceState.getInt(USER_ONBOARD_VALUE, 0);
            onboardClassFinish = savedInstanceState.getBoolean(USER_ONBOARD_HASCLASS, true);
        }

        openScreens(userOnBoardingValue);
    }

    private void openScreens(int userOnBoardingValue) {
        switch (UserOnBoard.get(userOnBoardingValue)) {
            case ONLY_NAME:
                openEditScreenFragment();
                break;
            case ONLY_PASSWORD:
                openPasswordFragment();
                break;
            case BOTH_NAME_PASSWORD:
                openEditScreenFragment();
                break;
            default:
                Bundle bundle = new Bundle();
                if(getIntent().hasExtra("isEditable")) {
                    bundle.putBoolean("isEditable", true);
                }

                if(getIntent().hasExtra("fragment_type")) {
                    if(getIntent().getIntExtra("fragment_type", 0) == 1) {
                        ChangePasswordFragment fragment = new ChangePasswordFragment();
                        getSupportFragmentManager().beginTransaction()
                                .add(R.id.llContainer, fragment, ChangePasswordFragment.class.getName())
                                .commit();
                    }
                } else {
//                    EditProfileFragmentNew fragmentNew = new EditProfileFragmentNew();
//                    fragmentNew.setArguments(bundle);
//
//                    getSupportFragmentManager().beginTransaction()
//                            .add(R.id.llContainer, fragmentNew, EditProfileFragmentNew.class.getName())
//                            .commit();
//
//                    getAgentData();
                }
                break;
        }
    }

    private void openEditScreenFragment() {

        EditProfileFragment editProfileFragment = new EditProfileFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(USER_ONBOARD_VALUE, userOnBoardingValue);
        editProfileFragment.setArguments(bundle);

        setClickBool(true, false);
        getSupportFragmentManager().beginTransaction()
                .replace(R.id.llContainer, editProfileFragment, EditProfileFragment.class.getName())
                .commit();
    }

    private ChangePasswordFragment getChangePasswordFragment() {
        return (ChangePasswordFragment) getSupportFragmentManager().findFragmentByTag(ChangePasswordFragment.class.getName());
    }

    public void openPasswordFragment() {
        setClickBool(true, true);
        getSupportFragmentManager().beginTransaction()
                .replace(R.id.llContainer, ChangePasswordFragment.newInstance(userOnBoardingValue), ChangePasswordFragment.class.getName())
                .commit();
    }

    public void setClickBool(boolean isClicked, boolean isChange) {
        isOpenAnotherFrag = isClicked;
        isChangePass = isChange;
    }

    public void afterAgentOnBoard() {
        HippoApplication.getInstance().getUserData().setAgentOnboardingComplete(0);
        HippoApplication.getInstance().saveUserData(HippoApplication.getInstance().getUserData());
        if (onboardClassFinish) {
            super.onBackPressed();
        } else {
            finish();
            startActivity(new Intent(ProfileActivityName.this, HomeActivity.class));
        }
    }

    @Override
    public void onBackPressed() {
        if (userOnBoardingValue != 0) {

        } else if (isOpenAnotherFrag) {
            Intent intent = new Intent(ProfileActivityName.this, HomeActivity.class);
            startActivity(intent);
            finish();
        } else {
            super.onBackPressed();
        }
    }


    @Override
    public void onClick(View v) {

    }

    public void getAgentData() {
        getAgentData(false);
    }
    public void getAgentData(final boolean flag) {
        HashMap<String, String> params = new HashMap<>();
        params.put(Constants.ACCESS_TOKEN, String.valueOf(HippoApplication.getInstance().getUserData().getAccessToken()));
        params.put(Constants.EN_USER_ID, String.valueOf(HippoApplication.getInstance().getUserData().getEnUserId()));

        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build();

        Logger.INSTANCE.apiRequest("/api/agent/getInfo", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getAgentInfo(commonParams.getMap())
                .enqueue(new ResponseResolver<AgentProfileDetails>(ProfileActivityName.this, !flag, true) {
                    @Override
                    public void success(AgentProfileDetails agentProfileDetails) {
                        Logger.INSTANCE.apiResponse("/api/agent/getInfo", "");
                        try {
                            Paper.book(CommonData.name).delete(SPLabels.AGENT_PROFILE_DATA);
                            Paper.book(CommonData.name).write(SPLabels.AGENT_PROFILE_DATA, agentProfileDetails);

                            HippoApplication.getInstance().getAgentProfileDetails().getData().setUserImage(agentProfileDetails.getData().getUserImage());
                            HippoApplication.getInstance().getUserData().setUserImage(agentProfileDetails.getData().getUserImage());
                            BusProvider.getInstance().post(new ProfileData(BusConstant.ProfileConst.GETDATA, agentProfileDetails));
                        } catch (Exception e) {
                            e.printStackTrace();
                            Logger.INSTANCE.apiFailed("/api/agent/getInfo", e.getLocalizedMessage());
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        Logger.INSTANCE.apiFailed("/api/agent/getInfo", error.getMessage());
                    }

                });
    }
}
