package com.hippoagent.activities

import android.app.Activity
import android.content.DialogInterface
import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AlertDialog
import com.google.gson.Gson
import com.hippoagent.R
import com.hippoagent.fragments.AddCardFragment
import com.hippoagent.fragments.AddPlanFragment
import com.hippoagent.fragments.SavedPlanFragment
import com.hippoagent.langs.Restring
import com.hippoagent.model.PaymentData
import com.hippoagent.model.payment.PlanData
import java.util.*

/**
 * Created by gurmail on 2019-12-05.
 * @author gurmail
 */
class PlansActivity: FuguBaseActivity() {

    var status: Int = 0
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.payment_activity)

        openFragment()
    }

    private fun openFragment() {
        status = 1
        supportFragmentManager.beginTransaction()
                .add(R.id.container, SavedPlanFragment(), SavedPlanFragment::class.java.name)
                .addToBackStack(SavedPlanFragment::class.java.name)
                .commitAllowingStateLoss()
    }


    public fun addOpenSaveFragment() {
        var fragment = AddPlanFragment()
        supportFragmentManager.beginTransaction()
                .add(R.id.container, fragment, AddPlanFragment::class.java.name)
                .addToBackStack(AddPlanFragment::class.java.name)
                .hide(supportFragmentManager.findFragmentByTag(supportFragmentManager
                        .getBackStackEntryAt(supportFragmentManager.backStackEntryCount - 1).name)!!)
                .commitAllowingStateLoss()
    }



    public fun openAddPlanFragment(updatedStatus: Int) {
        editMode = true
        status = updatedStatus
        var fragment = AddPlanFragment()
        val bundle = Bundle()
        bundle.putBoolean("from_saved_plan", true)
        bundle.putBoolean("add_plan", true)
        fragment.arguments = bundle
        supportFragmentManager.beginTransaction()
                .add(R.id.container, fragment, AddPlanFragment::class.java.name)
                .addToBackStack(AddPlanFragment::class.java.name)
                .hide(supportFragmentManager.findFragmentByTag(supportFragmentManager
                        .getBackStackEntryAt(supportFragmentManager.backStackEntryCount - 1).name)!!)
                .commitAllowingStateLoss()
    }

    var editMode: Boolean = false
    public fun editPlanFragment(planData: PlanData, editable: Boolean) {
        if(editable) {
            status = 3
        } else {
            status = 4
        }
        editMode = true
        var fragment = AddPlanFragment()
        val bundle = Bundle()
        bundle.putBoolean("from_saved_plan", true)
        bundle.putBoolean("edit_plan", true)
        bundle.putBoolean("is_editable", editable)
        bundle.putString("data", Gson().toJson(planData))
        fragment.arguments = bundle
        supportFragmentManager.beginTransaction()
                .add(R.id.container, fragment, AddPlanFragment::class.java.name)
                .addToBackStack(AddPlanFragment::class.java.name)
                .hide(supportFragmentManager.findFragmentByTag(supportFragmentManager
                        .getBackStackEntryAt(supportFragmentManager.backStackEntryCount - 1).name)!!)
                .commitAllowingStateLoss()
    }

    override fun onResume() {
        super.onResume()

    }

    override fun onPause() {
        super.onPause()

    }

    override fun onBackPressed() {
        if(status == 1) {
            finish()
        } else {
            super.onBackPressed()
        }
        status = 1;
    }

    public fun onPaymentUpdate() {
        onBackPressed()
        if(getSavedFragment() != null) {
            getSavedFragment()!!.getSavedCard(true)
        }
    }

    fun getSavedFragment(): SavedPlanFragment? {
        return supportFragmentManager.findFragmentByTag(SavedPlanFragment::class.java.name) as SavedPlanFragment?
    }

    override fun onDestroy() {
        super.onDestroy()

    }

    public fun sendPayment(planData: PlanData) {
        val msg = Restring.getString(this, R.string.hippo_send_this_plan)
        val yes = Restring.getString(this, R.string.hippo_yes)
        val no = Restring.getString(this, R.string.hippo_no)
        AlertDialog.Builder(this)
                .setMessage(msg)
                .setPositiveButton(yes) { dialog1: DialogInterface, which: Int ->
                    try {
                        val paymentData = ArrayList<PaymentData>()
                        for (data in planData.plans) {
                            val data1 = PaymentData()
                            data1.transactionId = UUID.randomUUID().toString() + "." + Date().time
                            data1.title = data.title
                            data1.id = data.id
                            data1.description = data.description
                            data1.amount = data.amount
                            data1.currency = data.currency
                            data1.currencySymbol = data.currencySymbol
                            paymentData.add(data1)
                        }
                        sendPaymentRequest(paymentData)

                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }
                .setNegativeButton(no) { dialog1: DialogInterface?, which: Int -> }.show()
    }

    public fun sendPaymentRequest(paymentData: ArrayList<PaymentData> ) {
        editMode = false
        val intent = Intent()
        intent.putExtra("data", paymentData)
        setResult(Activity.RESULT_OK, intent)
        finish()
    }

}