//package com.hippoagent.activities;
//
//import android.os.Bundle;
//import androidx.annotation.Nullable;
//import androidx.appcompat.widget.Toolbar;
//import android.text.TextUtils;
//import android.view.KeyEvent;
//import android.view.View;
//import android.view.WindowManager;
//import android.widget.Button;
//import android.widget.EditText;
//import android.widget.Toast;
//
//import com.hippoagent.R;
//import com.hippoagent.datastructure.ApiResponseFlags;
//import com.hippoagent.model.LoginResponse.LoginResponse;
//import com.hippoagent.retrofit.APIError;
//import com.hippoagent.retrofit.CommonParams;
//import com.hippoagent.retrofit.ResponseResolver;
//import com.hippoagent.retrofit.RestClient;
//import com.hippoagent.utils.Constants;
//import com.hippoagent.utils.filelogger.Logger;
//import com.hippoagent.utils.Log;
//import com.google.gson.Gson;
//
///**
// * Created by ankit on 06/06/17.
// */
//
//public class ForgotPassword extends FuguBaseActivity {
//
//    private Toolbar toolbar;
//    private Button bDone;
//    //private TextInputLayout inputEmail;
//    private EditText etEmail;
//
//    @Override
//    protected void onCreate(@Nullable Bundle savedInstanceState) {
//        super.onCreate(savedInstanceState);
//        setContentView(R.layout.activity_forgot_password);
//
//        toolbar = (Toolbar) findViewById(R.id.toolbar);
//        setSupportActionBar(toolbar);
//        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
//        getSupportActionBar().setDisplayShowTitleEnabled(false);
//
//        bDone = (Button) findViewById(R.id.bDone);
//        //inputEmail = (TextInputLayout) findViewById(R.id.inputEmail);
//        etEmail = (EditText) findViewById(R.id.etEmail);
//
//        bDone.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                submitForm();
//            }
//        });
//
//        etEmail.setOnKeyListener(new View.OnKeyListener() {
//            public boolean onKey(View v, int keyCode, KeyEvent event) {
//                if ((event.getAction() == KeyEvent.ACTION_DOWN) &&
//                        (keyCode == KeyEvent.KEYCODE_ENTER)) {
//                    bDone.performClick();
//                    return true;
//                }
//                return false;
//            }
//        });
//    }
//
//    private void submitForm() {
//        if (!validateEmail()) {
//            return;
//        }
//        apiForgotPassword();
//    }
//
//    private boolean validateEmail() {
//        String email = etEmail.getText().toString().trim();
//
//        if (email.isEmpty() || !isValidEmail(email)) {
//            etEmail.setError(getString(R.string.err_msg_email));
//            requestFocus(etEmail);
//            return false;
//        }
////        if (email.isEmpty() || !isValidEmail(email)) {
////            inputEmail.setError(getString(R.string.err_msg_email));
////            requestFocus(inputEmail);
////            return false;
////        } else {
////            inputEmail.setErrorEnabled(false);
////        }
//        return true;
//    }
//
//    private boolean isValidEmail(String email) {
//        return !TextUtils.isEmpty(email) && android.util.Patterns.EMAIL_ADDRESS.matcher(email).matches();
//    }
//
//    private void requestFocus(View view) {
//        if (view.requestFocus()) {
//            getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE);
//        }
//    }
//
//    private void apiForgotPassword() {
//        if (isNetworkAvailable()) {
//            CommonParams commonParams = new CommonParams.Builder()
//                    .add(Constants.AGENT_EMAIL_ID, etEmail.getText().toString().trim())
//                    .build();
//            Logger.INSTANCE.apiRequest("/api/agent/resetPasswordRequest", new Gson().toJson(commonParams.getMap()));
//            RestClient.getApiInterface().forgotPassword(commonParams.getMap())
//                    .enqueue(new ResponseResolver<LoginResponse>(ForgotPassword.this, true, true) {
//                        @Override
//                        public void success(LoginResponse loginResponse) {
//                            Logger.INSTANCE.apiResponse("/api/agent/resetPasswordRequest", "");
//                            try {
//                                if(ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode()){
//                                    Toast.makeText(ForgotPassword.this, loginResponse.getMessage(), Toast.LENGTH_SHORT).show();
//                                    finish();
////                                    startActivity(new Intent(ForgotPassword.this, LoginActivity.class));
//                                } else if(ApiResponseFlags.LOGIN_ERROR.getOrdinal() == loginResponse.getStatusCode()){
//                                    Toast.makeText(ForgotPassword.this, loginResponse.getMessage(), Toast.LENGTH_SHORT).show();
//                                }
//                            } catch (Exception e) {
//                                e.printStackTrace();
//                                Logger.INSTANCE.apiResponse("/api/agent/resetPasswordRequest", e.getLocalizedMessage());
//                            }
//                        }
//
//                        @Override
//                        public void failure(APIError error) {
//                            Logger.INSTANCE.apiFailed("/api/agent/resetPasswordRequest", error.getMessage());
//                            Log.e("error", "error");
//                        }
//                    });
//        } else {
//            Toast.makeText(ForgotPassword.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
//        }
//    }
//}
