package com.hippoagent.activities;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.appcompat.widget.Toolbar;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.adapters.ChatMembersAdapter;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.ChatMembersModel;
import com.hippoagent.model.Conversation;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.filelogger.Logger;
import com.google.gson.Gson;

import java.util.ArrayList;

/**
 * Created by gurmail on 11/03/19.
 *
 * @author gurmail
 */
public class ChatMembersActivity extends FuguBaseActivity {

    private static final String TAG = ChatMembersActivity.class.getSimpleName();
    private RecyclerView recyclerView;
    private ChatMembersAdapter membersAdapter;
    private Toolbar toolbar;
    private Conversation conversation;

    private LinearLayout llNoConversation;
    private TextView titleView, reasions;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_chat_members);

        conversation = new Gson().fromJson(getIntent().getStringExtra(Constants.CONVERSATION),
                Conversation.class);
        initView();
    }

    private void initView() {
        toolbar = findViewById(R.id.my_toolbar);
        setSupportActionBar(toolbar);
        setToolbar(toolbar, Restring.getString(this, R.string.members));

        recyclerView = findViewById(R.id.recycler_view);
        llNoConversation = findViewById(R.id.llNoConversation);
        titleView = findViewById(R.id.title);
        reasions = findViewById(R.id.reasions);

        llNoConversation.setVisibility(View.GONE);

        membersAdapter = new ChatMembersAdapter();
        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        recyclerView.setLayoutManager(layoutManager);
        recyclerView.setAdapter(membersAdapter);

        if(isNetworkAvailable()) {
            getMembersData();
        } else {
            Toast.makeText(ChatMembersActivity.this,
                    Restring.getString(this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    private void getMembersData() {
        CommonParams commonParams = new CommonParams.Builder()
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                .add(Constants.CHANNEL_ID, conversation.getChannelId())
                .build();

        Logger.INSTANCE.apiRequest("/api/chat/getMembers", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getChatMembers(commonParams.getMap())
                .enqueue(new ResponseResolver<ChatMembersModel>(this, true, true) {
            @Override
            public void success(ChatMembersModel membersModel) {
                Logger.INSTANCE.apiResponse("/api/chat/getMembers", "");
                if(membersModel.getData() != null && membersModel.getData().size()>0)
                    membersAdapter.setMembersData((ArrayList<ChatMembersModel.Datum>) membersModel.getData());
                else {
                    llNoConversation.setVisibility(View.VISIBLE);
                    titleView.setText(Restring.getString(ChatMembersActivity.this, R.string.hippo_no_member_found));
                    reasions.setVisibility(View.GONE);
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("/api/chat/getMembers", error.getMessage());
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

}
