package com.hippoagent;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;

import com.hippoagent.activities.AgentListActivity;
import com.hippoagent.apis.SessionHandler;
import com.hippoagent.callback.CountDownTimerListener;
import com.hippoagent.callback.OnStartSessionListener;
import com.hippoagent.dialogs.ShowDialg;
import com.hippoagent.hippocall.HippoCallConfig;
import com.hippoagent.hippocall.WebRTCCallConstants;
import com.hippoagent.model.groupCall.GroupCallData;
import com.hippoagent.model.groupCall.GroupCallResponse;
import com.hippoagent.utils.ConfigMode;

import com.google.gson.Gson;
import com.hippoagent.activities.BroadcastListActivity;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.activities.LoginApi;
import com.hippoagent.activities.PlansActivity;
import com.hippoagent.apis.HippoLogout;
import com.hippoagent.callback.AgentUnreadCountListener;
import com.hippoagent.callback.LoginApiCallBack;
import com.hippoagent.callback.UnreadListener;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.datastructure.MessageType;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.langs.LanguageManager;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.LoginResponse.BusinessLanguages;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.utils.ConfigMode;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.UniqueIMEIID;
import com.hippoagent.utils.Utils;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

import static android.content.Context.ACTIVITY_SERVICE;
import static com.hippoagent.datastructure.FuguAppConstant.TYPING_SHOW_MESSAGE;


/**
 * Created by gurmail on 2020-04-30.
 *
 * @author gurmail
 */
public class HippoConfig implements CountDownTimerListener {
    private static final String TAG = HippoConfig.class.getSimpleName();
    private static HippoConfig hippoConfig;
    private final static String PAPER_BOOK = "hippo_agent_sdk";
    private Activity activity;
    private Context mContext;
    private boolean isHippoInit = false;
    private boolean isActivityEnabled = false;
    private String busyMuid = "";

    public HippoConfig() {

    }

    public static HippoConfig getInstance() {
        if(hippoConfig == null) {
            hippoConfig = new HippoConfig();
        }
        return hippoConfig;
    }

    public boolean isHippoInit() {
        return isHippoInit;
    }

    public void setHippoInit(boolean flag) {
        isHippoInit = flag;
    }

    public Activity getActivity() {
        return activity;
    }

    public Context getContext() {
        return this.mContext.getApplicationContext();
    }

    public String getBusyMuid() {
        return busyMuid;
    }

    public void setBusyMuid(String busyMuid) {
        this.busyMuid = busyMuid;
    }

    public static void initHippoConfig(Activity activity, HippoConfigAttributes configAttributes, LoginCallback callback) {
        HippoConfig.getInstance().configAttributes = configAttributes;
        CommonData.saveAttributes(configAttributes);
        HippoConfig.getInstance().activity = activity;
        HippoConfig.getInstance().isHippoInit = true;


        ConfigMode configModeToSet = ConfigMode.LIVE;
        if(!TextUtils.isEmpty(configAttributes.getEnvironment())) {
            switch (configAttributes.getEnvironment().toLowerCase()) {
                case "live":
                    configModeToSet = ConfigMode.LIVE;
                    break;
                case "test":
                    configModeToSet = ConfigMode.BETA;
                    break;
                case "dev3004":
                    configModeToSet = ConfigMode.DEV;
                    break;
                case "dev":
                    configModeToSet = ConfigMode.ALPHA;
                    break;
                case "beta-live":
                    configModeToSet = ConfigMode.LIVE_BETA;
                    break;
                case "dev3003":
                    configModeToSet = ConfigMode.DEV3003;
                    break;
                default:
                    configModeToSet = ConfigMode.LIVE;
                    break;
            }
        }

        HippoApplication.getInstance().initializeServerURL(configModeToSet);


        loginHippoAgent(activity, configAttributes, callback);
        UnreadCountHelper.getInstance().setListener();
    }

    public void openMainScreen(@NotNull Activity activity) {
        if(HippoApplication.getInstance().getUserData() != null)
            activity.startActivity(new Intent(activity, HomeActivity.class));
        else
            Log.e("HippoConfig", "Need to login first");
    }

    public void openSavedReply(Activity activity) {
        if(HippoApplication.getInstance().getUserData() != null && HippoApplication.getInstance().getUserData().getBusinessProperty().isAskPaymentAllowed()) {
            Intent planIntent = new Intent(activity, PlansActivity.class);
            activity.startActivity(planIntent);
        } else {
            Log.e("Error", "Feature not available");
        }
    }

    public void openBroadcast(@NotNull Activity activity) {
        if(HippoApplication.getInstance().getUserData() != null)
            activity.startActivity(new Intent(activity, BroadcastListActivity.class));
        else
            Log.e("HippoConfig", "Need to login first");
    }

    public void logoutHippo(Activity activity) {
        HippoLogout.INSTANCE.logout(activity);
    }

    private HippoConfigAttributes configAttributes;

    public HippoConfigAttributes getAttributes() {
        if(configAttributes == null) {
            configAttributes = CommonData.getConfigAttributes();
        }
        return configAttributes;
    }

    private static void loginHippoAgent(Activity activity, HippoConfigAttributes configAttributes, LoginCallback callback) {
        LoginApi.INSTANCE.login(activity, configAttributes, new LoginApiCallBack() {
            @Override
            public void onErrorMessage(@NotNull LoginResponse t) {
                callback.onError();
            }

            @Override
            public void onApiSuccess(@NotNull LoginResponse t) {
                openChannel(t);
                callback.success();
            }

            @Override
            public void onApiFailed(@Nullable APIError error) {
                callback.failed();
            }

            @Override
            public void singleBtnUpdateWindow(@NotNull LoginResponse t) {
                openChannel(t);
                callback.success();
            }

            @Override
            public void showUpdateWindowTwoBtns(@NotNull LoginResponse t) {
                openChannel(t);
                callback.success();
            }
        }, false, true);
    }

    private static void openChannel(LoginResponse t) {
        ConnectionManager.INSTANCE.initFayeConnection();
        if (t != null && !TextUtils.isEmpty(t.getUserData().getUserChannel())) {
            ConnectionManager.INSTANCE.subScribeChannel("/" + t.getUserData().getUserChannel());
            ConnectionManager.INSTANCE.subScribeChannel("/" + t.getUserData().getAccessToken() + "/agentsRefresh");
            ConnectionManager.INSTANCE.subScribeChannel("/" + t.getUserData().getAccessToken() + "/agentRefresh");
            ConnectionManager.INSTANCE.subScribeChannel("/" + t.getUserData().getAccessToken() + "/userMigration");
        }

        try {
            if(TextUtils.isEmpty(HippoConfig.getInstance().getAttributes().getLang())) {
                if(!TextUtils.isEmpty(t.getUserData().getLangCode())) {
                    HippoConfig.getInstance().updateLanguage(t.getUserData().getLangCode());
                } else {
                    for(BusinessLanguages languages : t.getUserData().getBusinessLanguages()) {
                        if(languages.isDefaultLnag()) {
                            HippoConfig.getInstance().updateLanguage(languages.getLangCode());
                            break;
                        }
                    }
                }
            } else if(!TextUtils.isEmpty(HippoConfig.getInstance().getAttributes().getLang())
                    && t.getUserData().getBusinessLanguages() != null) {
                String lang = "";
                for(BusinessLanguages languages : t.getUserData().getBusinessLanguages()) {
                    if(HippoConfig.getInstance().getAttributes().getLang().equalsIgnoreCase(languages.getLangCode())) {
                        lang = languages.getLangCode();
                        break;
                    } else if(languages.isDefaultLnag()) {
                        lang = languages.getLangCode();
                    }
                }
                HippoConfig.getInstance().updateLanguage(lang);
            } else {
                HippoConfig.getInstance().updateLanguage("en");
            }
        } catch (Exception e) {

        }

    }

    public void openDirectChannel(Activity activity, Integer channelId) {
        if(channelId != null && channelId > 0) {
            Intent intent = new Intent(activity, FuguChatActivity.class);
            intent.putExtra("is_direct_channel", true);
            //intent.putExtra("channel_id", channelId);
            intent.putExtra("is_p2p_chat", false);
            Conversation conversation = new Conversation();
            conversation.setChannelId(channelId);
            conversation.setStatus(2);
            //conversation.setDisableReply(1);
            intent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
            activity.startActivity(intent);
        } else {
            Log.e(TAG, "Invalid channel ID");
        }
    }


    // for tookan side

    private UnreadCount callbackListener;
    private AgentUnreadCountListener countListener;
    private HippoAssignmentListener assignmentListener;

    public HippoAssignmentListener getAssignmentListener() {
        return assignmentListener;
    }

    public void setAssignmentListener(HippoAssignmentListener assignmentListener) {
        this.assignmentListener = assignmentListener;
    }

    public UnreadCount getCallbackListener() {
        return callbackListener;
    }

    public void setCallbackListener(UnreadCount callbackListener) {
        this.callbackListener = callbackListener;
    }

    public AgentUnreadCountListener getAgentCountListener() {
        return countListener;
    }

    public void setCountForCallbackListener(AgentUnreadCountListener countListener) {
        this.countListener = countListener;
    }

    public void getTotalUnreadCount() {
        try {
            getTotalUnreadCountData();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getUnreadCountFor(ArrayList<String> strings) {
        UnreadCountHelper.getInstance().getUpdatedUnreadCount(strings);
    }

    private void getTotalUnreadCountData() throws Exception {
        UnreadCountHelper.getInstance();
        LoginApi.INSTANCE.getAgentTotalUnreadCount();
    }


    // for yelo side

    public void openConversationFor(Activity activity, String otherUserUniqueKey, String title) {
        openConversationFor(activity, otherUserUniqueKey, title, "");
    }
    public void openConversationFor(Activity activity, String otherUserUniqueKey, String title, String transactionId) {
        if(HippoConfig.getInstance().activity == null) {
            HippoConfig.getInstance().activity = activity;
        }
        if(!TextUtils.isEmpty(otherUserUniqueKey) && !TextUtils.isEmpty(transactionId)) {
            Conversation conversation = new Conversation();
            conversation.setChannelId(-1);
            conversation.setChannelName("dummyChannelName");
            conversation.setStatus(-2);
            conversation.setAgentId(-2);
            conversation.setUserUniqueKeys(otherUserUniqueKey);

            conversation.setLabel(title);
            conversation.setUnreadCount(0);


            Intent intent = new Intent(activity.getApplicationContext(), FuguChatActivity.class);
            intent.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
            intent.putExtra(FuguAppConstant.CREATE_NEW_CHAT, true);
            intent.putExtra("transactionId", transactionId);
            intent.putExtra(FuguAppConstant.FRAGMENT_TYPE, MessageType.USER_CHAT.getOrdinal());
            activity.startActivity(intent);

        } else {
//            Intent intent = new Intent(activity.getApplicationContext(), AgentListActivity.class);
//            intent.putExtra("title", title);
//            if(!TextUtils.isEmpty(otherUserUniqueKey))
//                intent.putExtra("user_unique_key", otherUserUniqueKey);
//            activity.startActivity(intent);
        }
    }

    /**
     * Method used to create chat with agent directly based upon agents email
     * @param email
     */
    public void startOneToOneConversation(String email) {
        if(Utils.isValidEmail(email)) {
            Conversation conversation = new Conversation();
            conversation.setChannelId(-1);
            conversation.setChannelName("dummyChannelName");
            conversation.setStatus(-2);
            conversation.setAgentId(-2);
            conversation.setChatType(2);
            conversation.setLabel("");
            conversation.setUnreadCount(0);

            Intent intent = new Intent(activity.getApplicationContext(), FuguChatActivity.class);
            intent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
            intent.putExtra(FuguAppConstant.CREATE_NEW_CHAT, true);
            intent.putExtra("is_one_two_one", true);
            intent.putExtra("one_two_one_email", email);
            activity.startActivity(intent);
        } else {
            Log.e(TAG, "Enter valid email");
        }
    }

    private UnreadListener unreadListener;

    protected void setInternalCountListener(UnreadListener unreadListener) {
        this.unreadListener = unreadListener;
    }

    public UnreadListener getInternalListener() {
        return unreadListener;
    }

    private String currentLanguage;

    public String getCurrentLanguage() {
        currentLanguage = CommonData.getCurrentLanguage();
        return currentLanguage;
    }

    public void updateLanguage() {
        updateLanguage(getCurrentLanguage());
    }

    public void updateLanguage(String languageCode) {
        if(TextUtils.isEmpty(languageCode)) {
            android.util.Log.e("TAG", "Language code can't be null");
            return;
        }
        if(HippoApplication.getInstance().getUserData() == null
                || HippoApplication.getInstance().getUserData().getBusinessProperty() == null
                || TextUtils.isEmpty(HippoApplication.getInstance().getUserData().getAccessToken())) {
            return;
        }
        String lang = "";
        try {
            for(BusinessLanguages languages : HippoApplication.getInstance().getUserData().getBusinessLanguages()) {
                if(languages.getLangCode().equalsIgnoreCase(languageCode)) {
                    lang = languageCode;
                    break;
                }
            }
        } catch (Exception e) {
            android.util.Log.e("TAG", "This language code not found");
            return;
        }
        if(TextUtils.isEmpty(lang)) {
            android.util.Log.e("TAG", "This language code not found");
            return;
        }

        String getCurrentLang = CommonData.getCurrentLanguage();
        Log.w("Lang", getCurrentLang+" -> currentLang, Requerd Lang -> "+languageCode);
        if(!getCurrentLang.equalsIgnoreCase(languageCode)) {
            currentLanguage = languageCode;
            CommonData.saveCurrentLang(currentLanguage);
            setLanguage(currentLanguage);
        }
    }

    public String getBusinessLanguage() {
        try {
            if(HippoApplication.getInstance().getUserData().getBusinessLanguages() != null)
                return new Gson().toJson(HippoApplication.getInstance().getUserData().getBusinessLanguages());
        } catch (Exception e) {

        }
        return "";
    }

    private void setLanguage(String language) {
        LanguageManager.INSTANCE.updateLanguage(language);
    }


    // for session handling

    public void createSession(Activity activity, SessionAttributes attributes) {
        SessionHandler.INSTANCE.createSession(activity, attributes);
    }

    private OnGroupSessionListener sessionListener;
    public void updateGroupSession(OnGroupSessionListener sessionListener) {
        this.sessionListener = sessionListener;
    }

    public OnGroupSessionListener getGroupSessionListener() {
        return sessionListener;
    }

    /**
     * Method used to start the session
     * @param activity
     * @param transactionId
     * @param callType 1 for video and 2 for audio call
     */
    public void startSession(Activity activity, String transactionId, int callType) {
        ShowDialg.INSTANCE.showDialog(activity);
        GroupCallData groupCallData = CommonData.getGroupData(transactionId);
        if(groupCallData != null && !TextUtils.isEmpty(groupCallData.getRoomUniqueId())) {
            initCall(activity, transactionId, callType, groupCallData.getChannelId(),
                    groupCallData.getRoomUniqueId(), groupCallData.getRoomTitle());

            HippoCallConfig.getInstance().joinSession(activity, groupCallData.getRoomUniqueId(), groupCallData.getRoomTitle(), callType, transactionId);
        } else {
            SessionHandler.INSTANCE.startSession(activity, transactionId, callType, new OnStartSessionListener() {
                @Override
                public void onStartListener(GroupCallResponse callResponse) {
                    muid = UUID.randomUUID().toString();
                    initCall(activity, transactionId, callType, callResponse.getData().getChannelId(),
                            callResponse.getData().getCustomData().getRoomUniqueId(), callResponse.getData().getRoomTitle());

                    try {
                        GroupCallData groupCallData = new GroupCallData();
                        groupCallData.setTransactionId(transactionId);
                        groupCallData.setChannelId(callResponse.getData().getChannelId());
                        groupCallData.setCallType(callType);
                        groupCallData.setMuid(muid);
                        groupCallData.setRoomTitle(callResponse.getData().getRoomTitle());
                        groupCallData.setRoomUniqueId(callResponse.getData().getCustomData().getRoomUniqueId());
                        CommonData.saveGroupCall(transactionId, groupCallData);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    HippoCallConfig.getInstance().joinSession(activity, callResponse.getData().getCustomData().getRoomUniqueId(),
                            callResponse.getData().getRoomTitle(), callType, transactionId);

                    if(HippoConfig.getInstance().getGroupSessionListener() != null)
                        HippoConfig.getInstance().getGroupSessionListener().onStartSession(transactionId);
                }

                @Override
                public void onErrorListener(String error) {
                    ShowDialg.INSTANCE.hideDialog();
                    if(HippoConfig.getInstance().getGroupSessionListener() != null)
                        HippoConfig.getInstance().getGroupSessionListener().onErrorInSession(error);
                }
            });
        }
    }

    /**
     * To remove the local session data and data
     * @param transactionId
     */
    public void stopSession(String transactionId) {
        // TODO: 2020-07-20 close call view

        CommonData.deleteGroupData(transactionId);
    }

    /**
     * Method used to send and clear session data
     * @param activity
     * @param transactionId
     */
    public void endSession(Activity activity, String transactionId) {

        GroupCallData callResponse = CommonData.getGroupData(transactionId);
        JSONObject startCallJson = new JSONObject();
        try {
            startCallJson.put("is_silent", false);
            startCallJson.put("video_call_type", WebRTCCallConstants.JitsiCallType.END_GROUP_CALL.toString());
            startCallJson.put("user_id", HippoApplication.getInstance().getUserData().getUserId());
            startCallJson.put("channel_id", callResponse.getChannelId());
            startCallJson.put("message_type", 27);
            startCallJson.put("call_type", "VIDEO");
            if(callResponse.getCallType() == 2) {
                startCallJson.put("call_type", "AUDIO");
            }
            startCallJson.put("muid", muid);
            startCallJson.put("device_payload", getDeviceDetails().toString());
            String baseUrl = getJitsiURL();
            if(TextUtils.isEmpty(baseUrl)) {
                baseUrl = FuguAppConstant.CONFERENCING_LIVE;
            }
            String link = baseUrl+"/"+callResponse.getRoomUniqueId();

            String invitelink = FuguAppConstant.CONFERENCING_LIVE+"/"+callResponse.getRoomUniqueId();
            if(callResponse.getCallType() == 2) {
                link = link + "#config.startWithVideoMuted=true";
                invitelink = invitelink + "#config.startWithVideoMuted=true";
            }
            startCallJson.put("invite_link", invitelink);
            startCallJson.put("jitsi_url", link);

            startCallJson.put("message", "");
            startCallJson.put("is_typing", TYPING_SHOW_MESSAGE);
            startCallJson.put("user_type", FuguAppConstant.ANDROID_USER);
            startCallJson.put("full_name", callResponse.getRoomTitle());

            ConnectionManager.INSTANCE.publish("/"+callResponse.getChannelId(), startCallJson);

            CommonData.deleteGroupData(transactionId);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    int initalCalls = 0;
    String muid = "";
    CountDownTimer countDownTimer;

    CountDownTimerListener timerListener;
    protected void setListener(CountDownTimerListener listener) {

    }

    private void stopSession() {
        try {
            ConnectionManager.INSTANCE.setCountDownTimerListener(null);
            if(countDownTimer != null) {
                countDownTimer.cancel();
                countDownTimer = null;
            }
        } catch (Exception e) {

        }

    }

    private String jitsiURL = "";
    public String getJitsiURL() {
        if(TextUtils.isEmpty(jitsiURL)) {
            if(HippoApplication.getInstance().getUserData() != null &&
                    HippoApplication.getInstance().getUserData().getBusinessProperty() != null &&
                    !TextUtils.isEmpty(HippoApplication.getInstance().getUserData().getBusinessProperty().getJitsiUrl())) {
                jitsiURL = HippoApplication.getInstance().getUserData().getBusinessProperty().getJitsiUrl();
            }
        }
        return jitsiURL;
    }


    private void initCall(Activity activity, String transactionId, int callType, Long channelId, String roomId, String title) {
        initalCalls = 0;
        //muid = UUID.randomUUID().toString();
        ConnectionManager.INSTANCE.setCountDownTimerListener(this);
        ConnectionManager.INSTANCE.unsubScribeChannel("/" + channelId);
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                ConnectionManager.INSTANCE.subScribeChannel("/" + channelId);
            }
        }, 500);

        new Handler(Looper.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {
                countDownTimer = new CountDownTimer(60000, 2000) {

                    public void onTick(long millisUntilFinished) {
                        if (initalCalls == 1) {
                            startCall(false, channelId, roomId, title, callType, transactionId);
                            //HippoCallConfig.getInstance().joinSession(activity, roomId, title, callType, transactionId);
                        } else {
                            startCall(true, channelId, roomId, title, callType, transactionId);
                        }
                        initalCalls += 1;
                    }

                    public void onFinish() {
                        Log.e("Time", "Clock stop here");
                        stopSession();
                    }
                };

                countDownTimer.start();
            }
        });
    }

    private void startCall(boolean isSilent, Long channelId, String roomId, String title, int callType, String transactionId) {
        JSONObject startCallJson = new JSONObject();
        try {
            startCallJson.put("is_silent", isSilent);
            startCallJson.put("video_call_type", WebRTCCallConstants.JitsiCallType.START_GROUP_CALL.toString());
            startCallJson.put("user_id", HippoApplication.getInstance().getUserData().getUserId());
            startCallJson.put("channel_id", channelId);
            startCallJson.put("message_type", 27);
            startCallJson.put("call_type", "VIDEO");
            if(callType == 2) {
                startCallJson.put("call_type", "AUDIO");
            }
            startCallJson.put("muid", muid);
            startCallJson.put("device_payload", getDeviceDetails().toString());

            String baseUrl = getJitsiURL();
            if(TextUtils.isEmpty(baseUrl)) {
                baseUrl = FuguAppConstant.CONFERENCING_LIVE;
            }
            String link = baseUrl+"/"+roomId;
            String invitelink = FuguAppConstant.CONFERENCING_LIVE+"/"+roomId;

            /*if(callType == 2) {
                link = link + "#config.startWithVideoMuted=true";
            }*/
            if(callType == 2) {
                link = link + "#config.startWithVideoMuted=true";
                invitelink = invitelink + "#config.startWithVideoMuted=true";
            }





            startCallJson.put("jitsi_url", link);
            startCallJson.put("invite_link", invitelink);



            startCallJson.put("message", "");
            startCallJson.put("is_typing", TYPING_SHOW_MESSAGE);
            startCallJson.put("user_type", FuguAppConstant.ANDROID_USER);
            startCallJson.put("full_name", title);
            startCallJson.put("transaction_id", transactionId);
            //startCallJson.put("user_thumbnail_image", "");

            ConnectionManager.INSTANCE.publish("/"+channelId, startCallJson);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JSONObject getDeviceDetails() {
        JSONObject devicePayload = new JSONObject();
        try {
            devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(activity));
            devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER);
            devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME);
            devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(activity));
        } catch (Exception e) {

        }
        return devicePayload;
    }

    @Override
    public void onErrorReceived(String channel, String msg) {
        try {
            Log.e("ON ERROR", "ON ERROR = "+msg);
            JSONObject jsonObject = new JSONObject(msg);
            if(jsonObject.optInt("statusCode") == 421) {
                stopSession();
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }
}
