/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.swipeLayout;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.hippoagent.utils.swipeLayout.listener.LayoutShiftListener;
import com.hippoagent.utils.swipeLayout.listener.OnLayoutPercentageChangeListener;
import com.hippoagent.utils.swipeLayout.listener.OnLayoutSwipedListener;
import java.util.HashSet;
import java.util.Set;

public class SwipeGestureManager
implements View.OnTouchListener {
    private OnLayoutSwipedListener onSwipedListener;
    private OnLayoutPercentageChangeListener onLayoutPercentageChangeListener;
    private LayoutShiftListener layoutShiftListener;
    private float swipeSpeed;
    private int orientationMode;
    private Set<Integer> blocks;
    private float firstXPosition;
    private float firstYPosition;
    private int lastXPosition;
    private int lastYPosition;
    private int currentXPosition;
    private int currentYPosition;
    private int shiftX;
    private int shiftY;
    private int lastMotion = -1;
    private Context context;
    private final GestureDetector gestureDetector;
    private boolean isSwipeable = true;
    private View view = null;

    private SwipeGestureManager(Context context, float startX, float startY, float swipeSpeed, int orientationMode) {
        this.context = context;
        this.firstXPosition = startX;
        this.firstYPosition = startY;
        this.swipeSpeed = swipeSpeed;
        this.orientationMode = orientationMode;
        this.blocks = new HashSet<Integer>();
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new FlingGestureDetector());
    }

    public boolean onTouch(View view, MotionEvent event) {
        try {
            boolean status2;
            this.view = view;
            switch (this.orientationMode) {
                case 1: {
                    status2 = this.swipeByY(view, event);
                    break;
                }
                default: {
                    status2 = false;
                }
            }
            return status2;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void isSwipeable(boolean isSwipeable) {
        this.isSwipeable = isSwipeable;
    }

    public void customRollBack(float y) {
        if (this.view != null) {
            this.rollback(this.view, "y", this.view.getY(), this.firstYPosition);
        }
    }

    private boolean swipeByY(View view, MotionEvent event) {
        if (this.isSwipeable && !this.blocks.contains(1)) {
            if (this.gestureDetector.onTouchEvent(event)) {
                return true;
            }
            int y = (int)event.getRawY();
            int height = view.getHeight();
            float dif = Math.abs(view.getY()) / (float)(height / 4);
            if (event.getActionMasked() == 0) {
                this.lastYPosition = y;
                this.currentYPosition = (int)view.getY();
                this.lastMotion = 0;
            } else if (event.getActionMasked() == 2) {
                this.shiftY = y - this.lastYPosition;
                view.setY((float)this.currentYPosition + (float)this.shiftY * this.swipeSpeed);
                if (this.onLayoutPercentageChangeListener != null && (double)dif > 0.1) {
                    this.onLayoutPercentageChangeListener.percentageY(dif > 1.0f ? 1.0f : dif);
                }
                this.triggerPositionChangeListener(this.shiftX, this.shiftY, true);
                this.lastMotion = 2;
            } else if (event.getActionMasked() == 1) {
                this.triggerPositionChangeListener(this.shiftX, this.shiftY, false);
                this.lastMotion = 1;
                if ((double)dif > 1.0) {
                    this.triggerSwipeListener();
                }
                this.rollback(view, "y", view.getY(), this.firstYPosition);
            } else if (event.getActionMasked() == 3) {
                return false;
            }
        }
        return true;
    }

    private boolean swipeByX(View view, MotionEvent event) {
        return true;
    }

    public void rollback(View view, String axis, float fromPosition, float startPosition) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)axis, (float[])new float[]{fromPosition, startPosition});
        animator.setDuration(300L);
        animator.start();
    }

    public void addBlock(int orientationMode) {
        this.blocks.add(orientationMode);
    }

    public void setBlockSet(Set<Integer> blockSet) {
        this.blocks.addAll(blockSet);
    }

    public void removeBlock(int orientationMode) {
        this.blocks.remove(orientationMode);
    }

    public void setSwipeSpeed(int swipeSpeed) {
        this.swipeSpeed = swipeSpeed;
    }

    public void setOrientationMode(int orientationMode) {
        this.orientationMode = orientationMode;
    }

    public void setOnSwipedListener(OnLayoutSwipedListener onSwipedListener) {
        this.onSwipedListener = onSwipedListener;
    }

    public void setOnLayoutPercentageChangeListener(OnLayoutPercentageChangeListener onLayoutPercentageChangeListener) {
        this.onLayoutPercentageChangeListener = onLayoutPercentageChangeListener;
    }

    public void setLayoutShiftListener(LayoutShiftListener layoutShiftListener) {
        this.layoutShiftListener = layoutShiftListener;
    }

    private void triggerSwipeListener() {
        if (this.onSwipedListener != null) {
            this.onSwipedListener.onLayoutSwiped(0);
        }
    }

    private void triggerPositionChangeListener(float positionX, float positionY, boolean state) {
        if (this.layoutShiftListener != null && this.lastMotion != 1) {
            this.layoutShiftListener.onLayoutShifted(positionX, positionY, state);
        }
    }

    public abstract class OrientationMode {
        public static final int LEFT_RIGHT = 0;
        public static final int UP_BOTTOM = 1;
        public static final int BOTH = 2;
        public static final int NONE = 3;
    }

    public static class Builder {
        private final Context context;
        private float mSwipeSpeed;
        private int mOrientationMode;
        private float startX;
        private float startY;

        public Builder(Context context) {
            this.context = context;
        }

        public void setSwipeSpeed(float mSwipeSpeed) {
            this.mSwipeSpeed = mSwipeSpeed;
        }

        public void setOrientationMode(int orientationMode) {
            this.mOrientationMode = orientationMode;
        }

        public void setStartCoordinates(float startX, float startY) {
            this.startX = startX;
            this.startY = startY;
        }

        public void setStartX(int startX) {
            this.startX = startX;
        }

        public SwipeGestureManager create() {
            return new SwipeGestureManager(this.context, this.startX, this.startY, this.mSwipeSpeed, this.mOrientationMode);
        }
    }

    class FlingGestureDetector
    extends GestureDetector.SimpleOnGestureListener {
        float sensitivity = 500.0f;

        FlingGestureDetector() {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (Math.abs(velocityY) > this.sensitivity && !SwipeGestureManager.this.blocks.contains(1)) {
                if (SwipeGestureManager.this.isSwipeable) {
                    SwipeGestureManager.this.triggerSwipeListener();
                }
            } else if (!(Math.abs(velocityX) > this.sensitivity) || !SwipeGestureManager.this.blocks.contains(0)) {
                // empty if block
            }
            return false;
        }
    }
}

