/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.compressor;

import android.graphics.Bitmap;
import android.text.TextUtils;
import com.easyfilepicker.filter.entity.ImageFile;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.compressor.ImageUtil;
import com.hippoagent.utils.filePicker.CompressorListener;
import java.io.File;
import java.io.IOException;

public class Compressor
implements FuguAppConstant {
    private float maxWidth = 612.0f;
    private float maxHeight = 816.0f;
    private Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
    private int quality = 80;
    private String destinationDirectoryPath = Utils.getDirectoryPath((String)FOLDER_TYPE.get("image"));
    private CompressorListener compressorListener;

    public Compressor setMaxWidth(float maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public Compressor setMaxHeight(float maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public Compressor setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
        return this;
    }

    public Compressor setQuality(int quality) {
        this.quality = quality;
        return this;
    }

    public Compressor setListener(CompressorListener compressorListener) {
        this.compressorListener = compressorListener;
        return this;
    }

    public Compressor setDestinationDirectoryPath(String destinationDirectoryPath) {
        this.destinationDirectoryPath = destinationDirectoryPath;
        return this;
    }

    public void compressToFile(File imageFile, ImageFile actualFile) throws IOException {
        String path = this.destinationDirectoryPath + File.separator + actualFile.getName() + "_" + actualFile.getMuid() + ".jpg";
        if (!TextUtils.isEmpty((CharSequence)actualFile.getPath())) {
            path = actualFile.getDestinationPath();
        }
        ImageUtil.compressImage(imageFile, actualFile, this.maxWidth, this.maxHeight, this.compressFormat, this.quality, path, this.compressorListener);
    }
}

