/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;

public class SearchViewNetworkQueryHelper
implements TextWatcher {
    private EditText mEditTextView;
    private SearchCallbacks mSearchCallbacks;
    private Handler mHandler;
    private Runnable mPerformSearchRunnable;
    private int mSuggestCountThreshold;
    private int mSuggestWaitThreshold;

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable query) {
        if (this.mSearchCallbacks != null && query != null && query.length() > 0) {
            this.mSearchCallbacks.showLoader();
        }
        this.removeAnyCallbacks();
        if (query != null && query.length() >= this.mSuggestCountThreshold) {
            this.mPerformSearchRunnable = this.searchClickRunnable(query.toString());
            this.mHandler.postDelayed(this.mPerformSearchRunnable, (long)this.mSuggestWaitThreshold);
        } else if (this.mSearchCallbacks != null && query != null && query.length() <= this.mSuggestCountThreshold) {
            this.mSearchCallbacks.showAllData();
        }
    }

    public SearchViewNetworkQueryHelper(EditText searchView, SearchCallbacks searchCallbacks) {
        this.mEditTextView = searchView;
        this.mSearchCallbacks = searchCallbacks;
        this.mHandler = new Handler();
        this.mEditTextView.addTextChangedListener((TextWatcher)this);
    }

    public void removeTextChanged() {
        this.mEditTextView.removeTextChangedListener((TextWatcher)this);
    }

    public void addTextChanged() {
        this.mEditTextView.addTextChangedListener((TextWatcher)this);
    }

    public int getSuggestCountThreshold() {
        return this.mSuggestCountThreshold;
    }

    public void setSuggestCountThreshold(int suggestCountThreshold) {
        this.mSuggestCountThreshold = suggestCountThreshold;
    }

    public int getSuggestWaitThreshold() {
        return this.mSuggestWaitThreshold;
    }

    public void setSuggestWaitThreshold(int suggestWaitThreshold) {
        this.mSuggestWaitThreshold = suggestWaitThreshold;
    }

    private void removeAnyCallbacks() {
        if (this.mPerformSearchRunnable != null) {
            this.mHandler.removeCallbacks(this.mPerformSearchRunnable);
        }
    }

    private Runnable searchClickRunnable(final String query) {
        return new Runnable(){

            @Override
            public void run() {
                if (SearchViewNetworkQueryHelper.this.mSearchCallbacks != null) {
                    SearchViewNetworkQueryHelper.this.mSearchCallbacks.performQuery(query);
                }
            }
        };
    }

    public static interface SearchCallbacks {
        public void showLoader();

        public void performQuery(String var1);

        public void showAllData();
    }
}

