/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.hippoagent.MyApplication;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.MessageMode;
import com.hippoagent.fcm.NotificationDatabase;
import com.hippoagent.fcm.NotificationUtils;
import com.hippoagent.fcm.PushHandler;
import com.hippoagent.fcm.SendReplyMessage;
import com.hippoagent.model.Conversation;
import org.json.JSONObject;

public class PushIntentService
extends IntentService {
    private static final String TAG = "PushIntentService";

    public PushIntentService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        String message = (String)PushHandler.Reply.INSTANCE.getReplyMessage(intent);
        if (!TextUtils.isEmpty((CharSequence)message)) {
            Log.d((String)TAG, (String)("Message := " + message));
            try {
                String payload = intent.getStringExtra("json");
                JSONObject data = new JSONObject(payload);
                new SendReplyMessage((Context)this).sendMessage(data, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        Intent notificationIntent = null;
        try {
            String payload = intent.getStringExtra("json");
            JSONObject data = new JSONObject(payload);
            int channedId = data.optInt("channel_id", -1);
            int userId = data.optInt("user_id", -1);
            int disableReply = data.optInt("disable_reply", 0);
            String label = data.optString("label", "User");
            boolean isRecreated = data.optBoolean("is_recreated", false);
            boolean isPromotionalPush = data.optBoolean("is_promotional", false);
            Conversation conversation = new Conversation();
            conversation.setChannelId(channedId);
            conversation.setLabel(label);
            if (isRecreated) {
                String messageData = data.optString("push_message");
                Log.e((String)TAG, (String)("messageData = " + messageData));
                conversation.setPushMessage(messageData);
            }
            conversation.setUserId(userId);
            conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());
            conversation.setDisableReply(disableReply);
            if (MyApplication.getInstance().getIsAppOpen() != null && channedId > 0) {
                notificationIntent = new Intent((Context)this, FuguChatActivity.class);
                notificationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                notificationIntent.setFlags(0x14000000);
            } else {
                PackageManager pm = this.getPackageManager();
                notificationIntent = pm.getLaunchIntentForPackage(this.getPackageName());
                notificationIntent.putExtra("startChatActivity", true);
                notificationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.startActivity(notificationIntent);
    }

    private void clearNotification(int channelId) {
        try {
            NotificationDatabase.INSTANCE.removeNotifications(channelId);
            NotificationUtils.clearNotifications((Context)this, channelId);
            CommonData.removeNotificationChannel(channelId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

