/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import androidx.fragment.app.DialogFragment;
import com.hippoagent.R;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DatePickerFragment
extends DialogFragment {
    DatePickerDialog.OnDateSetListener ondateSet;
    TimePickerDialog.OnTimeSetListener onTimeSetListener;
    public static final int TYPE_DATE_PICKER = 1;
    public static final int TYPE_TIME_PICKER = 2;
    private int year;
    private int month;
    private int day;
    private int hourOfDay;
    private int minute;
    private int viewType;
    private int minDate = 60;
    private boolean isPastDate = false;

    public void setCallBack(DatePickerDialog.OnDateSetListener ondate) {
        this.ondateSet = ondate;
    }

    public void setTimecallBack(TimePickerDialog.OnTimeSetListener onTimeSetListener) {
        this.onTimeSetListener = onTimeSetListener;
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
        this.year = args.getInt("year");
        this.month = args.getInt("month");
        this.day = args.getInt("day");
        this.hourOfDay = args.getInt("hourOfDay");
        this.minute = args.getInt("minute");
        this.viewType = args.getInt("type");
        if (args.containsKey("isPastDate")) {
            this.isPastDate = args.getBoolean("isPastDate");
        }
        if (args.containsKey("minDate")) {
            this.minDate = args.getInt("minDate");
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (this.viewType == 1) {
            DatePickerDialog datePickerDialog = new DatePickerDialog((Context)this.getActivity(), R.style.HippoDialogTheme, this.ondateSet, this.year, this.month, this.day);
            try {
                datePickerDialog.setButton(-1, (CharSequence)"OK", (DialogInterface.OnClickListener)datePickerDialog);
                datePickerDialog.setButton(-2, (CharSequence)"CANCEL", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.minDate != -1) {
                long mintime = DateTime.now((DateTimeZone)DateTimeZone.getDefault()).minusDays(this.minDate).toDate().getTime();
                datePickerDialog.getDatePicker().setMinDate(mintime);
            }
            datePickerDialog.updateDate(this.year, this.month, this.day);
            datePickerDialog.getDatePicker().setMaxDate(System.currentTimeMillis());
            return datePickerDialog;
        }
        TimePickerDialog timePickerDialog = new TimePickerDialog((Context)this.getActivity(), R.style.TimePickerDialog, this.onTimeSetListener, this.hourOfDay, this.minute, false);
        timePickerDialog.updateTime(this.hourOfDay, this.minute);
        return timePickerDialog;
    }
}

