/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.retrofit;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hippoagent.HippoConfig;
import com.hippoagent.MyApplication;
import com.hippoagent.model.user_details.DeviceDetails;
import com.hippoagent.retrofit.RetrofitUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class MultipartParams {
    HashMap<String, RequestBody> map = new HashMap();
    Gson gson = new GsonBuilder().create();

    private MultipartParams(Builder builder2) {
        JsonObject deviceDetailsJson = null;
        String deviceID = null;
        try {
            deviceDetailsJson = this.gson.toJsonTree((Object)new DeviceDetails(MyApplication.getInstance().getAppVersion()).getDeviceDetails()).getAsJsonObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            deviceID = MyApplication.getInstance().getDeviceId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        builder2.map.put("source_type", RetrofitUtils.getRequestBodyFromString(String.valueOf(2)));
        builder2.map.put("app_version", RetrofitUtils.getRequestBodyFromString(String.valueOf(HippoConfig.getInstance().getAttributes().getVersionCode())));
        builder2.map.put("device_type", RetrofitUtils.getRequestBodyFromString(String.valueOf(1)));
        if (deviceDetailsJson != null) {
            builder2.map.put("device_details", RetrofitUtils.getRequestBodyFromString(this.gson.toJson((JsonElement)deviceDetailsJson)));
        }
        if (!TextUtils.isEmpty((CharSequence)deviceID)) {
            builder2.map.put("device_id", RetrofitUtils.getRequestBodyFromString(deviceID));
        }
        if (HippoConfig.getInstance().getAttributes().getIsWhitelabel()) {
            builder2.map.put("reference_secret_key", RetrofitUtils.getRequestBodyFromString(HippoConfig.getInstance().getAttributes().getAppKey()));
        }
        this.map = builder2.map;
    }

    public HashMap<String, RequestBody> getMap() {
        return this.map;
    }

    public static class Builder {
        HashMap<String, RequestBody> map = new HashMap();

        public Builder add(String key, Object value) {
            if (value == null || String.valueOf(value).isEmpty()) {
                return this;
            }
            this.map.put(key, RetrofitUtils.getRequestBodyFromString(String.valueOf(value)));
            return this;
        }

        public Builder addFile(String key, File mFile) {
            if (mFile == null) {
                return this;
            }
            this.map.put(key + "\"; filename=\"" + mFile.getName(), RequestBody.create((MediaType)MediaType.parse((String)RetrofitUtils.getMimeType(mFile)), (File)mFile));
            return this;
        }

        public Builder addArrayOfFiles(String key, ArrayList<File> mFileArrayList) {
            if (mFileArrayList == null || mFileArrayList.size() == 0) {
                return this;
            }
            for (int i = 0; i < mFileArrayList.size(); ++i) {
                if (mFileArrayList.get(i) == null) continue;
                this.map.put(key + "\"; filename=\"" + mFileArrayList.get(i).getName(), RequestBody.create((MediaType)MediaType.parse((String)RetrofitUtils.getMimeType(mFileArrayList.get(i))), (File)mFileArrayList.get(i)));
            }
            return this;
        }

        public MultipartParams build() {
            return new MultipartParams(this);
        }
    }
}

