/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.mentions;

import android.content.Context;
import android.text.Html;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.widget.EditText;
import androidx.core.content.ContextCompat;
import com.hippoagent.R;
import com.hippoagent.mentions.Mentionable;
import com.hippoagent.mentions.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class MentionInsertionLogic {
    private final EditText editText;
    private final List<Mentionable> mentions;
    protected int textHighlightColor;

    MentionInsertionLogic(EditText editText) {
        this.editText = editText;
        this.mentions = new ArrayList<Mentionable>();
        this.textHighlightColor = R.color.mentions_default_color;
    }

    public List<Mentionable> getMentions() {
        return this.mentions;
    }

    void addMentions(List<? extends Mentionable> mentions) {
        if (mentions == null || mentions.isEmpty()) {
            throw new IllegalArgumentException("Appended Mentions cannot be null nor empty.");
        }
        if (StringUtils.isBlank((CharSequence)this.editText.getText()) || !this.textHasMentions(mentions)) {
            throw new IllegalArgumentException("Appended Mentions must be in the edit text.");
        }
        this.mentions.addAll(mentions);
        this.highlightMentionsText();
    }

    void setTextHighlightColor(int textHighlightColor) {
        this.textHighlightColor = textHighlightColor;
    }

    void insertMention(Mentionable mention) {
        this.checkMentionable(mention);
        mention.setMentionLength(mention.getMentionName().length());
        int cursorPosition = this.editText.getSelectionEnd();
        String text = this.editText.getText().toString();
        String toReplace = text.substring(0, cursorPosition);
        int start = toReplace.lastIndexOf("@");
        if (start != -1) {
            int newCursorPosition = start + Html.fromHtml((String)mention.getMentionName().toString()).length();
            this.editText.getText().delete(start, cursorPosition);
            this.editText.getText().insert(start, (CharSequence)Html.fromHtml((String)mention.getMentionName().toString()));
            int originalInputType = this.editText.getInputType();
            this.editText.setInputType(524288);
            this.editText.setInputType(originalInputType);
            this.editText.setSelection(newCursorPosition);
            this.addMentionToInternalArray(mention, start);
            this.highlightMentionsText();
        }
    }

    private void checkMentionable(Mentionable mentionable) {
        if (mentionable == null) {
            throw new IllegalArgumentException("A null mentionable cannot be inserted into the EditText view");
        }
        if (StringUtils.isBlank(mentionable.getMentionName())) {
            throw new IllegalArgumentException("The mentions name must be set before inserting into the EditText view.");
        }
    }

    void addMentionToInternalArray(Mentionable mention, int start) {
        if (mention != null) {
            mention.setMentionOffset(start);
            this.mentions.add(mention);
        }
    }

    void checkIfProgrammaticallyClearedEditText(CharSequence charSequence, int start, int count, int after) {
        if (StringUtils.isNotBlank(charSequence) && start == 0 && count == charSequence.length() && after == 0) {
            this.mentions.clear();
        }
    }

    void updateInternalMentionsArray(int start, int before, int count) {
        if (!this.mentions.isEmpty() && before != count) {
            Iterator<Mentionable> iterator = this.mentions.iterator();
            while (iterator.hasNext()) {
                Mentionable mention = iterator.next();
                int mentionStart = mention.getMentionOffset();
                int mentionEnd = mentionStart + mention.getMentionLength();
                int editPos = start + count;
                if (start <= mentionStart) {
                    int diff = count - before;
                    mention.setMentionOffset(mentionStart + diff);
                    continue;
                }
                if (editPos <= mentionStart + 1 || editPos >= mentionEnd) continue;
                iterator.remove();
            }
            this.highlightMentionsText();
        }
    }

    private void highlightMentionsText() {
        ForegroundColorSpan[] spans;
        for (ForegroundColorSpan span : spans = (ForegroundColorSpan[])this.editText.getEditableText().getSpans(0, this.editText.getText().length(), ForegroundColorSpan.class)) {
            this.editText.getEditableText().removeSpan((Object)span);
        }
        if (!this.mentions.isEmpty()) {
            Iterator<Mentionable> iterator = this.mentions.iterator();
            while (iterator.hasNext()) {
                Mentionable mention = iterator.next();
                try {
                    int start = mention.getMentionOffset();
                    int end = start + mention.getMentionLength();
                    if (this.editText.length() >= end && StringUtils.equals(this.editText.getText().subSequence(start, end), mention.getMentionName())) {
                        ForegroundColorSpan highlightSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)this.editText.getContext(), (int)this.textHighlightColor));
                        this.editText.getEditableText().setSpan((Object)highlightSpan, start, end, 33);
                        continue;
                    }
                    Log.w((String)"Mentions", (String)("Mention lost. [" + mention.getMentionName() + "]"));
                    iterator.remove();
                }
                catch (Exception ex) {
                    Log.e((String)"Mentions", (String)("Mention removed due to exception. + [" + mention.getMentionName() + "]"), (Throwable)ex);
                    iterator.remove();
                }
            }
        }
    }

    private boolean textHasMentions(List<? extends Mentionable> mentions) {
        if (this.editText != null && mentions != null && !mentions.isEmpty()) {
            for (Mentionable mentionable : mentions) {
                String displayText;
                int mentionStart = mentionable.getMentionOffset();
                int mentionEnd = mentionable.getMentionLength();
                if (mentionEnd > this.editText.getText().length() || !StringUtils.isBlank(displayText = StringUtils.substring(this.editText.getText().toString(), mentionStart, mentionStart + mentionEnd)) && StringUtils.equals(displayText, mentionable.getMentionName())) continue;
                return false;
            }
        }
        return true;
    }
}

