/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.mentions;

import android.widget.EditText;
import com.hippoagent.mentions.StringUtils;

class MentionCheckerLogic {
    private final EditText editText;
    protected int maxCharacters = 13;

    MentionCheckerLogic(EditText editText) {
        this.editText = editText;
    }

    void setMaxCharacters(int maxCharacters) {
        if (maxCharacters <= 0) {
            throw new IllegalArgumentException("Maximum number of characters must be greater than 0.");
        }
        this.maxCharacters = maxCharacters;
    }

    String doMentionCheck() {
        String queryToken = null;
        if (StringUtils.contains((CharSequence)this.editText.getText(), "@")) {
            int atSymbolPosition;
            int cursorPosition = this.editText.getSelectionStart();
            String allTextBeforeCursor = this.editText.getText().toString().substring(0, cursorPosition);
            String providedSearchText = StringUtils.substringAfterLast(allTextBeforeCursor, "@");
            if (this.searchIsWithinMaxChars(providedSearchText, this.maxCharacters) && ((atSymbolPosition = StringUtils.lastIndexOf(allTextBeforeCursor, "@")) == 0 || this.spaceBeforeAtSymbol(allTextBeforeCursor, atSymbolPosition))) {
                queryToken = providedSearchText;
            }
        }
        return queryToken;
    }

    private boolean spaceBeforeAtSymbol(String currentTextBeforeCursor, int atSymbolPosition) {
        char charBeforeAtSymbol;
        return atSymbolPosition > 0 && Character.isWhitespace(charBeforeAtSymbol = currentTextBeforeCursor.charAt(atSymbolPosition - 1));
    }

    private boolean searchIsWithinMaxChars(String providedSearchText, int maxCharacters) {
        return providedSearchText.length() >= 0 && providedSearchText.length() <= maxCharacters;
    }

    private boolean searchBeginsWithAlphaNumericChar(String providedSearchText) {
        return Character.isLetterOrDigit(providedSearchText.charAt(0));
    }

    boolean currentWordStartsWithAtSign() {
        int end;
        int start = this.editText.getSelectionStart();
        if (start == (end = this.editText.getSelectionEnd()) && this.editText.length() >= start) {
            String text = this.editText.getText().toString().substring(0, start);
            if (StringUtils.startsWith(text = StringUtils.substringAfterLast(text, " "), "@")) {
                return true;
            }
        }
        return false;
    }
}

