/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.helper;

import android.app.Activity;
import com.google.gson.Gson;
import com.hippoagent.MyApplication;
import com.hippoagent.callback.OnAgentParseCallback;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.eventbus.FragmentEvent;
import com.hippoagent.eventbus.UpdateEvent;
import com.hippoagent.helper.ParseAgents;
import com.hippoagent.model.GetAgentsResponse;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.model.gettags.GetTagsResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.filelogger.Logger;
import io.paperdb.Paper;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import retrofit2.Callback;

public class ConversationApiHelper {
    private Activity activity;

    public void getConversationData() {
    }

    public void apiGetAgents() {
        CommonParams commonParams = new CommonParams.Builder().add("access_token", MyApplication.getInstance().getUserData().getAccessToken()).add("business_id", String.valueOf(MyApplication.getInstance().getUserData().getBusinessId())).build();
        String value = new Gson().toJson(commonParams.getMap());
        Logger.INSTANCE.apiRequest("/api/agent/getAgents", value);
        RestClient.getApiInterface().getAgents(commonParams.getMap()).enqueue((Callback)new ResponseResolver<GetAgentsResponse>(this.activity, Boolean.valueOf(false), Boolean.valueOf(true)){

            @Override
            public void success(GetAgentsResponse getAgentsResponse) {
                block6: {
                    try {
                        Logger.INSTANCE.apiResponse("/api/agent/getAgents", "");
                        if (getAgentsResponse != null && getAgentsResponse.getData() != null && getAgentsResponse.getData().getAgents() != null && getAgentsResponse.getData().getAgents().size() > 0) {
                            ConversationApiHelper.this.parseAgentData(getAgentsResponse);
                            break block6;
                        }
                        getAgentsResponse.getData().setAgents(new ArrayList<GetAgentsResponse.Agents>());
                        try {
                            if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getAgentsResponse.getStatuscode()) {
                                Paper.book((String)CommonData.name).write("agents", (Object)getAgentsResponse);
                                MyApplication.getInstance().setAgentsResponse(getAgentsResponse);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void failure(APIError error) {
                Log.e("error", "error");
                Logger.INSTANCE.apiFailed("/api/agent/getAgents", error.getMessage());
            }
        });
    }

    private void parseAgentData(final GetAgentsResponse getAgentsResponse) throws Exception {
        new ParseAgents(new OnAgentParseCallback(){

            @Override
            public void onCallbackListener(@NotNull ArrayList<GetAgentsResponse.Agents> allAgents) {
                getAgentsResponse.getData().setAgents(allAgents);
                try {
                    if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getAgentsResponse.getStatuscode()) {
                        Paper.book((String)CommonData.name).write("agents", (Object)getAgentsResponse);
                        MyApplication.getInstance().setAgentsResponse(getAgentsResponse);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).execute(new GetAgentsResponse[]{getAgentsResponse});
    }

    public void getAgentData() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", String.valueOf(MyApplication.getInstance().getUserData().getAccessToken()));
        params.put("en_user_id", String.valueOf(MyApplication.getInstance().getUserData().getEnUserId()));
        CommonParams commonParams = new CommonParams.Builder().addAll(params).build();
        Logger.INSTANCE.apiRequest("/api/agent/getInfo", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getAgentInfo(commonParams.getMap()).enqueue((Callback)new ResponseResolver<AgentProfileDetails>(this.activity, Boolean.valueOf(false), Boolean.valueOf(true)){

            @Override
            public void success(AgentProfileDetails agentProfileDetails) {
                Logger.INSTANCE.apiResponse("/api/agent/getInfo", "");
                try {
                    Paper.book((String)CommonData.name).delete("agent_data");
                    Paper.book((String)CommonData.name).write("agent_data", (Object)agentProfileDetails);
                    MyApplication.getInstance().setAgentProfileDetails(agentProfileDetails);
                    BusProvider.getInstance().post((Object)new FragmentEvent(2, 2));
                }
                catch (Exception e) {
                    Logger.INSTANCE.apiFailed("/api/agent/getInfo", e.getLocalizedMessage());
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("/api/agent/getInfo", error.getMessage());
            }
        });
    }

    public void updateTnCstatus() {
        CommonParams commonParams = new CommonParams.Builder().add("access_token", MyApplication.getInstance().getUserData().getAccessToken()).add("terms_and_conditions", 1).build();
        Logger.INSTANCE.apiRequest("/api/agent/editConfiguration", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().setTnCStatus(commonParams.getMap()).enqueue((Callback)new ResponseResolver<GetTagsResponse>(){

            @Override
            public void success(GetTagsResponse getTagsResponse) {
                Logger.INSTANCE.apiResponse("/api/agent/editConfiguration", "");
                try {
                    if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getTagsResponse.getStatusCode().intValue()) {
                        MyApplication.getInstance().getUserData().getUserProperties().setTermsAndConditions(1);
                    }
                }
                catch (Exception e) {
                    BusProvider.getInstance().post((Object)new UpdateEvent(3));
                    Logger.INSTANCE.apiFailed("/api/agent/editConfiguration", e.getLocalizedMessage());
                }
            }

            @Override
            public void failure(APIError error) {
                BusProvider.getInstance().post((Object)new UpdateEvent(3));
                Logger.INSTANCE.apiFailed("/api/agent/editConfiguration", error.getMessage());
            }
        });
    }
}

